/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.awt.Paint;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.chart.DRIChartCustomizer;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class GroupedStackedBarRendererCustomizer
implements DRIChartCustomizer,
Serializable {
    private static final long serialVersionUID = 10000L;
    public static final String GROUP_SERIES_KEY = "-{group-series}-";
    private KeyToGroupMap map;
    private Map<String, Paint> seriesColors;

    /*
     * WARNING - void declaration
     */
    @Override
    public void customize(JFreeChart chart, ReportParameters reportParameters) {
        void var8_13;
        this.seriesColors = new LinkedHashMap<String, Paint>();
        this.map = null;
        LinkedHashSet<Object> groups = new LinkedHashSet<Object>();
        CategoryDataset dataset = chart.getCategoryPlot().getDataset();
        int i = 0;
        while (i < dataset.getRowCount()) {
            String rowKey = (String)((Object)dataset.getRowKey(i));
            String group = StringUtils.substringBefore((String)rowKey, (String)GROUP_SERIES_KEY);
            String string = StringUtils.substringAfter((String)rowKey, (String)GROUP_SERIES_KEY);
            if (this.map == null) {
                this.map = new KeyToGroupMap((Comparable)((Object)group));
            }
            this.map.mapKeyToGroup((Comparable)((Object)rowKey), (Comparable)((Object)group));
            groups.add(group);
            if (!this.seriesColors.containsKey(string)) {
                Paint paint = chart.getCategoryPlot().getDrawingSupplier().getNextPaint();
                this.seriesColors.put(string, paint);
            }
            ++i;
        }
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        for (Object column : dataset.getColumnKeys()) {
            for (String string : groups) {
                for (String string2 : this.seriesColors.keySet()) {
                    try {
                        Number value = dataset.getValue((Comparable)((Object)(String.valueOf(string) + GROUP_SERIES_KEY + string2)), (Comparable)column);
                        newDataset.addValue(value, (Comparable)((Object)(String.valueOf(string) + GROUP_SERIES_KEY + string2)), (Comparable)column);
                    }
                    catch (UnknownKeyException unknownKeyException) {
                        newDataset.addValue(0.0, (Comparable)((Object)(String.valueOf(string) + GROUP_SERIES_KEY + string2)), (Comparable)column);
                    }
                }
            }
        }
        dataset = newDataset;
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        renderer.setSeriesToGroupMap(this.map);
        StackedBarRenderer categoryRenderer = (StackedBarRenderer)chart.getCategoryPlot().getRenderer();
        renderer.setBaseItemLabelsVisible(categoryRenderer.getBaseItemLabelsVisible());
        renderer.setBaseItemLabelFont(categoryRenderer.getBaseItemLabelFont());
        renderer.setBaseItemLabelPaint(categoryRenderer.getBaseItemLabelPaint());
        renderer.setBaseItemLabelGenerator(categoryRenderer.getBaseItemLabelGenerator());
        renderer.setShadowVisible(categoryRenderer.getShadowsVisible());
        renderer.setItemMargin(0.1);
        renderer.setDrawBarOutline(false);
        boolean bl = false;
        while (var8_13 < dataset.getRowCount()) {
            String rowKey = (String)((Object)dataset.getRowKey((int)var8_13));
            String string = StringUtils.substringAfter((String)rowKey, (String)GROUP_SERIES_KEY);
            renderer.setSeriesPaint((int)var8_13, this.seriesColors.get(string));
            ++var8_13;
        }
        CategoryAxis categoryAxis = chart.getCategoryPlot().getDomainAxis();
        SubCategoryAxis newDomainAxis = new SubCategoryAxis(categoryAxis.getLabel());
        newDomainAxis.setLabelFont(categoryAxis.getLabelFont());
        newDomainAxis.setTickLabelFont(categoryAxis.getTickLabelFont());
        newDomainAxis.setLabelPaint(categoryAxis.getLabelPaint());
        newDomainAxis.setTickLabelPaint(categoryAxis.getTickLabelPaint());
        newDomainAxis.setAxisLinePaint(categoryAxis.getAxisLinePaint());
        newDomainAxis.setTickMarkPaint(categoryAxis.getTickMarkPaint());
        newDomainAxis.setTickLabelsVisible(categoryAxis.isTickLabelsVisible());
        newDomainAxis.setTickMarksVisible(categoryAxis.isTickMarksVisible());
        newDomainAxis.setCategoryMargin(0.05);
        for (String string : groups) {
            newDomainAxis.addSubCategory((Comparable)((Object)string));
        }
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        categoryPlot.setDomainAxis((CategoryAxis)newDomainAxis);
        categoryPlot.setRenderer((CategoryItemRenderer)renderer);
        LegendItemCollection legendItems = new LegendItemCollection();
        for (String item : this.seriesColors.keySet()) {
            legendItems.add(new LegendItem(item, this.seriesColors.get(item)));
        }
        categoryPlot.setFixedLegendItems(legendItems);
        chart.getCategoryPlot().setDataset(dataset);
    }
}

