/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.chartcustomizer;

import java.io.Serializable;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

public class PercentageCategoryDataset
implements CategoryDataset,
Serializable {
    private static final long serialVersionUID = 10000L;
    protected CategoryDataset dataset;

    public PercentageCategoryDataset(CategoryDataset dataset) {
        this.dataset = dataset;
    }

    public Comparable<?> getRowKey(int row) {
        return this.dataset.getRowKey(row);
    }

    public int getRowIndex(Comparable key) {
        return this.dataset.getRowIndex(key);
    }

    public List<?> getRowKeys() {
        return this.dataset.getRowKeys();
    }

    public Comparable<?> getColumnKey(int column) {
        return this.dataset.getColumnKey(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.dataset.getColumnIndex(key);
    }

    public List<?> getColumnKeys() {
        return this.dataset.getColumnKeys();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getValue(this.getRowIndex(rowKey), this.getColumnIndex(columnKey));
    }

    public int getRowCount() {
        return this.dataset.getRowCount();
    }

    public int getColumnCount() {
        return this.dataset.getColumnCount();
    }

    public Number getValue(int row, int column) {
        double total = 0.0;
        int i = 0;
        while (i < this.getRowCount()) {
            Number value = this.dataset.getValue(i, column);
            if (value != null) {
                total += value.doubleValue();
            }
            ++i;
        }
        Number value = this.dataset.getValue(row, column);
        if (value == null) {
            return 0;
        }
        double actual = value.doubleValue();
        if (total > 0.0) {
            return actual / total * 100.0;
        }
        return 0;
    }

    public void addChangeListener(DatasetChangeListener listener) {
        this.dataset.addChangeListener(listener);
    }

    public void removeChangeListener(DatasetChangeListener listener) {
        this.dataset.removeChangeListener(listener);
    }

    public DatasetGroup getGroup() {
        return this.dataset.getGroup();
    }

    public void setGroup(DatasetGroup group) {
        this.dataset.setGroup(group);
    }
}

