/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.design.transformation.expressions;

import java.util.List;
import net.sf.dynamicreports.report.builder.expression.AbstractComplexExpression;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;

public class GroupedSeriesExpression
extends AbstractComplexExpression<String> {
    private static final long serialVersionUID = 10000L;

    public GroupedSeriesExpression(DRIExpression<?> groupExpression, DRIExpression<?> seriesExpression, DRIExpression<?> labelExpression, int index) {
        if (groupExpression != null) {
            this.addExpression(groupExpression);
        } else {
            this.addExpression(Expressions.text("group"));
        }
        if (seriesExpression != null) {
            this.addExpression(seriesExpression);
        } else if (labelExpression != null) {
            this.addExpression(labelExpression);
        } else {
            this.addExpression(Expressions.text("serie" + index));
        }
    }

    @Override
    public String evaluate(List<?> values, ReportParameters reportParameters) {
        String group = (String)values.get(0);
        String series = (String)values.get(1);
        return String.valueOf(group) + "-{group-series}-" + series;
    }
}

