/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import net.sf.dynamicreports.design.constant.EvaluationTime;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignBarbecue;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignBarcode4j;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignCodabarBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignCode128Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignCode39Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignDataMatrixBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignEan128Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignEan13Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignEan8Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignInterleaved2Of5Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignPdf417Barcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignPostnetBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignQrCode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignRoyalMailCustomerBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignUpcaBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignUpceBarcode;
import net.sf.dynamicreports.design.definition.barcode.DRIDesignUspsIntelligentMailBarcode;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.QRCodeComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;

public class BarcodeTransform {
    private JasperTransformAccessor accessor;

    public BarcodeTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    protected JRDesignElement transform(DRIDesignBarcode barcode) {
        JRDesignComponentElement jrComponent = new JRDesignComponentElement();
        jrComponent.setComponent((Component)this.barcodeComponent(barcode));
        jrComponent.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", barcode.getName()));
        return jrComponent;
    }

    protected JRDesignElement transform(DRIDesignBarbecue barbecue) {
        JRDesignComponentElement jrComponent = new JRDesignComponentElement();
        jrComponent.setComponent((Component)this.barbecueComponent(barbecue));
        jrComponent.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", barbecue.getName()));
        return jrComponent;
    }

    private BarcodeComponent barcodeComponent(DRIDesignBarcode barcode) {
        if (barcode instanceof DRIDesignCodabarBarcode) {
            return this.codabar((DRIDesignCodabarBarcode)barcode);
        }
        if (barcode instanceof DRIDesignCode128Barcode) {
            return this.code128((DRIDesignCode128Barcode)barcode);
        }
        if (barcode instanceof DRIDesignEan128Barcode) {
            return this.ean128((DRIDesignEan128Barcode)barcode);
        }
        if (barcode instanceof DRIDesignDataMatrixBarcode) {
            return this.dataMatrix((DRIDesignDataMatrixBarcode)barcode);
        }
        if (barcode instanceof DRIDesignCode39Barcode) {
            return this.code39((DRIDesignCode39Barcode)barcode);
        }
        if (barcode instanceof DRIDesignInterleaved2Of5Barcode) {
            return this.interleaved2Of5((DRIDesignInterleaved2Of5Barcode)barcode);
        }
        if (barcode instanceof DRIDesignUpcaBarcode) {
            return this.upca((DRIDesignUpcaBarcode)barcode);
        }
        if (barcode instanceof DRIDesignUpceBarcode) {
            return this.upce((DRIDesignUpceBarcode)barcode);
        }
        if (barcode instanceof DRIDesignEan13Barcode) {
            return this.ean13((DRIDesignEan13Barcode)barcode);
        }
        if (barcode instanceof DRIDesignEan8Barcode) {
            return this.ean8((DRIDesignEan8Barcode)barcode);
        }
        if (barcode instanceof DRIDesignUspsIntelligentMailBarcode) {
            return this.uspsIntelligentMail((DRIDesignUspsIntelligentMailBarcode)barcode);
        }
        if (barcode instanceof DRIDesignRoyalMailCustomerBarcode) {
            return this.royalMailCustomer((DRIDesignRoyalMailCustomerBarcode)barcode);
        }
        if (barcode instanceof DRIDesignPostnetBarcode) {
            return this.postnet((DRIDesignPostnetBarcode)barcode);
        }
        if (barcode instanceof DRIDesignPdf417Barcode) {
            return this.pdf417((DRIDesignPdf417Barcode)barcode);
        }
        if (barcode instanceof DRIDesignQrCode) {
            return this.qrCode((DRIDesignQrCode)barcode);
        }
        throw new JasperDesignException("Barcode " + barcode.getClass().getName() + " not supported");
    }

    private BarbecueComponent barbecueComponent(DRIDesignBarbecue barbecue) {
        StandardBarbecueComponent jrBarbecue = new StandardBarbecueComponent();
        EvaluationTime evaluationTime = barbecue.getEvaluationTime();
        jrBarbecue.setEvaluationTimeValue(ConstantTransform.evaluationTime(evaluationTime));
        if (evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP) && barbecue.getEvaluationGroup() != null) {
            jrBarbecue.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(barbecue.getEvaluationGroup()).getName());
        }
        jrBarbecue.setType(ConstantTransform.barbecueType(barbecue.getType()));
        jrBarbecue.setCodeExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(barbecue.getCodeExpression()));
        jrBarbecue.setApplicationIdentifierExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(barbecue.getApplicationIdentifierExpression()));
        if (barbecue.getDrawText() != null) {
            jrBarbecue.setDrawText(barbecue.getDrawText().booleanValue());
        }
        if (barbecue.getChecksumRequired() != null) {
            jrBarbecue.setChecksumRequired(barbecue.getChecksumRequired().booleanValue());
        }
        jrBarbecue.setBarWidth(barbecue.getBarWidth());
        jrBarbecue.setBarHeight(barbecue.getBarHeight());
        if (barbecue.getOrientation() != null) {
            jrBarbecue.setRotation(ConstantTransform.barbecueRotation(barbecue.getOrientation()));
        }
        return jrBarbecue;
    }

    private void barcode(BarcodeComponent jrBarcode, DRIDesignBarcode barcode) {
        EvaluationTime evaluationTime = barcode.getEvaluationTime();
        jrBarcode.setEvaluationTimeValue(ConstantTransform.evaluationTime(evaluationTime));
        if (evaluationTime != null && evaluationTime.equals((Object)EvaluationTime.GROUP) && barcode.getEvaluationGroup() != null) {
            jrBarcode.setEvaluationGroup(this.accessor.getGroupTransform().getGroup(barcode.getEvaluationGroup()).getName());
        }
        jrBarcode.setCodeExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(barcode.getCodeExpression()));
    }

    private void barcode4j(Barcode4jComponent jrBarcode4j, DRIDesignBarcode4j barcode4j) {
        this.barcode((BarcodeComponent)jrBarcode4j, barcode4j);
        jrBarcode4j.setPatternExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(barcode4j.getPatternExpression()));
        jrBarcode4j.setModuleWidth(barcode4j.getModuleWidth());
        if (barcode4j.getOrientation() != null) {
            jrBarcode4j.setOrientation(ConstantTransform.barcodeOrientation(barcode4j.getOrientation()));
        }
        jrBarcode4j.setTextPosition(ConstantTransform.barcodeTextPosition(barcode4j.getTextPosition()));
        jrBarcode4j.setQuietZone(barcode4j.getQuietZone());
        jrBarcode4j.setVerticalQuietZone(barcode4j.getVerticalQuietZone());
    }

    private Barcode4jComponent codabar(DRIDesignCodabarBarcode barcode) {
        CodabarComponent jrBarcode = new CodabarComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setWideFactor(barcode.getWideFactor());
        return jrBarcode;
    }

    private Barcode4jComponent code128(DRIDesignCode128Barcode barcode) {
        Code128Component jrBarcode = new Code128Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        return jrBarcode;
    }

    private Barcode4jComponent ean128(DRIDesignEan128Barcode barcode) {
        EAN128Component jrBarcode = new EAN128Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        return jrBarcode;
    }

    private Barcode4jComponent dataMatrix(DRIDesignDataMatrixBarcode barcode) {
        DataMatrixComponent jrBarcode = new DataMatrixComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setShape(ConstantTransform.barcodeShape(barcode.getShape()));
        return jrBarcode;
    }

    private Barcode4jComponent code39(DRIDesignCode39Barcode barcode) {
        Code39Component jrBarcode = new Code39Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        jrBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        jrBarcode.setDisplayStartStop(barcode.getDisplayStartStop());
        jrBarcode.setExtendedCharSetEnabled(barcode.getExtendedCharSetEnabled());
        jrBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        jrBarcode.setWideFactor(barcode.getWideFactor());
        return jrBarcode;
    }

    private Barcode4jComponent interleaved2Of5(DRIDesignInterleaved2Of5Barcode barcode) {
        Interleaved2Of5Component jrBarcode = new Interleaved2Of5Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        jrBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        jrBarcode.setWideFactor(barcode.getWideFactor());
        return jrBarcode;
    }

    private Barcode4jComponent upca(DRIDesignUpcaBarcode barcode) {
        UPCAComponent jrBarcode = new UPCAComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        return jrBarcode;
    }

    private Barcode4jComponent upce(DRIDesignUpceBarcode barcode) {
        UPCEComponent jrBarcode = new UPCEComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        return jrBarcode;
    }

    private Barcode4jComponent ean13(DRIDesignEan13Barcode barcode) {
        EAN13Component jrBarcode = new EAN13Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        return jrBarcode;
    }

    private Barcode4jComponent ean8(DRIDesignEan8Barcode barcode) {
        EAN8Component jrBarcode = new EAN8Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        return jrBarcode;
    }

    private Barcode4jComponent uspsIntelligentMail(DRIDesignUspsIntelligentMailBarcode barcode) {
        USPSIntelligentMailComponent jrBarcode = new USPSIntelligentMailComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        jrBarcode.setAscenderHeight(barcode.getAscenderHeight());
        jrBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        jrBarcode.setTrackHeight(barcode.getTrackHeight());
        return jrBarcode;
    }

    private Barcode4jComponent royalMailCustomer(DRIDesignRoyalMailCustomerBarcode barcode) {
        RoyalMailCustomerComponent jrBarcode = new RoyalMailCustomerComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()));
        jrBarcode.setAscenderHeight(barcode.getAscenderHeight());
        jrBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        jrBarcode.setTrackHeight(barcode.getTrackHeight());
        return jrBarcode;
    }

    private Barcode4jComponent postnet(DRIDesignPostnetBarcode barcode) {
        POSTNETComponent jrBarcode = new POSTNETComponent();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        if (barcode.getChecksumMode() != null) {
            jrBarcode.setChecksumMode(ConstantTransform.barcodeChecksumMode(barcode.getChecksumMode()).getName());
        }
        jrBarcode.setDisplayChecksum(barcode.getDisplayChecksum());
        jrBarcode.setShortBarHeight(barcode.getShortBarHeight());
        if (barcode.getBaselinePosition() != null) {
            jrBarcode.setBaselinePosition(ConstantTransform.barcodeBaselinePosition(barcode.getBaselinePosition()).getName());
        }
        jrBarcode.setIntercharGapWidth(barcode.getIntercharGapWidth());
        return jrBarcode;
    }

    private Barcode4jComponent pdf417(DRIDesignPdf417Barcode barcode) {
        PDF417Component jrBarcode = new PDF417Component();
        this.barcode4j((Barcode4jComponent)jrBarcode, barcode);
        jrBarcode.setMinColumns(barcode.getMinColumns());
        jrBarcode.setMaxColumns(barcode.getMaxColumns());
        jrBarcode.setMinRows(barcode.getMinRows());
        jrBarcode.setMaxRows(barcode.getMaxRows());
        jrBarcode.setWidthToHeightRatio(barcode.getWidthToHeightRatio());
        jrBarcode.setErrorCorrectionLevel(barcode.getErrorCorrectionLevel());
        return jrBarcode;
    }

    private QRCodeComponent qrCode(DRIDesignQrCode qrCode) {
        QRCodeComponent jrQrCode = new QRCodeComponent();
        this.barcode((BarcodeComponent)jrQrCode, qrCode);
        jrQrCode.setMargin(qrCode.getMargin());
        jrQrCode.setErrorCorrectionLevel(ConstantTransform.qrCodeErrorCorrectionLevel(qrCode.getErrorCorrectionLevel()));
        return jrQrCode;
    }
}

