/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.util.Map;
import net.sf.dynamicreports.design.constant.ResetType;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstab;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabCell;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabCellContent;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabColumnGroup;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabDataset;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabGroup;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabMeasure;
import net.sf.dynamicreports.design.definition.crosstab.DRIDesignCrosstabRowGroup;
import net.sf.dynamicreports.jasper.base.JasperCustomValues;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.dynamicreports.jasper.transformation.expression.CrosstabParametersExpression;
import net.sf.dynamicreports.report.constant.ListType;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;

public class CrosstabTransform {
    private JasperTransformAccessor accessor;

    public CrosstabTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    /*
     * WARNING - void declaration
     */
    protected JRDesignElement transform(DRIDesignCrosstab crosstab) {
        void var3_13;
        JRDesignCrosstab jrCrosstab = new JRDesignCrosstab();
        this.dataset(crosstab.getDataset(), jrCrosstab.getDesignDataset());
        this.accessor.transformToDataset(crosstab.getDataset().getSubDataset());
        if (crosstab.isRepeatColumnHeaders() != null) {
            jrCrosstab.setRepeatColumnHeaders(crosstab.isRepeatColumnHeaders().booleanValue());
        }
        if (crosstab.isRepeatRowHeaders() != null) {
            jrCrosstab.setRepeatRowHeaders(crosstab.isRepeatRowHeaders().booleanValue());
        }
        if (crosstab.getColumnBreakOffset() != null) {
            jrCrosstab.setColumnBreakOffset(crosstab.getColumnBreakOffset().intValue());
        }
        jrCrosstab.setIgnoreWidth(crosstab.getIgnoreWidth());
        jrCrosstab.setRunDirection(ConstantTransform.runDirection(crosstab.getRunDirection()));
        jrCrosstab.setWhenNoDataCell(this.cellContent(crosstab.getWhenNoDataCell()));
        jrCrosstab.setHeaderCell(this.cellContent(crosstab.getHeaderCell()));
        for (DRIDesignCrosstabColumnGroup dRIDesignCrosstabColumnGroup : crosstab.getColumnGroups()) {
            this.addColumnGroup(jrCrosstab, dRIDesignCrosstabColumnGroup);
        }
        for (DRIDesignCrosstabRowGroup dRIDesignCrosstabRowGroup : crosstab.getRowGroups()) {
            this.addRowGroup(jrCrosstab, dRIDesignCrosstabRowGroup);
        }
        for (DRIDesignCrosstabCell dRIDesignCrosstabCell : crosstab.getCells()) {
            this.addCell(jrCrosstab, dRIDesignCrosstabCell);
        }
        for (DRIDesignCrosstabMeasure dRIDesignCrosstabMeasure : crosstab.getMeasures()) {
            this.addMeasure(jrCrosstab, dRIDesignCrosstabMeasure);
        }
        this.registerScriptletCrosstabParameter(jrCrosstab);
        this.accessor.transformToMainDataset();
        if (crosstab.getDataset().getSubDataset() == null) {
            Map<String, Object> map = this.accessor.getParameters();
        } else {
            Map<String, Object> map = this.accessor.getDatasetTransform().getDatasetParameters(crosstab.getDataset().getSubDataset());
        }
        CrosstabParametersExpression parametersExpression = new CrosstabParametersExpression((Map<String, Object>)var3_13);
        this.accessor.getExpressionTransform().addSimpleExpression(parametersExpression);
        jrCrosstab.setParametersMapExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(parametersExpression));
        return jrCrosstab;
    }

    private void registerScriptletCrosstabParameter(JRDesignCrosstab jrCrosstab) {
        JRDesignCrosstabParameter jrParameter = new JRDesignCrosstabParameter();
        jrParameter.setName("CUSTOM_VALUES");
        jrParameter.setValueClass(JasperCustomValues.class);
        try {
            jrCrosstab.addParameter((JRCrosstabParameter)jrParameter);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for scriptlet crosstab parameter", e);
        }
    }

    private void dataset(DRIDesignCrosstabDataset dataset, JRDesignCrosstabDataset jrDataset) {
        jrDataset.setDatasetRun((JRDatasetRun)this.accessor.getDatasetTransform().datasetRun(dataset.getSubDataset()));
        if (dataset.getDataPreSorted() != null) {
            jrDataset.setDataPreSorted(dataset.getDataPreSorted().booleanValue());
        }
        ResetType resetType = dataset.getResetType();
        jrDataset.setResetType(ConstantTransform.variableResetType(resetType));
        if (resetType.equals((Object)ResetType.GROUP) && dataset.getResetGroup() != null) {
            jrDataset.setResetGroup((JRGroup)this.accessor.getGroupTransform().getGroup(dataset.getResetGroup()));
        }
    }

    private JRDesignCellContents cellContent(DRIDesignCrosstabCellContent cellContent) {
        JRDesignElement[] jrElements;
        if (cellContent == null || cellContent.getComponent() == null) {
            return null;
        }
        JRDesignCellContents jrCellContents = new JRDesignCellContents();
        JRDesignElement[] jRDesignElementArray = jrElements = this.accessor.getComponentTransform().component(cellContent.getComponent(), ListType.VERTICAL);
        int n = jrElements.length;
        int n2 = 0;
        while (n2 < n) {
            JRDesignElement jrElement = jRDesignElementArray[n2];
            jrCellContents.addElement(jrElement);
            ++n2;
        }
        jrCellContents.setStyle((JRStyle)this.accessor.getStyleTransform().getStyle(cellContent.getStyle()));
        return jrCellContents;
    }

    private void group(JRDesignCrosstabGroup jrGroup, DRIDesignCrosstabGroup group) {
        jrGroup.setName(group.getName());
        jrGroup.setTotalPosition(ConstantTransform.crosstabTotalPosition(group.getTotalPosition()));
        jrGroup.setBucket(this.bucket(group));
        jrGroup.setHeader(this.cellContent(group.getHeader()));
        jrGroup.setTotalHeader(this.cellContent(group.getTotalHeader()));
    }

    private JRDesignCrosstabBucket bucket(DRIDesignCrosstabGroup group) {
        JRDesignCrosstabBucket jrBucket = new JRDesignCrosstabBucket();
        if (group.getOrderType() != null) {
            jrBucket.setOrder(ConstantTransform.bucketOrderType(group.getOrderType()));
        }
        jrBucket.setExpression(this.accessor.getExpressionTransform().getExpression(group.getExpression()));
        jrBucket.setOrderByExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(group.getOrderByExpression()));
        jrBucket.setComparatorExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(group.getComparatorExpression()));
        jrBucket.setValueClassName(group.getExpression().getValueClass().getName());
        return jrBucket;
    }

    private void addColumnGroup(JRDesignCrosstab jrCrosstab, DRIDesignCrosstabColumnGroup columnGroup) {
        JRDesignCrosstabColumnGroup jrColumnGroup = new JRDesignCrosstabColumnGroup();
        this.group((JRDesignCrosstabGroup)jrColumnGroup, columnGroup);
        jrColumnGroup.setHeight(columnGroup.getHeight());
        jrColumnGroup.setPosition(CrosstabColumnPositionEnum.STRETCH);
        try {
            jrCrosstab.addColumnGroup(jrColumnGroup);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for crosstab column group \"" + columnGroup.getName() + "\"", e);
        }
    }

    private void addRowGroup(JRDesignCrosstab jrCrosstab, DRIDesignCrosstabRowGroup rowGroup) {
        JRDesignCrosstabRowGroup jrRowGroup = new JRDesignCrosstabRowGroup();
        this.group((JRDesignCrosstabGroup)jrRowGroup, rowGroup);
        jrRowGroup.setWidth(rowGroup.getWidth());
        jrRowGroup.setPosition(CrosstabRowPositionEnum.STRETCH);
        try {
            jrCrosstab.addRowGroup(jrRowGroup);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for crosstab row group \"" + rowGroup.getName() + "\"", e);
        }
    }

    private void addCell(JRDesignCrosstab jrCrosstab, DRIDesignCrosstabCell cell) {
        JRDesignCrosstabCell jrCell = new JRDesignCrosstabCell();
        jrCell.setWidth(Integer.valueOf(cell.getContent().getWidth()));
        jrCell.setHeight(Integer.valueOf(cell.getContent().getHeight()));
        jrCell.setRowTotalGroup(cell.getRowTotalGroup());
        jrCell.setColumnTotalGroup(cell.getColumnTotalGroup());
        jrCell.setContents(this.cellContent(cell.getContent()));
        try {
            jrCrosstab.addCell(jrCell);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for crosstab cell \"" + cell.getName() + "\"", e);
        }
    }

    private void addMeasure(JRDesignCrosstab jrCrosstab, DRIDesignCrosstabMeasure measure) {
        JRDesignCrosstabMeasure jrMeasure = new JRDesignCrosstabMeasure();
        jrMeasure.setName(measure.getName());
        jrMeasure.setValueExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(measure.getValueExpression()));
        jrMeasure.setValueClassName(measure.getValueClass().getName());
        jrMeasure.setCalculation(ConstantTransform.calculation(measure.getCalculation()));
        jrMeasure.setPercentageType(ConstantTransform.crosstabPercentageType(measure.getPercentageType()));
        try {
            jrCrosstab.addMeasure(jrMeasure);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for crosstab measure \"" + measure.getName() + "\"", e);
        }
    }
}

