/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.util.HashMap;
import java.util.Map;
import net.sf.dynamicreports.design.definition.DRIDesignDataset;
import net.sf.dynamicreports.jasper.base.JasperCustomValues;
import net.sf.dynamicreports.jasper.base.JasperScriptlet;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.DatasetExpressionTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.dynamicreports.jasper.transformation.expression.DatasetParametersExpression;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignParameter;

public class DatasetTransform {
    private JasperTransformAccessor accessor;
    private Map<DRIDesignDataset, Map<String, Object>> datasetParameters;
    private Map<DRIDesignDataset, DatasetExpressionTransform> datasetExpressions;

    public DatasetTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
        this.datasetParameters = new HashMap<DRIDesignDataset, Map<String, Object>>();
        this.datasetExpressions = new HashMap<DRIDesignDataset, DatasetExpressionTransform>();
    }

    public void transform() {
        for (DRIDesignDataset dataset : this.accessor.getReport().getDatasets()) {
            this.addDataset(dataset);
        }
    }

    private void addDataset(DRIDesignDataset dataset) {
        try {
            this.accessor.getDesign().addDataset(this.dataset(dataset));
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for dataset \"" + dataset.getName() + "\"", e);
        }
    }

    private JRDesignDataset dataset(DRIDesignDataset dataset) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.datasetParameters.put(dataset, parameters);
        JRDesignDataset jrDataset = new JRDesignDataset(false);
        jrDataset.setName(dataset.getName());
        if (dataset.getQuery() != null) {
            jrDataset.setQuery(this.accessor.getReportTransform().query(dataset.getQuery()));
        }
        JasperCustomValues customValues = new JasperCustomValues();
        DatasetExpressionTransform datasetExpressionTransform = new DatasetExpressionTransform(dataset, jrDataset, customValues);
        datasetExpressionTransform.transform();
        this.datasetExpressions.put(dataset, datasetExpressionTransform);
        if (!customValues.isEmpty()) {
            this.addParameter(jrDataset, parameters, "CUSTOM_VALUES", JasperCustomValues.class, customValues);
            this.addScriptlet(jrDataset, parameters, "DYNAMICREPORTS");
        }
        jrDataset.setFilterExpression((JRExpression)datasetExpressionTransform.getExpression(dataset.getFilterExpression()));
        return jrDataset;
    }

    private <T> void addParameter(JRDesignDataset jrDataset, Map<String, Object> parameters, String name, Class<T> parameterClass, T value) {
        JRDesignParameter jrParameter = new JRDesignParameter();
        jrParameter.setName(name);
        jrParameter.setValueClass(parameterClass);
        try {
            jrDataset.addParameter((JRParameter)jrParameter);
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for parameter \"" + name + "\"", e);
        }
        parameters.put(jrParameter.getName(), value);
    }

    private void addScriptlet(JRDesignDataset jrDataset, Map<String, Object> parameters, String name) {
        try {
            jrDataset.addScriptlet((JRScriptlet)this.accessor.getReportTransform().scriptlet(name, JasperScriptlet.class));
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for scriptlet \"" + name + "\"", e);
        }
    }

    public JRDesignDatasetRun datasetRun(DRIDesignDataset dataset) {
        if (dataset == null) {
            return null;
        }
        JRDesignDatasetRun jrDatasetRun = new JRDesignDatasetRun();
        jrDatasetRun.setDatasetName(dataset.getName());
        jrDatasetRun.setConnectionExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(dataset.getConnectionExpression()));
        jrDatasetRun.setDataSourceExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(dataset.getDataSourceExpression()));
        DatasetParametersExpression parametersExpression = new DatasetParametersExpression(this.datasetParameters.get(dataset));
        this.accessor.getExpressionTransform().addSimpleExpression(parametersExpression);
        jrDatasetRun.setParametersMapExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(parametersExpression));
        return jrDatasetRun;
    }

    protected Map<String, Object> getDatasetParameters(DRIDesignDataset dataset) {
        return this.datasetParameters.get(dataset);
    }

    public DatasetExpressionTransform getDatasetExpressionTransform(DRIDesignDataset dataset) {
        return this.datasetExpressions.get(dataset);
    }
}

