/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.jasper.transformation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.dynamicreports.design.definition.DRIDesignHyperLink;
import net.sf.dynamicreports.design.definition.DRIDesignMargin;
import net.sf.dynamicreports.design.definition.DRIDesignPage;
import net.sf.dynamicreports.design.definition.DRIDesignParameter;
import net.sf.dynamicreports.design.definition.DRIDesignQuery;
import net.sf.dynamicreports.design.definition.DRIDesignReport;
import net.sf.dynamicreports.jasper.base.CustomScriptlet;
import net.sf.dynamicreports.jasper.base.JasperCustomValues;
import net.sf.dynamicreports.jasper.base.JasperScriptlet;
import net.sf.dynamicreports.jasper.base.StartPageNumberScriptlet;
import net.sf.dynamicreports.jasper.base.tableofcontents.JasperTocHeading;
import net.sf.dynamicreports.jasper.constant.ValueType;
import net.sf.dynamicreports.jasper.exception.JasperDesignException;
import net.sf.dynamicreports.jasper.transformation.ConstantTransform;
import net.sf.dynamicreports.jasper.transformation.JasperTransformAccessor;
import net.sf.dynamicreports.report.definition.DRIScriptlet;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;

public class ReportTransform {
    private JasperTransformAccessor accessor;

    public ReportTransform(JasperTransformAccessor accessor) {
        this.accessor = accessor;
    }

    public void transform() {
        DRIDesignReport report = this.accessor.getReport();
        JasperDesign design = this.accessor.getDesign();
        Map<String, Object> parameters = this.accessor.getParameters();
        if (report.isTableOfContents()) {
            Map<String, JasperTocHeading> tocHeadings = report.getTableOfContentsHeadings();
            if (tocHeadings == null) {
                tocHeadings = new LinkedHashMap<String, JasperTocHeading>();
            }
            this.accessor.getCustomValues().setTocHeadings(tocHeadings);
        }
        design.setName(report.getReportName());
        parameters.put("REPORT_LOCALE", report.getLocale());
        parameters.put("REPORT_RESOURCE_BUNDLE", report.getResourceBundle());
        design.setResourceBundle(report.getResourceBundleName());
        design.setIgnorePagination(report.isIgnorePagination());
        this.setProperties(report.getProperties());
        if (report.getQuery() != null) {
            design.setQuery(this.query(report.getQuery()));
        }
        this.page();
        design.setWhenNoDataType(ConstantTransform.whenNoDataType(report.getWhenNoDataType()));
        design.setWhenResourceMissingType(ConstantTransform.whenResourceMissingType(report.getWhenResourceMissingType()));
        design.setTitleNewPage(report.isTitleOnANewPage());
        design.setSummaryNewPage(report.isSummaryOnANewPage());
        design.setSummaryWithPageHeaderAndFooter(report.isSummaryWithPageHeaderAndFooter());
        design.setFloatColumnFooter(report.isFloatColumnFooter());
        design.setPrintOrder(ConstantTransform.printOrder(report.getPrintOrder()));
        design.setColumnDirection(ConstantTransform.runDirection(report.getColumnDirection()));
        design.setLanguage(report.getLanguage());
        for (DRIDesignParameter parameter : report.getParameters()) {
            this.addParameter(parameter);
        }
        if (this.accessor.getStartPageNumber() != null) {
            this.addScriptlet("startPageNumber", StartPageNumberScriptlet.class);
            this.accessor.getCustomValues().setStartPageNumber(this.accessor.getStartPageNumber());
        }
        for (DRIScriptlet scriptlet : report.getScriptlets()) {
            this.addScriptlet(scriptlet);
        }
    }

    public void transformExpressions() {
        this.accessor.getDesign().setFilterExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(this.accessor.getReport().getFilterExpression()));
    }

    public void addDependencies() {
        DRIDesignReport report = this.accessor.getReport();
        if (!this.accessor.getCustomValues().isEmpty() || !report.getScriptlets().isEmpty() || this.accessor.getCustomValues().getStartPageNumber() != null || report.isTableOfContents()) {
            this.addParameter("CUSTOM_VALUES", JasperCustomValues.class, this.accessor.getCustomValues());
        }
        if (this.accessor.getMasterReportParameters() != null) {
            this.addParameter("MASTER_REPORT_PARAMETERS", ReportParameters.class, this.accessor.getMasterReportParameters());
        }
        if (!this.accessor.getCustomValues().isEmpty() || !report.getScriptlets().isEmpty()) {
            this.addScriptlet("DYNAMICREPORTS", JasperScriptlet.class);
        }
    }

    private <T> void addParameter(String name, Class<T> parameterClass, T value) {
        if (!this.accessor.getDesign().getParametersMap().containsKey(name)) {
            try {
                JRDesignParameter jrParameter = new JRDesignParameter();
                jrParameter.setName(name);
                jrParameter.setValueClass(parameterClass);
                this.accessor.getDesign().addParameter((JRParameter)jrParameter);
            }
            catch (JRException e) {
                throw new JasperDesignException("Registration failed for parameter \"" + name + "\"", e);
            }
        } else {
            JRParameter jrParameter = (JRParameter)this.accessor.getDesign().getParametersMap().get(name);
            if (!parameterClass.isAssignableFrom(jrParameter.getValueClass())) {
                throw new JasperDesignException("Registration failed for parameter \"" + name + "\", parameter is not instance of " + parameterClass.getName());
            }
        }
        if (value != null) {
            this.accessor.getParameters().put(name, value);
        }
    }

    private void addParameter(DRIDesignParameter parameter) {
        try {
            if (!parameter.isExternal()) {
                this.accessor.getDesign().addParameter((JRParameter)this.parameter(parameter));
            }
            this.accessor.getCustomValues().addValueType(parameter.getName(), ValueType.PARAMETER);
            if (parameter.getValue() != null) {
                this.accessor.getParameters().put(parameter.getName(), parameter.getValue());
            }
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for parameter \"" + parameter.getName() + "\"", e);
        }
    }

    private void setProperties(Properties properties) {
        for (String string : properties.keySet()) {
            this.accessor.getDesign().setProperty(string, properties.getProperty(string));
        }
    }

    private void addScriptlet(DRIScriptlet scriptlet) {
        CustomScriptlet customScriptlet = new CustomScriptlet(scriptlet);
        this.addScriptlet(scriptlet.getName(), ((Object)((Object)customScriptlet)).getClass());
        this.accessor.getParameters().put(String.valueOf(scriptlet.getName()) + "_SCRIPTLET", (Object)customScriptlet);
    }

    private void addScriptlet(String name, Class<? extends JRAbstractScriptlet> scriptletClass) {
        try {
            this.accessor.getDesign().addScriptlet((JRScriptlet)this.scriptlet(name, scriptletClass));
        }
        catch (JRException e) {
            throw new JasperDesignException("Registration failed for scriptlet \"" + name + "\"", e);
        }
    }

    public JRDesignHyperlink hyperLink(DRIDesignHyperLink hyperLink) {
        if (hyperLink == null) {
            return null;
        }
        JRDesignHyperlink jrHyperLink = new JRDesignHyperlink();
        jrHyperLink.setHyperlinkAnchorExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getAnchorExpression()));
        jrHyperLink.setHyperlinkPageExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getPageExpression()));
        jrHyperLink.setHyperlinkReferenceExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getReferenceExpression()));
        jrHyperLink.setHyperlinkTooltipExpression((JRExpression)this.accessor.getExpressionTransform().getExpression(hyperLink.getTooltipExpression()));
        if (hyperLink.getType() != null) {
            HyperlinkTypeEnum hyperLinkType = ConstantTransform.hyperLinkType(hyperLink.getType());
            if (hyperLinkType != null) {
                jrHyperLink.setHyperlinkType(hyperLinkType);
            } else {
                jrHyperLink.setLinkType(hyperLink.getType());
            }
        }
        if (hyperLink.getTarget() != null) {
            HyperlinkTargetEnum hyperLinkTarget = ConstantTransform.hyperLinkTarget(hyperLink.getTarget());
            if (hyperLinkTarget != null) {
                jrHyperLink.setHyperlinkTarget(hyperLinkTarget);
            } else {
                jrHyperLink.setLinkTarget(hyperLink.getTarget());
            }
        }
        return jrHyperLink;
    }

    private void page() {
        DRIDesignPage page = this.accessor.getReport().getPage();
        DRIDesignMargin margin = page.getMargin();
        JasperDesign design = this.accessor.getDesign();
        design.setPageWidth(page.getWidth());
        design.setPageHeight(page.getHeight());
        design.setOrientation(ConstantTransform.pageOrientation(page.getOrientation()));
        design.setLeftMargin(margin.getLeft());
        design.setRightMargin(margin.getRight());
        design.setTopMargin(margin.getTop());
        design.setBottomMargin(margin.getBottom());
        design.setColumnCount(page.getColumnsPerPage());
        design.setColumnSpacing(page.getColumnSpace());
        design.setColumnWidth(page.getColumnWidth());
    }

    private JRDesignParameter parameter(DRIDesignParameter parameter) {
        JRDesignParameter jrParameter = new JRDesignParameter();
        jrParameter.setName(parameter.getName());
        jrParameter.setValueClass(parameter.getValueClass());
        return jrParameter;
    }

    protected JRDesignScriptlet scriptlet(String name, Class<? extends JRAbstractScriptlet> scriptletClass) {
        JRDesignScriptlet jrScriptlet = new JRDesignScriptlet();
        jrScriptlet.setName(name);
        jrScriptlet.setValueClass(scriptletClass);
        return jrScriptlet;
    }

    protected JRDesignQuery query(DRIDesignQuery query) {
        JRDesignQuery jrQuery = new JRDesignQuery();
        jrQuery.setText(query.getText());
        jrQuery.setLanguage(query.getLanguage());
        return jrQuery;
    }
}

