/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.base.crosstab;

import net.sf.dynamicreports.report.ReportUtils;
import net.sf.dynamicreports.report.constant.Calculation;
import net.sf.dynamicreports.report.constant.CrosstabPercentageType;
import net.sf.dynamicreports.report.definition.crosstab.DRICrosstabVariable;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class DRCrosstabVariable<T>
implements DRICrosstabVariable<T> {
    private static final long serialVersionUID = 10000L;
    private String name;
    private DRIExpression<?> valueExpression;
    private Calculation calculation;
    private CrosstabPercentageType percentageType;

    public DRCrosstabVariable(DRIExpression<?> valueExpression, Calculation calculation) {
        Validate.notNull(valueExpression, (String)"valueExpression must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)calculation), (String)"calculation must not be null", (Object[])new Object[0]);
        this.valueExpression = valueExpression;
        this.calculation = calculation;
        this.name = ReportUtils.generateUniqueName("crosstabMeasure");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DRIExpression<?> getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public Calculation getCalculation() {
        return this.calculation;
    }

    @Override
    public CrosstabPercentageType getPercentageType() {
        return this.percentageType;
    }

    public void setPercentageType(CrosstabPercentageType percentageType) {
        this.percentageType = percentageType;
    }

    @Override
    public Class<? super T> getValueClass() {
        if (this.percentageType != null && this.percentageType.equals((Object)CrosstabPercentageType.GRAND_TOTAL) && !this.calculation.equals((Object)Calculation.COUNT) && !this.calculation.equals((Object)Calculation.DISTINCT_COUNT)) {
            return Double.class;
        }
        return ReportUtils.getVariableValueClass(this.getCalculation(), this.valueExpression.getValueClass());
    }
}

