/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.dynamicreports.report.base.chart.dataset.DRCategoryDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.SeriesOrderByNamesComparator;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class AbstractCategoryChartBuilder<T extends AbstractCategoryChartBuilder<T, U>, U extends DRAxisPlot>
extends AbstractBaseChartBuilder<T, U, DRCategoryDataset> {
    private static final long serialVersionUID = 10000L;

    protected AbstractCategoryChartBuilder(ChartType chartType) {
        super(chartType);
    }

    public T setCategory(ValueColumnBuilder<?, String> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRCategoryDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return (T)this;
    }

    public T setCategory(String fieldName, Class<String> valueClass) {
        return this.setCategory(DynamicReports.field(fieldName, valueClass));
    }

    public T setCategory(FieldBuilder<String> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRCategoryDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return (T)this;
    }

    public T setCategory(DRIExpression<String> expression) {
        ((DRCategoryDataset)this.getDataset()).setValueExpression(expression);
        return (T)this;
    }

    public T series(AbstractCategoryChartSerieBuilder<?, ?> ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public T addSerie(AbstractCategoryChartSerieBuilder<?, ?> ... chartSeries) {
        Validate.notNull(chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        AbstractCategoryChartSerieBuilder<?, ?>[] abstractCategoryChartSerieBuilderArray = chartSeries;
        int n = chartSeries.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractCategoryChartSerieBuilder<?, ?> chartSerie = abstractCategoryChartSerieBuilderArray[n2];
            ((DRCategoryDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
            ++n2;
        }
        return (T)this;
    }

    public T setUseSeriesAsCategory(Boolean useSeriesAsCategory) {
        ((DRCategoryDataset)this.getDataset()).setUseSeriesAsCategory(useSeriesAsCategory);
        return (T)this;
    }

    public T setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRCategoryDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return (T)this;
    }

    public T setCategoryAxisFormat(AxisFormatBuilder categoryAxisFormat) {
        Validate.notNull((Object)categoryAxisFormat, (String)"categoryAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)categoryAxisFormat.build());
        return (T)this;
    }

    public T setValueAxisFormat(AxisFormatBuilder valueAxisFormat) {
        Validate.notNull((Object)valueAxisFormat, (String)"valueAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)valueAxisFormat.build());
        return (T)this;
    }

    public T setShowPercentages(Boolean showPercentages) {
        ((DRAxisPlot)this.getPlot()).setShowPercentages(showPercentages);
        return (T)this;
    }

    public T setSeriesOrderBy(Comparator<String> seriesOrderBy) {
        ((DRAxisPlot)this.getPlot()).setSeriesOrderBy(seriesOrderBy);
        return (T)this;
    }

    public T setSeriesOrderBy(List<String> seriesOrderByNames) {
        ((DRAxisPlot)this.getPlot()).setSeriesOrderBy(new SeriesOrderByNamesComparator(seriesOrderByNames));
        return (T)this;
    }

    public T seriesOrderBy(String ... seriesOrderByNames) {
        return this.setSeriesOrderBy(Arrays.asList(seriesOrderByNames));
    }

    public T setSeriesOrderType(OrderType seriesOrderType) {
        ((DRAxisPlot)this.getPlot()).setSeriesOrderType(seriesOrderType);
        return (T)this;
    }
}

