/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.util.Date;
import net.sf.dynamicreports.report.base.chart.dataset.DRTimeSeriesDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.TimePeriod;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class AbstractTimeSeriesChartBuilder<T extends AbstractTimeSeriesChartBuilder<T, U>, U extends DRAxisPlot>
extends AbstractBaseChartBuilder<T, U, DRTimeSeriesDataset> {
    private static final long serialVersionUID = 10000L;

    protected AbstractTimeSeriesChartBuilder(ChartType chartType) {
        super(chartType);
    }

    public T setTimePeriod(ValueColumnBuilder<?, ? extends Date> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRTimeSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return (T)this;
    }

    public T setTimePeriod(String fieldName, Class<? extends Date> valueClass) {
        return this.setTimePeriod(DynamicReports.field(fieldName, valueClass));
    }

    public T setTimePeriod(FieldBuilder<? extends Date> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRTimeSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return (T)this;
    }

    public T setTimePeriod(DRIExpression<? extends Date> expression) {
        ((DRTimeSeriesDataset)this.getDataset()).setValueExpression(expression);
        return (T)this;
    }

    public T series(CategoryChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public T addSerie(CategoryChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        CategoryChartSerieBuilder[] categoryChartSerieBuilderArray = chartSeries;
        int n = chartSeries.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryChartSerieBuilder chartSerie = categoryChartSerieBuilderArray[n2];
            ((DRTimeSeriesDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
            ++n2;
        }
        return (T)this;
    }

    public T setTimePeriodType(TimePeriod timePeriodType) {
        ((DRTimeSeriesDataset)this.getDataset()).setTimePeriodType(timePeriodType);
        return (T)this;
    }

    public T setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRTimeSeriesDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return (T)this;
    }

    public T setTimeAxisFormat(AxisFormatBuilder timeAxisFormat) {
        Validate.notNull((Object)timeAxisFormat, (String)"timeAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)timeAxisFormat.build());
        return (T)this;
    }

    public T setValueAxisFormat(AxisFormatBuilder valueAxisFormat) {
        Validate.notNull((Object)valueAxisFormat, (String)"valueAxisFormat must not be null", (Object[])new Object[0]);
        ((DRAxisPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)valueAxisFormat.build());
        return (T)this;
    }

    public T setShowValues(Boolean showValues) {
        ((DRAxisPlot)this.getPlot()).setShowValues(showValues);
        return (T)this;
    }

    public T setValuePattern(String valuePattern) {
        ((DRAxisPlot)this.getPlot()).setValuePattern(valuePattern);
        return (T)this;
    }

    public T setPercentValuePattern(String percentValuePattern) {
        ((DRAxisPlot)this.getPlot()).setPercentValuePattern(percentValuePattern);
        return (T)this;
    }
}

