/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.chart;

import java.awt.Paint;
import net.sf.dynamicreports.report.base.chart.dataset.DRSeriesDataset;
import net.sf.dynamicreports.report.base.chart.plot.DRAxisFormat;
import net.sf.dynamicreports.report.base.chart.plot.DRXyBlockPlot;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.chart.AbstractBaseChartBuilder;
import net.sf.dynamicreports.report.builder.chart.AxisFormatBuilder;
import net.sf.dynamicreports.report.builder.chart.PaintScaleBuilder;
import net.sf.dynamicreports.report.builder.chart.XyzChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.constant.ChartType;
import net.sf.dynamicreports.report.constant.RectangleAnchor;
import net.sf.dynamicreports.report.definition.DRIHyperLink;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartSerie;
import net.sf.dynamicreports.report.definition.chart.plot.DRIPaintScale;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class XyBlockChartBuilder
extends AbstractBaseChartBuilder<XyBlockChartBuilder, DRXyBlockPlot, DRSeriesDataset> {
    private static final long serialVersionUID = 10000L;

    protected XyBlockChartBuilder(double defaultLowerBound, double defaultUpperBound, Paint defaultPaint) {
        super(ChartType.XYBLOCK);
        Validate.isTrue((defaultLowerBound <= defaultUpperBound ? 1 : 0) != 0, (String)"defaultLowerBound must be smaller than defaultUpperBound", (Object[])new Object[0]);
        ((DRXyBlockPlot)this.getPlot()).setDefaultLowerBound(defaultLowerBound);
        ((DRXyBlockPlot)this.getPlot()).setDefaultUpperBound(defaultUpperBound);
        ((DRXyBlockPlot)this.getPlot()).setDefaultPaint(defaultPaint);
    }

    public XyBlockChartBuilder setXValue(ValueColumnBuilder<?, ? extends Number> column) {
        Validate.notNull(column, (String)"column must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)column.getColumn());
        return this;
    }

    public XyBlockChartBuilder setXValue(String fieldName, Class<? extends Number> valueClass) {
        return this.setXValue(DynamicReports.field(fieldName, valueClass));
    }

    public XyBlockChartBuilder setXValue(FieldBuilder<? extends Number> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setValueExpression((DRIExpression)field.build());
        return this;
    }

    public XyBlockChartBuilder setXValue(DRIExpression<? extends Number> expression) {
        ((DRSeriesDataset)this.getDataset()).setValueExpression(expression);
        return this;
    }

    public XyBlockChartBuilder series(XyzChartSerieBuilder ... chartSeries) {
        return this.addSerie(chartSeries);
    }

    public XyBlockChartBuilder addSerie(XyzChartSerieBuilder ... chartSeries) {
        Validate.notNull((Object)chartSeries, (String)"chartSeries must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])chartSeries, (String)"chartSeries must not contains null chartSerie", (Object[])new Object[0]);
        XyzChartSerieBuilder[] xyzChartSerieBuilderArray = chartSeries;
        int n = chartSeries.length;
        int n2 = 0;
        while (n2 < n) {
            XyzChartSerieBuilder chartSerie = xyzChartSerieBuilderArray[n2];
            ((DRSeriesDataset)this.getDataset()).addSerie((DRIChartSerie)chartSerie.build());
            ++n2;
        }
        return this;
    }

    public XyBlockChartBuilder setItemHyperLink(HyperLinkBuilder itemHyperLink) {
        Validate.notNull((Object)itemHyperLink, (String)"itemHyperLink must not be null", (Object[])new Object[0]);
        ((DRSeriesDataset)this.getDataset()).setItemHyperLink((DRIHyperLink)itemHyperLink.build());
        return this;
    }

    public XyBlockChartBuilder setXAxisFormat(AxisFormatBuilder xAxisFormat) {
        Validate.notNull((Object)xAxisFormat, (String)"xAxisFormat must not be null", (Object[])new Object[0]);
        ((DRXyBlockPlot)this.getPlot()).setXAxisFormat((DRAxisFormat)xAxisFormat.build());
        return this;
    }

    public XyBlockChartBuilder setYAxisFormat(AxisFormatBuilder yAxisFormat) {
        Validate.notNull((Object)yAxisFormat, (String)"yAxisFormat must not be null", (Object[])new Object[0]);
        ((DRXyBlockPlot)this.getPlot()).setYAxisFormat((DRAxisFormat)yAxisFormat.build());
        return this;
    }

    public XyBlockChartBuilder setBlockWidth(Double blockWidth) {
        ((DRXyBlockPlot)this.getPlot()).setBlockWidth(blockWidth);
        return this;
    }

    public XyBlockChartBuilder setBlockHeight(Double blockHeight) {
        ((DRXyBlockPlot)this.getPlot()).setBlockHeight(blockHeight);
        return this;
    }

    public XyBlockChartBuilder setBlockAnchor(RectangleAnchor blockAnchor) {
        ((DRXyBlockPlot)this.getPlot()).setBlockAnchor(blockAnchor);
        return this;
    }

    public XyBlockChartBuilder paintScales(PaintScaleBuilder ... paintScales) {
        return this.addPaintScale(paintScales);
    }

    public XyBlockChartBuilder addPaintScale(PaintScaleBuilder ... paintScales) {
        Validate.notNull((Object)paintScales, (String)"paintScales must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])paintScales, (String)"paintScales must not contains null paintScale", (Object[])new Object[0]);
        PaintScaleBuilder[] paintScaleBuilderArray = paintScales;
        int n = paintScales.length;
        int n2 = 0;
        while (n2 < n) {
            PaintScaleBuilder paintScale = paintScaleBuilderArray[n2];
            ((DRXyBlockPlot)this.getPlot()).addPaintScale((DRIPaintScale)paintScale.build());
            ++n2;
        }
        return this;
    }
}

