/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.component;

import net.sf.dynamicreports.report.base.component.DRMultiPageList;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.component.BreakBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.component.DimensionComponentBuilder;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.component.DRIComponent;
import org.apache.commons.lang3.Validate;

public class MultiPageListBuilder
extends DimensionComponentBuilder<MultiPageListBuilder, DRMultiPageList> {
    private static final long serialVersionUID = 10000L;

    protected MultiPageListBuilder() {
        super(new DRMultiPageList());
    }

    public MultiPageListBuilder add(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRMultiPageList)this.getObject()).addComponent((DRIComponent)component.build());
            ++n2;
        }
        return this;
    }

    public MultiPageListBuilder newPage() {
        BreakBuilder pageBreak = Components.pageBreak();
        pageBreak.setPrintWhenExpression(new PageBreakExpression());
        ((DRMultiPageList)this.getObject()).addComponent((DRIComponent)pageBreak.build());
        return this;
    }

    public MultiPageListBuilder setSplitType(SplitType splitType) {
        ((DRMultiPageList)this.getObject()).setSplitType(splitType);
        return this;
    }

    private class PageBreakExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 10000L;

        private PageBreakExpression() {
        }

        @Override
        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getMasterParameters().getPageRowNumber() > 0) {
                return true;
            }
            return false;
        }
    }
}

