/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.condition;

import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import org.apache.commons.lang3.Validate;

public class EqualExpression
extends AbstractSimpleExpression<Boolean> {
    private static final long serialVersionUID = 10000L;
    private DRIValue<?> value;
    private Object[] values;

    @SafeVarargs
    public <T> EqualExpression(DRIValue<T> value, T ... values) {
        Validate.notNull(value, (String)"value must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])values, (String)"values must not contains null value", (Object[])new Object[0]);
        this.value = value;
        this.values = values;
    }

    @Override
    public Boolean evaluate(ReportParameters reportParameters) {
        Object actualValue = reportParameters.getValue(this.value);
        Object[] objectArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value.equals(actualValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }
}

