/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.grid;

import net.sf.dynamicreports.report.base.grid.DRColumnTitleGroup;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIPropertyExpression;
import org.apache.commons.lang3.Validate;

public class ColumnTitleGroupBuilder
extends AbstractBuilder<ColumnTitleGroupBuilder, DRColumnTitleGroup>
implements ColumnGridComponentBuilder {
    private static final long serialVersionUID = 10000L;

    protected ColumnTitleGroupBuilder() {
        super(new DRColumnTitleGroup());
    }

    public ColumnTitleGroupBuilder add(ColumnGridComponentBuilder ... components) {
        Validate.notNull((Object)components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ColumnGridComponentBuilder[] columnGridComponentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnGridComponentBuilder component = columnGridComponentBuilderArray[n2];
            ((DRColumnTitleGroup)this.getObject()).addComponent(component.build());
            ++n2;
        }
        return this;
    }

    public ColumnTitleGroupBuilder setTitle(DRIExpression<?> titleExpression) {
        ((DRColumnTitleGroup)this.getObject()).setTitleExpression(titleExpression);
        return this;
    }

    public ColumnTitleGroupBuilder setTitle(String title) {
        ((DRColumnTitleGroup)this.getObject()).setTitleExpression(Expressions.text(title));
        return this;
    }

    public ColumnTitleGroupBuilder setTitleStyle(ReportStyleBuilder titleStyle) {
        if (titleStyle != null) {
            ((DRColumnTitleGroup)this.getObject()).setTitleStyle(titleStyle.getStyle());
        } else {
            ((DRColumnTitleGroup)this.getObject()).setTitleStyle(null);
        }
        return this;
    }

    public ColumnTitleGroupBuilder setTitleColumns(Integer columns) {
        ((DRColumnTitleGroup)this.getObject()).setTitleColumns(columns);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleFixedColumns(Integer columns) {
        ((DRColumnTitleGroup)this.getObject()).setTitleColumns(columns);
        ((DRColumnTitleGroup)this.getObject()).setTitleWidthType(ComponentDimensionType.FIXED);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleMinColumns(Integer columns) {
        ((DRColumnTitleGroup)this.getObject()).setTitleColumns(columns);
        ((DRColumnTitleGroup)this.getObject()).setTitleWidthType(ComponentDimensionType.EXPAND);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleWidth(Integer width) {
        ((DRColumnTitleGroup)this.getObject()).setTitleWidth(width);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleFixedWidth(Integer width) {
        ((DRColumnTitleGroup)this.getObject()).setTitleWidth(width);
        ((DRColumnTitleGroup)this.getObject()).setTitleWidthType(ComponentDimensionType.FIXED);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleMinWidth(Integer width) {
        ((DRColumnTitleGroup)this.getObject()).setTitleWidth(width);
        ((DRColumnTitleGroup)this.getObject()).setTitleWidthType(ComponentDimensionType.EXPAND);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleRows(Integer rows) {
        ((DRColumnTitleGroup)this.getObject()).setTitleRows(rows);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleFixedRows(Integer rows) {
        ((DRColumnTitleGroup)this.getObject()).setTitleRows(rows);
        ((DRColumnTitleGroup)this.getObject()).setTitleHeightType(ComponentDimensionType.FIXED);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleMinRows(Integer rows) {
        ((DRColumnTitleGroup)this.getObject()).setTitleRows(rows);
        ((DRColumnTitleGroup)this.getObject()).setTitleHeightType(ComponentDimensionType.EXPAND);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleHeight(Integer height) {
        ((DRColumnTitleGroup)this.getObject()).setTitleHeight(height);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleFixedHeight(Integer height) {
        ((DRColumnTitleGroup)this.getObject()).setTitleHeight(height);
        ((DRColumnTitleGroup)this.getObject()).setTitleHeightType(ComponentDimensionType.FIXED);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleMinHeight(Integer height) {
        ((DRColumnTitleGroup)this.getObject()).setTitleHeight(height);
        ((DRColumnTitleGroup)this.getObject()).setTitleHeightType(ComponentDimensionType.EXPAND);
        return this;
    }

    public ColumnTitleGroupBuilder setTitleStretchWithOverflow(Boolean stretchWithOverflow) {
        ((DRColumnTitleGroup)this.getObject()).setTitleStretchWithOverflow(stretchWithOverflow);
        return this;
    }

    public ColumnTitleGroupBuilder addTitleProperty(DRIPropertyExpression propertyExpression) {
        ((DRColumnTitleGroup)this.getObject()).addTitlePropertyExpression(propertyExpression);
        return this;
    }

    public ColumnTitleGroupBuilder addTitleProperty(String name, DRIExpression<String> valueExpression) {
        ((DRColumnTitleGroup)this.getObject()).addTitlePropertyExpression(Expressions.property(name, valueExpression));
        return this;
    }

    public ColumnTitleGroupBuilder addTitleProperty(String name, String value) {
        ((DRColumnTitleGroup)this.getObject()).addTitlePropertyExpression(Expressions.property(name, value));
        return this;
    }

    public DRColumnTitleGroup getColumnGridTitleGroup() {
        return (DRColumnTitleGroup)this.build();
    }
}

