/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.group;

import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.expression.Expressions;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public class CustomGroupBuilder
extends GroupBuilder<CustomGroupBuilder> {
    private static final long serialVersionUID = 10000L;

    protected CustomGroupBuilder(FieldBuilder<?> field) {
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.setValueExpression((DRIExpression)field.build());
    }

    protected CustomGroupBuilder(String name, FieldBuilder<?> field) {
        super(name);
        Validate.notNull(field, (String)"field must not be null", (Object[])new Object[0]);
        this.setValueExpression((DRIExpression)field.build());
    }

    protected CustomGroupBuilder(DRIExpression<?> valueExpression) {
        this.setValueExpression(valueExpression);
    }

    protected CustomGroupBuilder(String name, DRIExpression<?> valueExpression) {
        super(name);
        this.setValueExpression(valueExpression);
    }

    public CustomGroupBuilder setTitle(DRIExpression<?> titleExpression) {
        ((DRGroup)this.getObject()).setTitleExpression(titleExpression);
        ((DRGroup)this.getObject()).setHeaderLayout(GroupHeaderLayout.TITLE_AND_VALUE);
        return this;
    }

    public CustomGroupBuilder setTitle(String title) {
        ((DRGroup)this.getObject()).setTitleExpression(Expressions.text(title));
        ((DRGroup)this.getObject()).setHeaderLayout(GroupHeaderLayout.TITLE_AND_VALUE);
        return this;
    }
}

