/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.report.builder.group;

import net.sf.dynamicreports.report.base.DRGroup;
import net.sf.dynamicreports.report.base.component.DRComponent;
import net.sf.dynamicreports.report.base.component.DRTextField;
import net.sf.dynamicreports.report.builder.AbstractBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.constant.GroupFooterPosition;
import net.sf.dynamicreports.report.constant.GroupHeaderLayout;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.HorizontalTextAlignment;
import net.sf.dynamicreports.report.constant.SplitType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import org.apache.commons.lang3.Validate;

public abstract class GroupBuilder<T extends GroupBuilder<T>>
extends AbstractBuilder<T, DRGroup> {
    private static final long serialVersionUID = 10000L;
    private DRIExpression valueExpression;

    protected GroupBuilder() {
        super(new DRGroup(new DRTextField()));
    }

    protected GroupBuilder(String name) {
        super(new DRGroup(name, new DRTextField()));
    }

    protected void setValueExpression(DRIExpression<?> valueExpression) {
        this.valueExpression = valueExpression;
    }

    public T setHeaderLayout(GroupHeaderLayout headerLayout) {
        ((DRGroup)this.getObject()).setHeaderLayout(headerLayout);
        return (T)this;
    }

    public T showColumnHeaderAndFooter() {
        return this.setShowColumnHeaderAndFooter(true);
    }

    public T setShowColumnHeaderAndFooter(Boolean showColumnHeaderAndFooter) {
        ((DRGroup)this.getObject()).setShowColumnHeaderAndFooter(showColumnHeaderAndFooter);
        return (T)this;
    }

    public T setAddToTableOfContents(Boolean addToTableOfContents) {
        ((DRGroup)this.getObject()).setAddToTableOfContents(addToTableOfContents);
        return (T)this;
    }

    public T setPrintSubtotalsWhenExpression(DRIExpression<Boolean> printSubtotalsWhenExpression) {
        ((DRGroup)this.getObject()).setPrintSubtotalsWhenExpression(printSubtotalsWhenExpression);
        return (T)this;
    }

    public T setPadding(Integer padding) {
        ((DRGroup)this.getObject()).setPadding(padding);
        return (T)this;
    }

    public T startInNewPage() {
        return this.setStartInNewPage(true);
    }

    public T setStartInNewPage(Boolean startInNewPage) {
        ((DRGroup)this.getObject()).setStartInNewPage(startInNewPage);
        return (T)this;
    }

    public T startInNewColumn() {
        return this.setStartInNewColumn(true);
    }

    public T setStartInNewColumn(Boolean startInNewColumn) {
        ((DRGroup)this.getObject()).setStartInNewColumn(startInNewColumn);
        return (T)this;
    }

    public T reprintHeaderOnEachPage() {
        return this.setReprintHeaderOnEachPage(true);
    }

    public T setReprintHeaderOnEachPage(Boolean reprintHeaderOnEachPage) {
        ((DRGroup)this.getObject()).setReprintHeaderOnEachPage(reprintHeaderOnEachPage);
        return (T)this;
    }

    public T resetPageNumber() {
        return this.setResetPageNumber(true);
    }

    public T setResetPageNumber(Boolean resetPageNumber) {
        ((DRGroup)this.getObject()).setResetPageNumber(resetPageNumber);
        return (T)this;
    }

    public T setMinHeightToStartNewPage(Integer minHeightToStartNewPage) {
        ((DRGroup)this.getObject()).setMinHeightToStartNewPage(minHeightToStartNewPage);
        return (T)this;
    }

    public T setFooterPosition(GroupFooterPosition footerPosition) {
        ((DRGroup)this.getObject()).setFooterPosition(footerPosition);
        return (T)this;
    }

    public T keepTogether() {
        return this.setKeepTogether(true);
    }

    public T setKeepTogether(Boolean keepTogether) {
        ((DRGroup)this.getObject()).setKeepTogether(keepTogether);
        return (T)this;
    }

    public T headerWithSubtotal() {
        return this.setHeaderWithSubtotal(true);
    }

    public T setHeaderWithSubtotal(Boolean headerWithSubtotal) {
        ((DRGroup)this.getObject()).setHeaderWithSubtotal(headerWithSubtotal);
        return (T)this;
    }

    public T groupByDataType() {
        return this.setGroupByDataType(true);
    }

    public T setGroupByDataType(Boolean groupByDataType) {
        ((DRGroup)this.getObject()).setGroupByDataType(groupByDataType);
        return (T)this;
    }

    public T setStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRComponent)((Object)((DRGroup)this.getObject()).getValueField())).setStyle(style.getStyle());
        } else {
            ((DRComponent)((Object)((DRGroup)this.getObject()).getValueField())).setStyle(null);
        }
        return (T)this;
    }

    @Deprecated
    public T setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment != null) {
            ((DRTextField)((DRGroup)this.getObject()).getValueField()).setHorizontalTextAlignment(HorizontalTextAlignment.valueOf(horizontalAlignment.name()));
        } else {
            ((DRTextField)((DRGroup)this.getObject()).getValueField()).setHorizontalTextAlignment(null);
        }
        return (T)this;
    }

    public T setHorizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment) {
        ((DRTextField)((DRGroup)this.getObject()).getValueField()).setHorizontalTextAlignment(horizontalTextAlignment);
        return (T)this;
    }

    public T setTitleStyle(ReportStyleBuilder titleStyle) {
        if (titleStyle != null) {
            ((DRGroup)this.getObject()).setTitleStyle(titleStyle.getStyle());
        } else {
            ((DRGroup)this.getObject()).setTitleStyle(null);
        }
        return (T)this;
    }

    public T setTitleWidth(Integer titleWidth) {
        ((DRGroup)this.getObject()).setTitleWidth(titleWidth);
        return (T)this;
    }

    public T setHeaderSplitType(SplitType splitType) {
        ((DRGroup)this.getObject()).getHeaderBand().setSplitType(splitType);
        return (T)this;
    }

    public T setHeaderPrintWhenExpression(DRIExpression<Boolean> printWhenExpression) {
        ((DRGroup)this.getObject()).getHeaderBand().setPrintWhenExpression(printWhenExpression);
        return (T)this;
    }

    public T setHeaderStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRGroup)this.getObject()).getHeaderBand().getList().setStyle(style.build());
        } else {
            ((DRGroup)this.getObject()).getHeaderBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setHeaderBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRGroup)this.getObject()).getHeaderBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T addHeaderComponent(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRGroup)this.getObject()).getHeaderBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T header(ComponentBuilder<?, ?> ... components) {
        return this.addHeaderComponent(components);
    }

    public T setFooterSplitType(SplitType splitType) {
        ((DRGroup)this.getObject()).getFooterBand().setSplitType(splitType);
        return (T)this;
    }

    public T setFooterPrintWhenExpression(DRIExpression<Boolean> printWhenExpression) {
        ((DRGroup)this.getObject()).getFooterBand().setPrintWhenExpression(printWhenExpression);
        return (T)this;
    }

    public T setFooterStyle(ReportStyleBuilder style) {
        if (style != null) {
            ((DRGroup)this.getObject()).getFooterBand().getList().setStyle(style.build());
        } else {
            ((DRGroup)this.getObject()).getFooterBand().getList().setStyle(null);
        }
        return (T)this;
    }

    public T setFooterBackgroundComponent(ComponentBuilder<?, ?> backgroundComponent) {
        Validate.notNull(backgroundComponent, (String)"backgroundComponent must not be null", (Object[])new Object[0]);
        ((DRGroup)this.getObject()).getFooterBand().getList().setBackgroundComponent((DRComponent)backgroundComponent.build());
        return (T)this;
    }

    public T addFooterComponent(ComponentBuilder<?, ?> ... components) {
        Validate.notNull(components, (String)"components must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])components, (String)"components must not contains null component", (Object[])new Object[0]);
        ComponentBuilder<?, ?>[] componentBuilderArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentBuilder<?, ?> component = componentBuilderArray[n2];
            ((DRGroup)this.getObject()).getFooterBand().addComponent((DRComponent)component.build());
            ++n2;
        }
        return (T)this;
    }

    public T footer(ComponentBuilder<?, ?> ... components) {
        return this.addFooterComponent(components);
    }

    @Override
    protected void configure() {
        super.configure();
        ((DRTextField)((DRGroup)this.getObject()).getValueField()).setValueExpression(this.valueExpression);
    }

    public DRGroup getGroup() {
        return (DRGroup)this.build();
    }
}

