/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepSubtypeAnalysis {
    private static JavaClass serializable;
    private static JavaClass collection;
    private static JavaClass comparator;
    private static JavaClass map;
    private static JavaClass remote;
    private static ClassNotFoundException storedException;

    private static boolean containsConcreteClasses(Set<JavaClass> s) {
        for (JavaClass c : s) {
            if (c.isInterface() || c.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static double isDeepSerializable(String refSig) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        if (DeepSubtypeAnalysis.isPrimitiveComponentClass(refSig)) {
            return 1.0;
        }
        String refName = DeepSubtypeAnalysis.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        JavaClass refJavaClass = Repository.lookupClass((String)refName);
        return DeepSubtypeAnalysis.isDeepSerializable(refJavaClass);
    }

    public static double isDeepRemote(String refSig) {
        if (remote == null) {
            return 0.1;
        }
        String refName = DeepSubtypeAnalysis.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        try {
            JavaClass refJavaClass = Repository.lookupClass((String)refName);
            return DeepSubtypeAnalysis.deepInstanceOf(refJavaClass, remote);
        }
        catch (ClassNotFoundException e) {
            return 0.99;
        }
    }

    private static boolean isPrimitiveComponentClass(String refSig) {
        int c;
        for (c = 0; c < refSig.length() && refSig.charAt(c) == '['; ++c) {
        }
        return c >= refSig.length() || refSig.charAt(c) != 'L';
    }

    public static String getComponentClass(String refSig) {
        while (refSig.charAt(0) == '[') {
            refSig = refSig.substring(1);
        }
        if (refSig.charAt(0) == 'L') {
            return refSig.substring(1, refSig.length() - 1).replace('/', '.');
        }
        return refSig;
    }

    public static double isDeepSerializable(JavaClass x) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        double result = DeepSubtypeAnalysis.deepInstanceOf(x, serializable);
        if (result >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, DeepSubtypeAnalysis.deepInstanceOf(x, collection))) >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, DeepSubtypeAnalysis.deepInstanceOf(x, map))) >= 0.9) {
            return result;
        }
        if ((result = Math.max(result, 0.5 * DeepSubtypeAnalysis.deepInstanceOf(x, comparator))) >= 0.9) {
            return result;
        }
        return result;
    }

    public static double deepInstanceOf(String x, String y) throws ClassNotFoundException {
        return DeepSubtypeAnalysis.deepInstanceOf(AnalysisContext.currentAnalysisContext().lookupClass(x), AnalysisContext.currentAnalysisContext().lookupClass(y));
    }

    public static double deepInstanceOf(JavaClass x, JavaClass y) throws ClassNotFoundException {
        if (x.equals((Object)y)) {
            return 1.0;
        }
        boolean xIsSubtypeOfY = Repository.instanceOf((JavaClass)x, (JavaClass)y);
        if (xIsSubtypeOfY) {
            return 1.0;
        }
        boolean yIsSubtypeOfX = Repository.instanceOf((JavaClass)y, (JavaClass)x);
        if (!yIsSubtypeOfX) {
            if (x.isFinal() || y.isFinal()) {
                return 0.0;
            }
            if (!x.isInterface() && !y.isInterface()) {
                return 0.0;
            }
        }
        Subtypes subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
        subtypes.addClass(x);
        subtypes.addClass(y);
        Set<JavaClass> xSubtypes = subtypes.getTransitiveSubtypes(x);
        Set<JavaClass> ySubtypes = subtypes.getTransitiveSubtypes(y);
        boolean emptyIntersection = true;
        boolean concreteClassesInXButNotY = false;
        for (JavaClass s : xSubtypes) {
            if (ySubtypes.contains(s)) {
                emptyIntersection = false;
                continue;
            }
            if (s.isInterface() || s.isAbstract()) continue;
            concreteClassesInXButNotY = true;
        }
        if (emptyIntersection) {
            if (concreteClassesInXButNotY) {
                if (x.isAbstract() || x.isInterface()) {
                    return 0.2;
                }
                return 0.1;
            }
            return 0.3;
        }
        if (!concreteClassesInXButNotY) {
            return 0.99;
        }
        return 0.7;
    }

    static {
        block4: {
            try {
                serializable = AnalysisContext.lookupSystemClass("java.io.Serializable");
                collection = AnalysisContext.lookupSystemClass("java.util.Collection");
                map = AnalysisContext.lookupSystemClass("java.util.Map");
                comparator = AnalysisContext.lookupSystemClass("java.util.Comparator");
            }
            catch (ClassNotFoundException e) {
                storedException = e;
            }
            try {
                remote = AnalysisContext.lookupSystemClass("java.rmi.Remote");
            }
            catch (ClassNotFoundException e) {
                if (storedException != null) break block4;
                storedException = e;
            }
        }
    }
}

