/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.visitclass.Constants2;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class Lookup
implements Constants2 {
    public static JavaClass findSuperImplementor(JavaClass clazz, String name, String signature, BugReporter bugReporter) {
        try {
            JavaClass c = Lookup.findImplementor(Repository.getSuperClasses((JavaClass)clazz), name, signature);
            return c;
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return clazz;
        }
    }

    public static String findSuperImplementor(String clazz, String name, String signature, BugReporter bugReporter) {
        try {
            JavaClass c = Lookup.findImplementor(Repository.getSuperClasses((String)clazz), name, signature);
            return c != null ? c.getClassName() : clazz;
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return clazz;
        }
    }

    public static JavaClass findImplementor(JavaClass[] clazz, String name, String signature) {
        JavaClass[] arr$ = clazz;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JavaClass aClazz = arr$[i$];
            Method m = Lookup.findImplementation(aClazz, name, signature);
            if (m == null) continue;
            if ((m.getAccessFlags() & 0x400) != 0) {
                return null;
            }
            return aClazz;
        }
        return null;
    }

    public static Method findImplementation(JavaClass clazz, String name, String signature) {
        Method[] m;
        Method[] arr$ = m = clazz.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method aM = arr$[i$];
            if (!aM.getName().equals(name) || !aM.getSignature().equals(signature) || (aM.getAccessFlags() & 2) != 0 || (aM.getAccessFlags() & 8) != 0) continue;
            return aM;
        }
        return null;
    }
}

