/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.Location;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArithmeticInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.ConversionInstruction;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.PopInstruction;
import org.apache.bcel.generic.PushInstruction;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.UnconditionalBranch;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.generic.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFrameModelingVisitor<Value, FrameType extends Frame<Value>>
implements Visitor {
    private FrameType frame = null;
    private Location location;
    protected ConstantPoolGen cpg;

    public AbstractFrameModelingVisitor(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        try {
            ins.accept((Visitor)this);
        }
        catch (InvalidBytecodeException e) {
            System.out.println(new StringBuffer().append("Could not analyze ").append(ins).toString());
            e.printStackTrace(System.out);
            throw new DataflowAnalysisException("Invalid bytecode", e);
        }
    }

    public ConstantPoolGen getCPG() {
        return this.cpg;
    }

    public void setFrameAndLocation(FrameType frame, Location location) {
        this.frame = frame;
        this.location = location;
    }

    public FrameType getFrame() {
        return this.frame;
    }

    public Location getLocation() {
        return this.location;
    }

    public abstract Value getDefaultValue();

    public int getNumWordsConsumed(Instruction ins) {
        int numWordsConsumed = ins.consumeStack(this.cpg);
        if (numWordsConsumed == -2) {
            throw new InvalidBytecodeException("Unpredictable stack consumption");
        }
        return numWordsConsumed;
    }

    public int getNumWordsProduced(Instruction ins) {
        int numWordsProduced = ins.produceStack(this.cpg);
        if (numWordsProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack productions");
        }
        return numWordsProduced;
    }

    private void illegalBytecode(Instruction ins) {
        throw new InvalidBytecodeException(new StringBuffer().append("Illegal bytecode: ").append(ins).toString());
    }

    public void visitStackInstruction(StackInstruction obj) {
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction obj) {
    }

    public void visitBranchInstruction(BranchInstruction obj) {
    }

    public void visitLoadClass(LoadClass obj) {
    }

    public void visitFieldInstruction(FieldInstruction obj) {
    }

    public void visitIfInstruction(IfInstruction obj) {
    }

    public void visitConversionInstruction(ConversionInstruction obj) {
    }

    public void visitPopInstruction(PopInstruction obj) {
    }

    public void visitJsrInstruction(JsrInstruction obj) {
    }

    public void visitGotoInstruction(GotoInstruction obj) {
    }

    public void visitStoreInstruction(StoreInstruction obj) {
    }

    public void visitTypedInstruction(TypedInstruction obj) {
    }

    public void visitSelect(Select obj) {
    }

    public void visitUnconditionalBranch(UnconditionalBranch obj) {
    }

    public void visitPushInstruction(PushInstruction obj) {
    }

    public void visitArithmeticInstruction(ArithmeticInstruction obj) {
    }

    public void visitCPInstruction(CPInstruction obj) {
    }

    public void visitInvokeInstruction(InvokeInstruction obj) {
    }

    public void visitArrayInstruction(ArrayInstruction obj) {
    }

    public void visitAllocationInstruction(AllocationInstruction obj) {
    }

    public void visitReturnInstruction(ReturnInstruction obj) {
    }

    public void visitFieldOrMethod(FieldOrMethod obj) {
    }

    public void visitConstantPushInstruction(ConstantPushInstruction obj) {
    }

    public void visitExceptionThrower(ExceptionThrower obj) {
    }

    public void visitLoadInstruction(LoadInstruction obj) {
    }

    public void visitVariableLengthInstruction(VariableLengthInstruction obj) {
    }

    public void visitStackProducer(StackProducer obj) {
    }

    public void visitStackConsumer(StackConsumer obj) {
    }

    public void handleStoreInstruction(StoreInstruction obj) {
        try {
            int numConsumed = obj.consumeStack(this.cpg);
            if (numConsumed == -2) {
                throw new InvalidBytecodeException("Unpredictable stack consumption");
            }
            int index = obj.getIndex();
            while (numConsumed-- > 0) {
                Object value = ((Frame)this.frame).popValue();
                ((Frame)this.frame).setValue(index++, value);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        int index = obj.getIndex() + numProduced;
        while (numProduced-- > 0) {
            Object value = ((Frame)this.frame).getValue(--index);
            ((Frame)this.frame).pushValue(value);
        }
    }

    public void handleNormalInstruction(Instruction ins) {
        this.modelNormalInstruction(ins, this.getNumWordsConsumed(ins), this.getNumWordsProduced(ins));
    }

    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        this.modelInstruction(ins, numWordsConsumed, numWordsProduced, this.getDefaultValue());
    }

    public void modelInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced, Value pushValue) {
        try {
            while (numWordsConsumed-- > 0) {
                ((Frame)this.frame).popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
        while (numWordsProduced-- > 0) {
            ((Frame)this.frame).pushValue(pushValue);
        }
    }

    public void visitASTORE(ASTORE obj) {
        this.handleStoreInstruction((StoreInstruction)obj);
    }

    public void visitDSTORE(DSTORE obj) {
        this.handleStoreInstruction((StoreInstruction)obj);
    }

    public void visitFSTORE(FSTORE obj) {
        this.handleStoreInstruction((StoreInstruction)obj);
    }

    public void visitISTORE(ISTORE obj) {
        this.handleStoreInstruction((StoreInstruction)obj);
    }

    public void visitLSTORE(LSTORE obj) {
        this.handleStoreInstruction((StoreInstruction)obj);
    }

    public void visitALOAD(ALOAD obj) {
        this.handleLoadInstruction((LoadInstruction)obj);
    }

    public void visitDLOAD(DLOAD obj) {
        this.handleLoadInstruction((LoadInstruction)obj);
    }

    public void visitFLOAD(FLOAD obj) {
        this.handleLoadInstruction((LoadInstruction)obj);
    }

    public void visitILOAD(ILOAD obj) {
        this.handleLoadInstruction((LoadInstruction)obj);
    }

    public void visitLLOAD(LLOAD obj) {
        this.handleLoadInstruction((LoadInstruction)obj);
    }

    public void visitPOP(POP obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitPOP2(POP2 obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDUP(DUP obj) {
        try {
            Object value = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value);
            ((Frame)this.frame).pushValue(value);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitDUP_X1(DUP_X1 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitDUP_X2(DUP_X2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitDUP2(DUP2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitDUP2_X1(DUP2_X1 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitDUP2_X2(DUP2_X2 obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            Object value3 = ((Frame)this.frame).popValue();
            Object value4 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value4);
            ((Frame)this.frame).pushValue(value3);
            ((Frame)this.frame).pushValue(value2);
            ((Frame)this.frame).pushValue(value1);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitSWAP(SWAP obj) {
        try {
            Object value1 = ((Frame)this.frame).popValue();
            Object value2 = ((Frame)this.frame).popValue();
            ((Frame)this.frame).pushValue(value1);
            ((Frame)this.frame).pushValue(value2);
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException(e.toString());
        }
    }

    public void visitIMPDEP1(IMPDEP1 obj) {
        this.illegalBytecode((Instruction)obj);
    }

    public void visitIMPDEP2(IMPDEP2 obj) {
        this.illegalBytecode((Instruction)obj);
    }

    public void visitBREAKPOINT(BREAKPOINT obj) {
        this.illegalBytecode((Instruction)obj);
    }

    public void visitACONST_NULL(ACONST_NULL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitGETSTATIC(GETSTATIC obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPLT(IF_ICMPLT obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitMONITOREXIT(MONITOREXIT obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFLT(IFLT obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitBASTORE(BASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitCHECKCAST(CHECKCAST obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFCMPG(FCMPG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2F(I2F obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitATHROW(ATHROW obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDCMPL(DCMPL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitARRAYLENGTH(ARRAYLENGTH obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLCONST(LCONST obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDREM(DREM obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFGE(IFGE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitCALOAD(CALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLASTORE(LASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2D(I2D obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDADD(DADD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIAND(IAND obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitPUTFIELD(PUTFIELD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDCONST(DCONST obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitNEW(NEW obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFNULL(IFNULL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLSUB(LSUB obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitL2I(L2I obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitISHR(ISHR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitTABLESWITCH(TABLESWITCH obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIINC(IINC obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDRETURN(DRETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDASTORE(DASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIALOAD(IALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDDIV(DDIV obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPGE(IF_ICMPGE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLAND(LAND obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIDIV(IDIV obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLOR(LOR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitCASTORE(CASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFREM(FREM obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLDC(LDC obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitBIPUSH(BIPUSH obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitF2L(F2L obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFMUL(FMUL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitJSR(JSR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFSUB(FSUB obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitSASTORE(SASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitRETURN(RETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDALOAD(DALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitSIPUSH(SIPUSH obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDSUB(DSUB obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitL2F(L2F obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPGT(IF_ICMPGT obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitF2D(F2D obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2L(I2L obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ACMPNE(IF_ACMPNE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2S(I2S obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFEQ(IFEQ obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIOR(IOR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIREM(IREM obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIASTORE(IASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitNEWARRAY(NEWARRAY obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINEG(INEG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLCMP(LCMP obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitJSR_W(JSR_W obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitSALOAD(SALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFNONNULL(IFNONNULL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDMUL(DMUL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFNE(IFNE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPLE(IF_ICMPLE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLDC2_W(LDC2_W obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitGETFIELD(GETFIELD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLADD(LADD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitNOP(NOP obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFALOAD(FALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINSTANCEOF(INSTANCEOF obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFLE(IFLE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLXOR(LXOR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLRETURN(LRETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFCONST(FCONST obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIUSHR(IUSHR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitBALOAD(BALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitMONITORENTER(MONITORENTER obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLSHL(LSHL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDCMPG(DCMPG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitD2L(D2L obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitL2D(L2D obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitRET(RET obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIFGT(IFGT obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIXOR(IXOR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFASTORE(FASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIRETURN(IRETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPNE(IF_ICMPNE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLDIV(LDIV obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitPUTSTATIC(PUTSTATIC obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitAALOAD(AALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitD2I(D2I obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitAASTORE(AASTORE obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitARETURN(ARETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFNEG(FNEG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitGOTO_W(GOTO_W obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitD2F(D2F obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitGOTO(GOTO obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitISUB(ISUB obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitF2I(F2I obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitDNEG(DNEG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitICONST(ICONST obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFDIV(FDIV obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2B(I2B obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLNEG(LNEG obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLREM(LREM obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIMUL(IMUL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitIADD(IADD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLSHR(LSHR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFCMPL(FCMPL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitI2C(I2C obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLMUL(LMUL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLUSHR(LUSHR obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitISHL(ISHL obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitLALOAD(LALOAD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitANEWARRAY(ANEWARRAY obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFRETURN(FRETURN obj) {
        this.handleNormalInstruction((Instruction)obj);
    }

    public void visitFADD(FADD obj) {
        this.handleNormalInstruction((Instruction)obj);
    }
}

