/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.XField;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignedFieldMap
implements Constants {
    private final ClassContext classContext;
    private final Map<Method, Set<XField>> assignedFieldSetForMethodMap;

    public AssignedFieldMap(ClassContext classContext) {
        this.classContext = classContext;
        this.assignedFieldSetForMethodMap = new IdentityHashMap<Method, Set<XField>>();
    }

    public void build() throws ClassNotFoundException {
        Method[] methodList;
        JavaClass jclass = this.classContext.getJavaClass();
        HashSet<XField> assignableFieldSet = new HashSet<XField>();
        this.scanFields(jclass, assignableFieldSet);
        JavaClass[] superClassList = jclass.getSuperClasses();
        if (superClassList != null) {
            for (JavaClass aSuperClassList : superClassList) {
                this.scanFields(aSuperClassList, assignableFieldSet);
            }
        }
        for (Method method : methodList = jclass.getMethods()) {
            this.scanMethod(method, assignableFieldSet);
        }
    }

    public Set<XField> getAssignedFieldSetForMethod(Method method) {
        Set<XField> set = this.assignedFieldSetForMethodMap.get(method);
        if (set == null) {
            set = new HashSet<XField>();
            this.assignedFieldSetForMethodMap.put(method, set);
        }
        return set;
    }

    private void scanFields(JavaClass jclass, Set<XField> assignableFieldSet) {
        Field[] fieldList;
        JavaClass myClass = this.classContext.getJavaClass();
        String myClassName = myClass.getClassName();
        String myPackageName = myClass.getPackageName();
        String superClassName = jclass.getClassName();
        String superPackageName = jclass.getPackageName();
        for (Field field : fieldList = jclass.getFields()) {
            boolean assignable;
            if (field.isStatic() || !(assignable = field.isPublic() || field.isProtected() ? true : (field.isPrivate() ? myClassName.equals(superClassName) : myPackageName.equals(superPackageName)))) continue;
            assignableFieldSet.add(new InstanceField(superClassName, field.getName(), field.getSignature(), field.getAccessFlags()));
        }
    }

    private void scanMethod(Method method, Set<XField> assignableFieldSet) throws ClassNotFoundException {
        MethodGen methodGen = this.classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        InstructionList il = methodGen.getInstructionList();
        ConstantPoolGen cpg = methodGen.getConstantPool();
        for (InstructionHandle handle = il.getStart(); handle != null; handle = handle.getNext()) {
            PUTFIELD putfield;
            XField instanceField;
            Instruction ins = handle.getInstruction();
            short opcode = ins.getOpcode();
            if (opcode != 181 || (instanceField = Hierarchy.findXField((FieldInstruction)(putfield = (PUTFIELD)ins), cpg)) == null || !assignableFieldSet.contains(instanceField)) continue;
            Set<XField> assignedFieldSetForMethod = this.getAssignedFieldSetForMethod(method);
            assignedFieldSetForMethod.add(instanceField);
        }
    }
}

