/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompatibleTypes {
    final int priority;
    final String msg;
    public static final IncompatibleTypes SEEMS_OK = new IncompatibleTypes("Seems OK", 5);
    public static final IncompatibleTypes ARRAY_AND_NON_ARRAY = new IncompatibleTypes("Array and non array", 1);
    public static final IncompatibleTypes ARRAY_AND_OBJECT = new IncompatibleTypes("Array and Object", 3);
    public static final IncompatibleTypes INCOMPATIBLE_CLASSES = new IncompatibleTypes("Incompatible classes", 1);
    public static final IncompatibleTypes UNRELATED_CLASS_AND_INTERFACE = new IncompatibleTypes("Unrelated class and interface", 1);
    public static final IncompatibleTypes UNRELATED_INTERFACES = new IncompatibleTypes("Unrelated interfaces", 2);

    private IncompatibleTypes(String msg, int priority) {
        this.msg = msg;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getMsg() {
        return this.msg;
    }

    public String toString() {
        return this.msg;
    }

    @NonNull
    public static IncompatibleTypes getPriorityForAssumingCompatible(Type lhsType, Type rhsType) {
        if (!(lhsType instanceof ReferenceType)) {
            return SEEMS_OK;
        }
        if (!(rhsType instanceof ReferenceType)) {
            return SEEMS_OK;
        }
        while (lhsType instanceof ArrayType && rhsType instanceof ArrayType) {
            lhsType = ((ArrayType)lhsType).getElementType();
            rhsType = ((ArrayType)rhsType).getElementType();
        }
        if (lhsType instanceof ArrayType) {
            if (rhsType.equals((Object)ObjectType.OBJECT)) {
                return ARRAY_AND_OBJECT;
            }
            return ARRAY_AND_NON_ARRAY;
        }
        if (rhsType instanceof ArrayType) {
            if (lhsType.equals((Object)ObjectType.OBJECT)) {
                return ARRAY_AND_OBJECT;
            }
            return ARRAY_AND_NON_ARRAY;
        }
        if (lhsType.equals((Object)rhsType)) {
            return SEEMS_OK;
        }
        if (!(lhsType instanceof ObjectType) || !(rhsType instanceof ObjectType)) {
            return SEEMS_OK;
        }
        return IncompatibleTypes.getPriorityForAssumingCompatible((ObjectType)lhsType, (ObjectType)rhsType);
    }

    @NonNull
    public static IncompatibleTypes getPriorityForAssumingCompatible(ObjectType lhsType, ObjectType rhsType) {
        try {
            if (!Hierarchy.isSubtype((ReferenceType)lhsType, (ReferenceType)rhsType) && !Hierarchy.isSubtype((ReferenceType)rhsType, (ReferenceType)lhsType)) {
                AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
                JavaClass lhsClass = analysisContext.lookupClass(lhsType.getClassName());
                JavaClass rhsClass = analysisContext.lookupClass(rhsType.getClassName());
                if (!lhsClass.isInterface() && !rhsClass.isInterface()) {
                    return INCOMPATIBLE_CLASSES;
                }
                Set<JavaClass> commonSubtypes = analysisContext.getSubtypes().getTransitiveCommonSubtypes(lhsClass, rhsClass);
                if (!IncompatibleTypes.containsAtLeastOneInstantiableClass(commonSubtypes)) {
                    if (lhsClass.isInterface() && rhsClass.isInterface()) {
                        return UNRELATED_INTERFACES;
                    }
                    return UNRELATED_CLASS_AND_INTERFACE;
                }
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return SEEMS_OK;
    }

    private static boolean containsAtLeastOneInstantiableClass(Set<JavaClass> commonSubtypes) {
        for (JavaClass javaClass : commonSubtypes) {
            if (javaClass.isInterface() || javaClass.isAbstract()) continue;
            return true;
        }
        return false;
    }
}

