/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BackwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import java.util.BitSet;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.StoreInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveLocalStoreAnalysis
extends BackwardDataflowAnalysis<BitSet>
implements Debug {
    private int topBit;
    private int killedByStoreOffset;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$LiveLocalStoreAnalysis;

    public LiveLocalStoreAnalysis(MethodGen methodGen, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        super(rdfs, dfs);
        this.topBit = methodGen.getMaxLocals() * 2;
        this.killedByStoreOffset = methodGen.getMaxLocals();
    }

    @Override
    public BitSet createFact() {
        return new BitSet();
    }

    @Override
    public void copy(BitSet source, BitSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    public void initEntryFact(BitSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void initResultFact(BitSet result) {
        this.makeFactTop(result);
    }

    @Override
    public void makeFactTop(BitSet fact) {
        fact.clear();
        fact.set(this.topBit);
    }

    @Override
    public boolean same(BitSet fact1, BitSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public void meetInto(BitSet fact, Edge edge, BitSet result) throws DataflowAnalysisException {
        this.isFactValid(fact);
        this.isFactValid(result);
        if (!this.isTop(fact)) {
            if (this.isTop(result)) {
                this.copy(fact, result);
            } else {
                result.or(fact);
            }
        }
        this.isFactValid(result);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, BitSet fact) throws DataflowAnalysisException {
        int local;
        this.isFactValid(fact);
        Instruction ins = handle.getInstruction();
        if (ins instanceof StoreInstruction || ins instanceof IINC) {
            LocalVariableInstruction store = (LocalVariableInstruction)ins;
            local = store.getIndex();
            fact.clear(local);
            fact.set(local + this.killedByStoreOffset);
        }
        if (ins instanceof LoadInstruction || ins instanceof IINC || ins instanceof RET) {
            IndexedInstruction load = (IndexedInstruction)ins;
            local = load.getIndex();
            fact.set(local);
            fact.clear(local + this.killedByStoreOffset);
        }
        this.isFactValid(fact);
    }

    @Override
    public boolean isFactValid(BitSet fact) {
        if (VERIFY_INTEGRITY && this.isTop(fact) && fact.nextSetBit(0) < this.topBit) {
            throw new IllegalStateException();
        }
        return !this.isTop(fact);
    }

    @Override
    public String factToString(BitSet fact) {
        if (this.isTop(fact)) {
            return "[TOP]";
        }
        return fact.toString();
    }

    @Override
    public boolean isTop(BitSet fact) {
        return fact.get(this.topBit);
    }

    public boolean isStoreAlive(BitSet fact, int local) {
        return fact.get(local);
    }

    public boolean killedByStore(BitSet fact, int local) {
        return fact.get(local + this.killedByStoreOffset);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$LiveLocalStoreAnalysis == null ? (class$edu$umd$cs$findbugs$ba$LiveLocalStoreAnalysis = LiveLocalStoreAnalysis.class$("edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis")) : class$edu$umd$cs$findbugs$ba$LiveLocalStoreAnalysis).getName()).append(" <classfile>").toString());
            System.exit(1);
        }
        String filename = argv[0];
        DataflowTestDriver<BitSet, LiveLocalStoreAnalysis> driver = new DataflowTestDriver<BitSet, LiveLocalStoreAnalysis>(){

            @Override
            public Dataflow<BitSet, LiveLocalStoreAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getLiveLocalStoreDataflow(method);
            }
        };
        driver.execute(filename);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((BitSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (BitSet)x2);
    }

    @Override
    public /* synthetic */ String factToString(Object x0) {
        return this.factToString((BitSet)x0);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((BitSet)x0, x1, (BitSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((BitSet)x0, (BitSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((BitSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((BitSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((BitSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((BitSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((BitSet)x0, (BitSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

