/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericUtilities {
    public static final TypeCategory getTypeCategory(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).getTypeCategory();
        }
        if (type instanceof ObjectType) {
            return TypeCategory.PLAIN_OBJECT_TYPE;
        }
        if (type instanceof ArrayType) {
            return TypeCategory.ARRAY_TYPE;
        }
        return TypeCategory.NON_REFERENCE_TYPE;
    }

    public static final boolean isPlainObject(Type type) {
        return GenericUtilities.getTypeCategory(type) == TypeCategory.PLAIN_OBJECT_TYPE;
    }

    public static final String getString(Type type) {
        if (type instanceof GenericObjectType) {
            return ((GenericObjectType)type).toString(true);
        }
        if (type instanceof ArrayType) {
            return TypeCategory.asString((ArrayType)type);
        }
        return type.toString();
    }

    public static final Type getType(String signature) {
        if (new GenericSignatureParser(new StringBuffer().append("(").append(signature).append(")V").toString()).getNumParameters() != 1) {
            throw new IllegalArgumentException(new StringBuffer().append("the following signature does not contain exactly one type: ").append(signature).toString());
        }
        int index = 0;
        if (signature.startsWith("L")) {
            index = GenericUtilities.lastMatchedLeftAngleBracket(signature);
            if (index < 0) {
                return Type.getType((String)signature);
            }
            List<ReferenceType> parameters = GenericUtilities.getTypes(signature.substring(index + 1, GenericUtilities.nextUnmatchedRightAngleBracket(signature, index + 1)));
            return new GenericObjectType(GenericUtilities.removeMatchedAngleBrackets(signature.substring(1, index)).replace('.', '$'), parameters);
        }
        if (signature.startsWith("T")) {
            return new GenericObjectType(signature.substring(1, signature.length() - 1));
        }
        if (signature.startsWith("[")) {
            index = signature.lastIndexOf(91) + 1;
            return new ArrayType(GenericUtilities.getType(signature.substring(index)), index);
        }
        if (signature.startsWith("*")) {
            return new GenericObjectType("*");
        }
        if (signature.startsWith("+") || signature.startsWith("-")) {
            return new GenericObjectType(signature.substring(0, 1), GenericUtilities.getType(signature.substring(1)));
        }
        return Type.getType((String)signature);
    }

    public static ObjectType merge(GenericObjectType t1, ObjectType t2) {
        List<? extends ReferenceType> parameters = t1.getParameters();
        if (parameters == null) {
            return t2;
        }
        return new GenericObjectType(t2.getClassName(), parameters);
    }

    public static String removeMatchedAngleBrackets(String s) {
        int first = s.indexOf(60);
        if (first < 0) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.substring(0, first));
        int pos = first;
        int nesting = 0;
        while (pos < s.length()) {
            char c;
            if ((c = s.charAt(pos++)) == '<') {
                ++nesting;
                continue;
            }
            if (c == '>') {
                --nesting;
                continue;
            }
            if (nesting != 0) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static int nextUnmatchedRightAngleBracket(String s, int startingAt) {
        int nesting = 0;
        int pos = startingAt;
        while (pos >= 0) {
            char c = s.charAt(pos);
            if (c == '>') {
                if (nesting == 0) {
                    return pos;
                }
                --nesting;
            } else if (c == '<') {
                ++nesting;
            }
            ++pos;
        }
        return -1;
    }

    public static int lastMatchedLeftAngleBracket(String s) {
        int nesting = 0;
        int pos = s.length() - 1;
        while (pos >= 0) {
            char c = s.charAt(pos);
            if (c == '<') {
                if (--nesting == 0) {
                    return pos;
                }
            } else if (c == '>') {
                ++nesting;
            }
            --pos;
        }
        return -1;
    }

    public static final List<ReferenceType> getTypes(String signature) {
        GenericSignatureParser parser = new GenericSignatureParser(new StringBuffer().append("(").append(signature).append(")V").toString());
        ArrayList<ReferenceType> types = new ArrayList<ReferenceType>();
        Iterator<String> iter = parser.parameterSignatureIterator();
        while (iter.hasNext()) {
            String parameterString = iter.next();
            types.add((ReferenceType)GenericUtilities.getType(parameterString));
        }
        return types;
    }

    public static abstract class TypeCategory {
        public static final TypeCategory NON_REFERENCE_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString((Type)obj);
            }
        };
        public static final TypeCategory PLAIN_OBJECT_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString((Type)obj);
            }
        };
        public static final TypeCategory ARRAY_TYPE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return GenericUtilities.getString((Type)obj);
            }
        };
        public static final TypeCategory PARAMETERS = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                String result = obj.toString();
                result = result + "<";
                Iterator<? extends ReferenceType> i$ = obj.parameters.iterator();
                while (i$.hasNext()) {
                    ReferenceType t = i$.next();
                    result = result + GenericUtilities.getString((Type)t) + ",";
                }
                return result.substring(0, result.length() - 1) + ">";
            }
        };
        public static final TypeCategory TYPE_VARIABLE = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return obj.variable;
            }
        };
        public static final TypeCategory WILDCARD = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "?";
            }
        };
        public static final TypeCategory WILDCARD_EXTENDS = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "? extends " + GenericUtilities.getString(obj.extension);
            }
        };
        public static final TypeCategory WILDCARD_SUPER = new TypeCategory(){

            public String asString(GenericObjectType obj) {
                return "? super " + GenericUtilities.getString(obj.extension);
            }
        };

        public abstract String asString(GenericObjectType var1);

        public static String asString(ArrayType atype) {
            Type obj = atype.getBasicType();
            String result = GenericUtilities.getString(obj);
            for (int i = 0; i < atype.getDimensions(); ++i) {
                result = result + "[]";
            }
            return result;
        }
    }
}

