/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGenericObjectType
extends TestCase {
    GenericObjectType obj;
    String javaSignature;
    String underlyingClass;
    GenericUtilities.TypeCategory typeCategory;
    String variable;
    Type extension;
    List<ReferenceType> parameters;

    public void initTest(String bytecodeSignature, String javaSignature, String underlyingClass, GenericUtilities.TypeCategory typeCategory, String variable, Type extension, List<ReferenceType> parameters) {
        this.obj = (GenericObjectType)GenericUtilities.getType(bytecodeSignature);
        this.javaSignature = javaSignature;
        this.underlyingClass = underlyingClass;
        this.typeCategory = typeCategory;
        this.variable = variable;
        this.extension = extension;
        this.parameters = parameters;
    }

    public void processTest() {
        TestGenericObjectType.assertEquals((String)this.obj.toString(true), (String)this.javaSignature);
        TestGenericObjectType.assertEquals((String)this.obj.getClassName(), (String)this.underlyingClass);
        TestGenericObjectType.assertEquals((Object)this.obj.getTypeCategory(), (Object)this.typeCategory);
        if (this.typeCategory == GenericUtilities.TypeCategory.PARAMETERS) {
            TestGenericObjectType.assertTrue((boolean)this.obj.hasParameters());
            TestGenericObjectType.assertTrue((this.obj.getNumParameters() == this.parameters.size() ? 1 : 0) != 0);
            for (int i = 0; i < this.obj.getNumParameters(); ++i) {
                this.compareTypes((Type)this.obj.getParameterAt(i), (Type)this.parameters.get(i));
            }
            TestGenericObjectType.assertNull((Object)this.obj.getVariable());
            TestGenericObjectType.assertNull((Object)this.obj.getExtension());
        } else if (this.typeCategory == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            TestGenericObjectType.assertFalse((boolean)this.obj.hasParameters());
            TestGenericObjectType.assertNull((Object)this.obj.getExtension());
            TestGenericObjectType.assertNotNull((Object)this.obj.getVariable());
            TestGenericObjectType.assertEquals((String)this.obj.getVariable(), (String)this.variable);
        } else if (this.typeCategory == GenericUtilities.TypeCategory.WILDCARD) {
            TestGenericObjectType.assertFalse((boolean)this.obj.hasParameters());
            TestGenericObjectType.assertNull((Object)this.obj.getExtension());
            TestGenericObjectType.assertNotNull((Object)this.obj.getVariable());
            TestGenericObjectType.assertEquals((String)this.obj.getVariable(), (String)"*");
        } else if (this.typeCategory == GenericUtilities.TypeCategory.WILDCARD_EXTENDS || this.typeCategory == GenericUtilities.TypeCategory.WILDCARD_SUPER) {
            TestGenericObjectType.assertFalse((boolean)this.obj.hasParameters());
            TestGenericObjectType.assertNotNull((Object)this.obj.getExtension());
            TestGenericObjectType.assertNotNull((Object)this.obj.getVariable());
            TestGenericObjectType.assertEquals((String)this.obj.getVariable(), (String)this.variable);
            this.compareTypes(this.obj.getExtension(), this.extension);
        }
    }

    private void compareTypes(Type a, Type b) {
        TestGenericObjectType.assertEquals((Object)a, (Object)b);
        if (a instanceof GenericObjectType || b instanceof GenericObjectType) {
            TestGenericObjectType.assertTrue((a instanceof GenericObjectType && b instanceof GenericObjectType ? 1 : 0) != 0);
            TestGenericObjectType.assertEquals((String)((GenericObjectType)a).toString(true), (String)((GenericObjectType)b).toString(true));
        }
    }

    public void testParameterizedList() {
        this.initTest("Ljava/util/List<Ljava/lang/Comparable;>;", "java.util.List<java.lang.Comparable>", "java.util.List", GenericUtilities.TypeCategory.PARAMETERS, null, null, GenericUtilities.getTypes("Ljava/lang/Comparable;"));
        this.processTest();
    }

    public void testCreateTypes() {
        this.initTest("LDummyClass<Ljava/lang/Comparable;TE;>;", "DummyClass<java.lang.Comparable,E>", "DummyClass", GenericUtilities.TypeCategory.PARAMETERS, null, null, Arrays.asList((ReferenceType)GenericUtilities.getType("Ljava/lang/Comparable;"), (ReferenceType)GenericUtilities.getType("TE;")));
        this.processTest();
    }

    public void testTypeVariables() {
        this.initTest("TE;", "E", "java.lang.Object", GenericUtilities.TypeCategory.TYPE_VARIABLE, "E", null, null);
        this.processTest();
        this.initTest("*", "?", "java.lang.Object", GenericUtilities.TypeCategory.WILDCARD, "*", null, null);
        this.processTest();
        this.initTest("+TE;", "? extends E", "java.lang.Object", GenericUtilities.TypeCategory.WILDCARD_EXTENDS, "+", GenericUtilities.getType("TE;"), null);
        this.processTest();
        this.initTest("-TE;", "? super E", "java.lang.Object", GenericUtilities.TypeCategory.WILDCARD_SUPER, "-", GenericUtilities.getType("TE;"), null);
        this.processTest();
        this.initTest("-[TE;", "? super E[]", "java.lang.Object", GenericUtilities.TypeCategory.WILDCARD_SUPER, "-", GenericUtilities.getType("[TE;"), null);
        this.processTest();
    }
}

