/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BackwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.npe.UnconditionalDerefDataflow;
import edu.umd.cs.findbugs.ba.npe.UnconditionalDerefSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconditionalDerefAnalysis
extends BackwardDataflowAnalysis<UnconditionalDerefSet> {
    private static final boolean DEBUG = SystemProperties.getBoolean("npe.deref.debug");
    private final CFG cfg;
    private final MethodGen methodGen;
    private final ValueNumberDataflow vnaDataflow;
    private final Map<ValueNumber, Integer> valueNumberToParamMap;
    private final int numParams;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$npe$UnconditionalDerefAnalysis;

    public UnconditionalDerefAnalysis(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs, CFG cfg, MethodGen methodGen, ValueNumberDataflow vnaDataflow, TypeDataflow typeDataflow) {
        super(rdfs, dfs);
        this.cfg = cfg;
        this.methodGen = methodGen;
        this.vnaDataflow = vnaDataflow;
        this.valueNumberToParamMap = vnaDataflow.getValueNumberToParamMap(methodGen.getSignature(), methodGen.isStatic());
        this.numParams = new SignatureParser(methodGen.getSignature()).getNumParameters();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Analyzing guaranteed dereferences in ").append(methodGen.getClassName()).append(".").append(methodGen.getName()).append(" : ").append(methodGen.getSignature()).toString());
        }
    }

    @Override
    public void copy(UnconditionalDerefSet source, UnconditionalDerefSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    public UnconditionalDerefSet createFact() {
        return new UnconditionalDerefSet(this.numParams);
    }

    @Override
    public void initEntryFact(UnconditionalDerefSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void initResultFact(UnconditionalDerefSet result) {
        this.makeFactTop(result);
    }

    @Override
    public void makeFactTop(UnconditionalDerefSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(UnconditionalDerefSet fact) {
        return fact.isTop();
    }

    @Override
    public void meetInto(UnconditionalDerefSet fact, Edge edge, UnconditionalDerefSet result) throws DataflowAnalysisException {
        if (AnalysisContext.currentAnalysisContext().getBoolProperty(0) && edge.isExceptionEdge() && !edge.isFlagSet(2)) {
            return;
        }
        if (result.isTop() || fact.isBottom()) {
            this.copy(fact, result);
        } else if (!result.isBottom() && !fact.isTop()) {
            result.and(fact);
        }
    }

    @Override
    public boolean same(UnconditionalDerefSet fact1, UnconditionalDerefSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public boolean isFactValid(UnconditionalDerefSet fact) {
        return fact.isValid();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, UnconditionalDerefSet fact) throws DataflowAnalysisException {
        Integer param;
        if (!fact.isValid()) {
            throw new IllegalStateException();
        }
        if (handle != basicBlock.getFirstInstruction()) {
            return;
        }
        BasicBlock fallThroughPredecessor = this.cfg.getPredecessorWithEdgeType(basicBlock, 0);
        if (fallThroughPredecessor == null || !fallThroughPredecessor.isNullCheck()) {
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(new Location(handle, basicBlock));
        if (!vnaFrame.isValid()) {
            this.makeFactTop(fact);
            return;
        }
        ValueNumber instance = (ValueNumber)vnaFrame.getInstance(handle.getInstruction(), this.methodGen.getConstantPool());
        if (DEBUG) {
            System.out.println(new StringBuffer().append("[Null check of value ").append(instance.getNumber()).append("]").toString());
        }
        if ((param = this.valueNumberToParamMap.get(instance)) == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("[Value is a parameter!]");
        }
        fact.set(param);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$npe$UnconditionalDerefAnalysis == null ? (class$edu$umd$cs$findbugs$ba$npe$UnconditionalDerefAnalysis = UnconditionalDerefAnalysis.class$("edu.umd.cs.findbugs.ba.npe.UnconditionalDerefAnalysis")) : class$edu$umd$cs$findbugs$ba$npe$UnconditionalDerefAnalysis).getName()).append(" <class file>").toString());
            System.exit(1);
        }
        DataflowTestDriver<UnconditionalDerefSet, UnconditionalDerefAnalysis> driver = new DataflowTestDriver<UnconditionalDerefSet, UnconditionalDerefAnalysis>(){

            public UnconditionalDerefDataflow createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return null;
            }

            @Override
            public /* synthetic */ Dataflow createDataflow(ClassContext x0, Method x1) throws CFGBuilderException, DataflowAnalysisException {
                return this.createDataflow(x0, x1);
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((UnconditionalDerefSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (UnconditionalDerefSet)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((UnconditionalDerefSet)x0, x1, (UnconditionalDerefSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((UnconditionalDerefSet)x0, (UnconditionalDerefSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((UnconditionalDerefSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((UnconditionalDerefSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((UnconditionalDerefSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((UnconditionalDerefSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((UnconditionalDerefSet)x0, (UnconditionalDerefSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

