/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.interproc.FieldPropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.ba.type.FieldStoreType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldStoreTypeDatabase
extends FieldPropertyDatabase<FieldStoreType> {
    public static final String DEFAULT_FILENAME = "fieldStoreTypes.db";

    public void purgeBoringEntries() {
        ArrayList keys = new ArrayList(this.getKeys());
        for (XField f : keys) {
            String s = f.getSignature();
            FieldStoreType type = (FieldStoreType)this.getProperty(f);
            Type fieldType = Type.getType((String)f.getSignature());
            if (!(fieldType instanceof ReferenceType)) {
                this.removeProperty(f);
                continue;
            }
            ReferenceType storeType = type.getLoadType((ReferenceType)fieldType);
            if (!storeType.equals((Object)fieldType)) continue;
            this.removeProperty(f);
        }
    }

    @Override
    protected FieldStoreType decodeProperty(String propStr) throws PropertyDatabaseFormatException {
        FieldStoreType property = new FieldStoreType();
        StringTokenizer t = new StringTokenizer(propStr, ",");
        while (t.hasMoreTokens()) {
            String signature = t.nextToken();
            property.addTypeSignature(signature);
        }
        return property;
    }

    @Override
    protected String encodeProperty(FieldStoreType property) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> i = property.signatureIterator();
        while (i.hasNext()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(i.next());
        }
        return buf.toString();
    }

    @Override
    protected /* synthetic */ String encodeProperty(Object x0) {
        return this.encodeProperty((FieldStoreType)x0);
    }

    @Override
    protected /* synthetic */ Object decodeProperty(String x0) throws PropertyDatabaseFormatException {
        return this.decodeProperty(x0);
    }
}

