/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Debug;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.StaticField;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberCache;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.HashMap;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumberFrameModelingVisitor
extends AbstractFrameModelingVisitor<ValueNumber, ValueNumberFrame>
implements Debug,
ValueNumberAnalysisFeatures {
    private MethodGen methodGen;
    private ValueNumberFactory factory;
    private ValueNumberCache cache;
    private LoadedFieldSet loadedFieldSet;
    private HashMap<String, ValueNumber> classObjectValueMap;
    private HashMap<Object, ValueNumber> constantValueMap;
    private HashMap<ValueNumber, String> stringConstantMap;
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private InstructionHandle handle;
    private static final ValueNumber[] EMPTY_INPUT_VALUE_LIST = new ValueNumber[0];

    public ValueNumberFrameModelingVisitor(MethodGen methodGen, ValueNumberFactory factory, ValueNumberCache cache, LoadedFieldSet loadedFieldSet, RepositoryLookupFailureCallback lookupFailureCallback) {
        super(methodGen.getConstantPool());
        this.methodGen = methodGen;
        this.factory = factory;
        this.cache = cache;
        this.loadedFieldSet = loadedFieldSet;
        this.classObjectValueMap = new HashMap();
        this.constantValueMap = new HashMap();
        this.stringConstantMap = new HashMap();
        this.lookupFailureCallback = lookupFailureCallback;
    }

    @Override
    public ValueNumber getDefaultValue() {
        return this.factory.createFreshValue();
    }

    public void setHandle(InstructionHandle handle) {
        this.handle = handle;
    }

    private boolean doRedundantLoadElimination() {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return false;
        }
        XField xfield = this.loadedFieldSet.getField(this.handle);
        if (xfield == null) {
            return false;
        }
        return xfield.isReferenceType();
    }

    private boolean doForwardSubstitution() {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return false;
        }
        XField xfield = this.loadedFieldSet.getField(this.handle);
        if (xfield == null) {
            return false;
        }
        if (!xfield.isReferenceType()) {
            return false;
        }
        return this.loadedFieldSet.isLoaded(xfield);
    }

    private void checkConsumedAndProducedValues(Instruction ins, ValueNumber[] consumedValueList, ValueNumber[] producedValueList) {
        int numConsumed = ins.consumeStack(this.getCPG());
        int numProduced = ins.produceStack(this.getCPG());
        if (numConsumed == -2) {
            throw new InvalidBytecodeException(new StringBuffer().append("Unpredictable stack consumption for ").append(ins).toString());
        }
        if (numProduced == -2) {
            throw new InvalidBytecodeException(new StringBuffer().append("Unpredictable stack production for ").append(ins).toString());
        }
        if (consumedValueList.length != numConsumed) {
            throw new IllegalStateException(new StringBuffer().append("Wrong number of values consumed for ").append(ins).append(": expected ").append(numConsumed).append(", got ").append(consumedValueList.length).toString());
        }
        if (producedValueList.length != numProduced) {
            throw new IllegalStateException(new StringBuffer().append("Wrong number of values produced for ").append(ins).append(": expected ").append(numProduced).append(", got ").append(producedValueList.length).toString());
        }
    }

    @Override
    public void modelNormalInstruction(Instruction ins, int numWordsConsumed, int numWordsProduced) {
        int flags = 0;
        if (ins instanceof InvokeInstruction) {
            flags = 1;
        } else if (ins instanceof ArrayInstruction) {
            flags = 2;
        }
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        ValueNumber[] outputValueList = this.getOutputValues(inputValueList, numWordsProduced, flags);
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(ins, inputValueList, outputValueList);
        }
        this.pushOutputValues(outputValueList);
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        if (this.doRedundantLoadElimination()) {
            try {
                XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
                if (xfield != null) {
                    this.loadInstanceField((InstanceField)xfield, (Instruction)obj);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitPUTFIELD(PUTFIELD obj) {
        if (this.doForwardSubstitution()) {
            try {
                XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
                if (xfield != null) {
                    this.storeInstanceField((InstanceField)xfield, (Instruction)obj, false);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        ConstantPoolGen cpg = this.getCPG();
        String fieldName = obj.getName(cpg);
        String fieldSig = obj.getSignature(cpg);
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("GETSTATIC of ").append(fieldName).append(" : ").append(fieldSig).toString());
        }
        if (fieldName.startsWith("class$") && fieldSig.equals("Ljava/lang/Class;")) {
            String className = fieldName.substring("class$".length()).replace('$', '.');
            if (RLE_DEBUG) {
                System.out.println(new StringBuffer().append("[found load of class object ").append(className).append("]").toString());
            }
            ValueNumber value = this.getClassObjectValue(className);
            frame.pushValue(value);
            return;
        }
        if (this.doRedundantLoadElimination()) {
            try {
                XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
                if (xfield != null) {
                    this.loadStaticField((StaticField)xfield, (Instruction)obj);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitPUTSTATIC(PUTSTATIC obj) {
        if (this.doForwardSubstitution()) {
            try {
                XField xfield = Hierarchy.findXField((FieldInstruction)obj, this.getCPG());
                if (xfield != null) {
                    this.storeStaticField((StaticField)xfield, (Instruction)obj, false);
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                this.lookupFailureCallback.reportMissingClass(e);
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        block18: {
            if (REDUNDANT_LOAD_ELIMINATION) {
                ConstantPoolGen cpg = this.getCPG();
                String targetClassName = obj.getClassName(cpg);
                String methodName = obj.getName(cpg);
                String methodSig = obj.getSignature(cpg);
                if ((methodName.equals("forName") && targetClassName.equals("java.lang.Class") || methodName.equals("class$")) && methodSig.equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
                    ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
                    try {
                        ValueNumber arg = (ValueNumber)frame.getTopValue();
                        String className = this.stringConstantMap.get(arg);
                        if (className != null) {
                            frame.popValue();
                            if (RLE_DEBUG) {
                                System.out.println(new StringBuffer().append("[found access of class object ").append(className).append("]").toString());
                            }
                            frame.pushValue(this.getClassObjectValue(className));
                            return;
                        }
                        break block18;
                    }
                    catch (DataflowAnalysisException e) {
                        throw new InvalidBytecodeException("stack underflow", this.methodGen, this.handle, e);
                    }
                }
                if (Hierarchy.isInnerClassAccess(obj, cpg)) {
                    XField xfield = this.loadedFieldSet.getField(this.handle);
                    if (xfield != null) {
                        if (this.loadedFieldSet.instructionIsLoad(this.handle)) {
                            if (this.doRedundantLoadElimination()) {
                                if (xfield.isStatic()) {
                                    this.loadStaticField((StaticField)xfield, (Instruction)obj);
                                } else {
                                    this.loadInstanceField((InstanceField)xfield, (Instruction)obj);
                                }
                                return;
                            }
                        } else if (this.doForwardSubstitution()) {
                            boolean pushValue;
                            boolean bl = pushValue = !methodSig.endsWith(")V");
                            if (xfield.isStatic()) {
                                this.storeStaticField((StaticField)xfield, (Instruction)obj, pushValue);
                            } else {
                                this.storeInstanceField((InstanceField)xfield, (Instruction)obj, pushValue);
                            }
                            return;
                        }
                    } else {
                        this.killLoadsOfObjectsPassed((InvokeInstruction)obj);
                        ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(null);
                    }
                } else {
                    this.killLoadsOfObjectsPassed((InvokeInstruction)obj);
                    ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(null);
                }
            }
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    private void killLoadsOfObjectsPassed(InvokeInstruction ins) {
        try {
            int passed = this.getNumWordsConsumed((Instruction)ins);
            ValueNumber[] arguments = new ValueNumber[passed];
            ((ValueNumberFrame)this.getFrame()).killLoadsWithSimilarName(ins.getClassName(this.cpg), ins.getMethodName(this.cpg));
            ((ValueNumberFrame)this.getFrame()).getTopStackWords(arguments);
            for (ValueNumber v : arguments) {
                ((ValueNumberFrame)this.getFrame()).killAllLoadsOf(v);
            }
        }
        catch (DataflowAnalysisException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitMONITORENTER(MONITORENTER obj) {
        ((ValueNumberFrame)this.getFrame()).killAllLoads();
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.killLoadsOfObjectsPassed((InvokeInstruction)obj);
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        if (obj.getMethodName(this.cpg).equals("lock")) {
            ((ValueNumberFrame)this.getFrame()).killAllLoads();
        } else {
            this.killLoadsOfObjectsPassed((InvokeInstruction)obj);
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        if (obj.getMethodName(this.cpg).equals("lock")) {
            ((ValueNumberFrame)this.getFrame()).killAllLoads();
        } else {
            this.killLoadsOfObjectsPassed((InvokeInstruction)obj);
        }
        this.handleNormalInstruction((Instruction)obj);
    }

    @Override
    public void visitLDC(LDC obj) {
        ValueNumber value;
        Object constantValue = obj.getValue(this.cpg);
        if (constantValue instanceof ConstantClass) {
            ConstantClass constantClass = (ConstantClass)constantValue;
            String className = constantClass.getBytes(this.cpg.getConstantPool());
            value = this.getClassObjectValue(className);
        } else {
            value = this.constantValueMap.get(constantValue);
            if (value == null) {
                value = this.factory.createFreshValue();
                this.constantValueMap.put(constantValue, value);
                if (constantValue instanceof String) {
                    this.stringConstantMap.put(value, (String)constantValue);
                }
            }
        }
        ((ValueNumberFrame)this.getFrame()).pushValue(value);
    }

    @Override
    public void visitIINC(IINC obj) {
        if (obj.getIncrement() == 0) {
            return;
        }
        int local = obj.getIndex();
        ValueNumber[] input = new ValueNumber[]{(ValueNumber)((ValueNumberFrame)this.getFrame()).getValue(local)};
        ValueNumberCache.Entry entry = new ValueNumberCache.Entry(this.handle, input);
        ValueNumber[] output = this.cache.lookupOutputValues(entry);
        if (output == null) {
            output = new ValueNumber[]{this.factory.createFreshValue()};
            this.cache.addOutputValues(entry, output);
        }
        ((ValueNumberFrame)this.getFrame()).setValue(local, output[0]);
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
    }

    private ValueNumber[] popInputValues(int numWordsConsumed) {
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        ValueNumber[] inputValueList = new ValueNumber[numWordsConsumed];
        try {
            frame.getTopStackWords(inputValueList);
            while (numWordsConsumed-- > 0) {
                frame.popValue();
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Error getting input operands", e);
        }
        return inputValueList;
    }

    private void pushOutputValues(ValueNumber[] outputValueList) {
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        for (ValueNumber aOutputValueList : outputValueList) {
            frame.pushValue(aOutputValueList);
        }
    }

    private ValueNumber[] getOutputValues(ValueNumber[] inputValueList, int numWordsProduced) {
        return this.getOutputValues(inputValueList, numWordsProduced, 0);
    }

    private ValueNumber[] getOutputValues(ValueNumber[] inputValueList, int numWordsProduced, int flags) {
        ValueNumberCache.Entry entry = new ValueNumberCache.Entry(this.handle, inputValueList);
        ValueNumber[] outputValueList = this.cache.lookupOutputValues(entry);
        if (outputValueList == null) {
            outputValueList = new ValueNumber[numWordsProduced];
            for (int i = 0; i < numWordsProduced; ++i) {
                ValueNumber freshValue = this.factory.createFreshValue();
                freshValue.setFlags(flags);
                outputValueList[i] = freshValue;
            }
            this.cache.addOutputValues(entry, outputValueList);
        }
        return outputValueList;
    }

    private static String vlts(ValueNumber[] vl) {
        StringBuffer buf = new StringBuffer();
        for (ValueNumber aVl : vl) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(aVl.getNumber());
        }
        return buf.toString();
    }

    private void loadInstanceField(InstanceField instanceField, Instruction obj) {
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[loadInstanceField for field ").append(instanceField).append(" in instruction ").append(this.handle).toString());
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        try {
            ValueNumber[] loadedValue;
            ValueNumber reference = (ValueNumber)frame.popValue();
            AvailableLoad availableLoad = new AvailableLoad(reference, instanceField);
            if (RLE_DEBUG) {
                System.out.println(new StringBuffer().append("[getfield of ").append(availableLoad).append("]").toString());
            }
            if ((loadedValue = frame.getAvailableLoad(availableLoad)) == null) {
                ValueNumber[] inputValueList = new ValueNumber[]{reference};
                loadedValue = this.getOutputValues(inputValueList, this.getNumWordsProduced(obj));
                frame.addAvailableLoad(availableLoad, loadedValue);
                if (RLE_DEBUG) {
                    System.out.println(new StringBuffer().append("[Making load available ").append(availableLoad).append(" <- ").append(ValueNumberFrameModelingVisitor.vlts(loadedValue)).append("]").toString());
                }
            } else if (RLE_DEBUG) {
                System.out.println(new StringBuffer().append("[Found available load ").append(availableLoad).append(" <- ").append(ValueNumberFrameModelingVisitor.vlts(loadedValue)).append("]").toString());
            }
            this.pushOutputValues(loadedValue);
            if (VERIFY_INTEGRITY) {
                this.checkConsumedAndProducedValues(obj, new ValueNumber[]{reference}, loadedValue);
            }
        }
        catch (DataflowAnalysisException e) {
            throw new InvalidBytecodeException("Error loading from instance field", e);
        }
    }

    private void loadStaticField(StaticField staticField, Instruction obj) {
        AvailableLoad availableLoad;
        ValueNumberFrame frame;
        ValueNumber[] loadedValue;
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[loadStaticField for field ").append(staticField).append(" in instruction ").append(this.handle).toString());
        }
        if ((loadedValue = (frame = (ValueNumberFrame)this.getFrame()).getAvailableLoad(availableLoad = new AvailableLoad(staticField))) == null) {
            int numWordsProduced = this.getNumWordsProduced(obj);
            loadedValue = this.getOutputValues(EMPTY_INPUT_VALUE_LIST, numWordsProduced);
            frame.addAvailableLoad(availableLoad, loadedValue);
            if (RLE_DEBUG) {
                System.out.println(new StringBuffer().append("[making load of ").append(staticField).append(" available]").toString());
            }
        } else if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[found available load of ").append(staticField).append("]").toString());
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, new ValueNumber[0], loadedValue);
        }
        this.pushOutputValues(loadedValue);
    }

    private void storeInstanceField(InstanceField instanceField, Instruction obj, boolean pushStoredValue) {
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[storeInstanceField for field ").append(instanceField).append(" in instruction ").append(this.handle).toString());
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        int numWordsConsumed = this.getNumWordsConsumed(obj);
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        ValueNumber reference = inputValueList[0];
        ValueNumber[] storedValue = new ValueNumber[inputValueList.length - 1];
        System.arraycopy(inputValueList, 1, storedValue, 0, inputValueList.length - 1);
        if (pushStoredValue) {
            this.pushOutputValues(storedValue);
        }
        frame.killLoadsOfField(instanceField);
        frame.addAvailableLoad(new AvailableLoad(reference, instanceField), storedValue);
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[making store of ").append(instanceField).append(" available]").toString());
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, inputValueList, pushStoredValue ? storedValue : new ValueNumber[]{});
        }
    }

    private void storeStaticField(StaticField staticField, Instruction obj, boolean pushStoredValue) {
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[storeStaticField for field ").append(staticField).append(" in instruction ").append(this.handle).toString());
        }
        ValueNumberFrame frame = (ValueNumberFrame)this.getFrame();
        AvailableLoad availableLoad = new AvailableLoad(staticField);
        int numWordsConsumed = this.getNumWordsConsumed(obj);
        ValueNumber[] inputValueList = this.popInputValues(numWordsConsumed);
        if (pushStoredValue) {
            this.pushOutputValues(inputValueList);
        }
        frame.killLoadsOfField(staticField);
        frame.addAvailableLoad(availableLoad, inputValueList);
        if (RLE_DEBUG) {
            System.out.println(new StringBuffer().append("[making store of ").append(staticField).append(" available]").toString());
        }
        if (VERIFY_INTEGRITY) {
            this.checkConsumedAndProducedValues(obj, inputValueList, pushStoredValue ? inputValueList : new ValueNumber[]{});
        }
    }

    public ValueNumber getClassObjectValue(String className) {
        ValueNumber value = this.classObjectValueMap.get(className = className.replace('/', '.'));
        if (value == null) {
            value = this.factory.createFreshValue();
            value.setFlag(4);
            this.classObjectValueMap.put(className, value);
        }
        return value;
    }

    @Override
    public /* synthetic */ Object getDefaultValue() {
        return this.getDefaultValue();
    }
}

