/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationalOp {
    final String value;
    final String name;
    private static final Map<String, RelationalOp> map = new HashMap<String, RelationalOp>();
    public static final RelationalOp EQ = new RelationalOp("==", "EQ"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) == 0;
        }
    };
    public static final RelationalOp LEQ = new RelationalOp("<=", "LEQ"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) <= 0;
        }
    };
    public static final RelationalOp NEQ = new RelationalOp("!=", "NEQ"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) != 0;
        }
    };
    public static final RelationalOp GEQ = new RelationalOp(">=", "GEQ"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) >= 0;
        }
    };
    public static final RelationalOp LT = new RelationalOp("<", "LT"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) < 0;
        }
    };
    public static final RelationalOp GT = new RelationalOp(">", "GT"){

        public boolean check(Comparable x, Comparable y) {
            return x.compareTo(y) > 0;
        }
    };

    public abstract <T> boolean check(Comparable<T> var1, Comparable<T> var2);

    public static RelationalOp byName(String s) {
        RelationalOp relationalOp = map.get(s);
        if (relationalOp == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Could not find relOp named ").append(s).append(" in ").append(map.keySet()).toString());
        }
        return relationalOp;
    }

    public static Collection<RelationalOp> values() {
        return map.values();
    }

    private RelationalOp(String value) {
        this(value, "xxx");
    }

    private RelationalOp(String value, String name) {
        this.value = value;
        this.name = name;
        map.put(name, this);
    }

    public String toString() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

