/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plan;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.graph.DepthFirstSearch;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ConstraintEdge;
import edu.umd.cs.findbugs.plan.ConstraintGraph;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorNode;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionPlan {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.execplan.debug");
    private List<Plugin> pluginList = new LinkedList<Plugin>();
    private DetectorFactoryChooser factoryChooser = new DetectorFactoryChooser(){

        public boolean choose(DetectorFactory factory) {
            return true;
        }

        public void enable(DetectorFactory factory) {
        }
    };
    private LinkedList<AnalysisPass> passList = new LinkedList();
    private Map<String, DetectorFactory> factoryMap = new HashMap<String, DetectorFactory>();
    private List<DetectorOrderingConstraint> interPassConstraintList = new LinkedList<DetectorOrderingConstraint>();
    private List<DetectorOrderingConstraint> intraPassConstraintList = new LinkedList<DetectorOrderingConstraint>();
    private Set<DetectorFactory> assignedToPassSet = new HashSet<DetectorFactory>();

    public void setDetectorFactoryChooser(DetectorFactoryChooser factoryChooser) {
        this.factoryChooser = factoryChooser;
    }

    public void addPlugin(Plugin plugin) throws OrderingConstraintException {
        this.pluginList.add(plugin);
        ExecutionPlan.copyTo(plugin.interPassConstraintIterator(), this.interPassConstraintList);
        ExecutionPlan.copyTo(plugin.intraPassConstraintIterator(), this.intraPassConstraintList);
        Iterator<DetectorFactory> i = plugin.detectorFactoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = i.next();
            if (this.factoryMap.put(factory.getFullName(), factory) == null) continue;
            throw new OrderingConstraintException(new StringBuffer().append("Detector ").append(factory.getFullName()).append(" is defined by more than one plugin").toString());
        }
    }

    public void build() throws OrderingConstraintException {
        Iterator<Object> i;
        boolean change;
        for (DetectorFactory detectorFactory : this.factoryMap.values()) {
            detectorFactory.setEnabledButNonReporting(false);
        }
        ArrayList<DetectorOrderingConstraint> allConstraints = new ArrayList<DetectorOrderingConstraint>(this.interPassConstraintList.size() + this.intraPassConstraintList.size());
        allConstraints.addAll(this.interPassConstraintList);
        allConstraints.addAll(this.intraPassConstraintList);
        HashMap<String, DetectorNode> nodeMapAll = new HashMap<String, DetectorNode>();
        ConstraintGraph allPassConstraintGraph = this.buildConstraintGraph(nodeMapAll, new HashSet<DetectorFactory>(this.factoryMap.values()), allConstraints);
        do {
            change = false;
            i = allPassConstraintGraph.vertexIterator();
            while (i.hasNext()) {
                DetectorNode end = (DetectorNode)i.next();
                if (!this.factoryChooser.choose(end.getFactory())) continue;
                Iterator j = allPassConstraintGraph.incomingEdgeIterator(end);
                while (j.hasNext()) {
                    DetectorNode start = (DetectorNode)((ConstraintEdge)j.next()).getSource();
                    DetectorFactory startFactory = start.getFactory();
                    if (this.factoryChooser.choose(startFactory)) continue;
                    this.factoryChooser.enable(startFactory);
                    change = true;
                    if (!DEBUG && !FindBugs2.DEBUG) continue;
                    System.out.println(new StringBuffer().append("Dependences force enabling of ").append(startFactory.getFullName()).toString());
                }
            }
        } while (change);
        i = this.factoryMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            if (this.factoryChooser.choose((DetectorFactory)e.getValue())) continue;
            i.remove();
        }
        HashMap<String, DetectorNode> nodeMap = new HashMap<String, DetectorNode>();
        ConstraintGraph interPassConstraintGraph = this.buildConstraintGraph(nodeMap, new HashSet<DetectorFactory>(this.factoryMap.values()), this.interPassConstraintList);
        if (DEBUG) {
            System.out.println(new StringBuffer().append(interPassConstraintGraph.getNumVertices()).append(" nodes in inter-pass constraint graph").toString());
        }
        this.buildPassList(interPassConstraintGraph);
        for (AnalysisPass pass : this.passList) {
            this.sortPass(this.intraPassConstraintList, this.factoryMap, pass);
        }
        if (this.factoryMap.size() > this.assignedToPassSet.size()) {
            AnalysisPass lastPass;
            if (this.passList.isEmpty()) {
                lastPass = new AnalysisPass();
                this.addPass(lastPass);
            } else {
                lastPass = this.passList.getLast();
            }
            Set<DetectorFactory> unassignedSet = this.getUnassignedSet();
            for (DetectorFactory factory : unassignedSet) {
                this.assignToPass(factory, lastPass);
            }
            this.appendDetectorsToPass(unassignedSet, lastPass);
        }
    }

    public Iterator<AnalysisPass> passIterator() {
        return this.passList.iterator();
    }

    public int getNumPasses() {
        return this.passList.size();
    }

    private static <T> void copyTo(Iterator<T> iter, Collection<T> dest) {
        while (iter.hasNext()) {
            dest.add(iter.next());
        }
    }

    private ConstraintGraph buildConstraintGraph(Map<String, DetectorNode> nodeMap, Set<DetectorFactory> factorySet, List<DetectorOrderingConstraint> constraintList) throws OrderingConstraintException {
        ConstraintGraph result = new ConstraintGraph();
        for (DetectorOrderingConstraint constraint : constraintList) {
            Set<DetectorNode> earlierSet = this.addOrCreateDetectorNodes(constraint.getEarlier(), nodeMap, factorySet, result);
            Set<DetectorNode> laterSet = this.addOrCreateDetectorNodes(constraint.getLater(), nodeMap, factorySet, result);
            this.createConstraintEdges(result, earlierSet, laterSet, constraint);
        }
        return result;
    }

    private Set<DetectorFactory> selectDetectors(DetectorFactorySelector selector, Set<DetectorFactory> candidateSet) {
        HashSet<DetectorFactory> result = new HashSet<DetectorFactory>();
        for (DetectorFactory factory : candidateSet) {
            if (!selector.selectFactory(factory)) continue;
            result.add(factory);
        }
        return result;
    }

    private Set<DetectorNode> addOrCreateDetectorNodes(DetectorFactorySelector selector, Map<String, DetectorNode> nodeMap, Set<DetectorFactory> factorySet, ConstraintGraph constraintGraph) throws OrderingConstraintException {
        HashSet<DetectorNode> result = new HashSet<DetectorNode>();
        Set<DetectorFactory> chosenSet = this.selectDetectors(selector, factorySet);
        for (DetectorFactory factory : chosenSet) {
            DetectorNode node = this.addOrCreateDetectorNode(factory, nodeMap, constraintGraph);
            result.add(node);
        }
        return result;
    }

    private DetectorNode addOrCreateDetectorNode(DetectorFactory factory, Map<String, DetectorNode> nodeMap, ConstraintGraph constraintGraph) throws OrderingConstraintException {
        DetectorNode node = nodeMap.get(factory.getFullName());
        if (node == null) {
            node = new DetectorNode(factory);
            nodeMap.put(factory.getFullName(), node);
            constraintGraph.addVertex(node);
        }
        return node;
    }

    private void createConstraintEdges(ConstraintGraph result, Set<DetectorNode> earlierSet, Set<DetectorNode> laterSet, DetectorOrderingConstraint constraint) throws OrderingConstraintException {
        if (earlierSet.isEmpty() || laterSet.isEmpty()) {
            return;
        }
        for (DetectorNode earlier : earlierSet) {
            for (DetectorNode later : laterSet) {
                result.createEdge(earlier, later);
            }
        }
    }

    private void buildPassList(ConstraintGraph constraintGraph) throws OrderingConstraintException {
        while (constraintGraph.getNumVertices() > 0) {
            LinkedList<DetectorNode> inDegreeZeroList = new LinkedList<DetectorNode>();
            Iterator i = constraintGraph.vertexIterator();
            while (i.hasNext()) {
                DetectorNode node = (DetectorNode)i.next();
                if (constraintGraph.getNumIncomingEdges(node) != 0) continue;
                inDegreeZeroList.add(node);
            }
            if (inDegreeZeroList.isEmpty()) {
                throw new OrderingConstraintException("Cycle in inter-pass ordering constraints");
            }
            for (DetectorNode node : inDegreeZeroList) {
                constraintGraph.removeVertex(node);
            }
            AnalysisPass pass = new AnalysisPass();
            this.addPass(pass);
            for (DetectorNode node : inDegreeZeroList) {
                this.assignToPass(node.getFactory(), pass);
            }
        }
    }

    private void addPass(AnalysisPass pass) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Adding pass ").append(this.passList.size()).toString());
        }
        this.passList.add(pass);
    }

    private void sortPass(List<DetectorOrderingConstraint> constraintList, Map<String, DetectorFactory> factoryMap, AnalysisPass pass) throws OrderingConstraintException {
        HashSet<DetectorFactory> detectorSet = new HashSet<DetectorFactory>(pass.getMembers());
        if (DEBUG) {
            System.out.println(new StringBuffer().append(detectorSet.size()).append(" detectors currently in this pass").toString());
        }
        LinkedList<DetectorOrderingConstraint> passConstraintList = new LinkedList<DetectorOrderingConstraint>();
        for (DetectorOrderingConstraint constraint : constraintList) {
            if (this.selectDetectors(constraint.getEarlier(), detectorSet).size() <= 0 && this.selectDetectors(constraint.getLater(), detectorSet).size() <= 0) continue;
            passConstraintList.add(constraint);
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append(passConstraintList.size()).append(" constraints are applicable for this pass").toString());
        }
        HashSet<DetectorFactory> availableSet = new HashSet<DetectorFactory>();
        availableSet.addAll(detectorSet);
        availableSet.addAll(this.getUnassignedSet());
        HashMap<String, DetectorNode> nodeMap = new HashMap<String, DetectorNode>();
        ConstraintGraph constraintGraph = this.buildConstraintGraph(nodeMap, availableSet, passConstraintList);
        if (DEBUG) {
            System.out.println("Pass constraint graph:");
            this.dumpGraph(constraintGraph);
        }
        for (DetectorNode node : nodeMap.values()) {
            if (pass.contains(node.getFactory())) continue;
            this.assignToPass(node.getFactory(), pass);
        }
        DepthFirstSearch dfs = new DepthFirstSearch(constraintGraph);
        dfs.search();
        if (dfs.containsCycle()) {
            throw new OrderingConstraintException("Cycle in intra-pass ordering constraints!");
        }
        Iterator i = dfs.topologicalSortIterator();
        while (i.hasNext()) {
            DetectorNode node = (DetectorNode)i.next();
            this.appendToPass(node.getFactory(), pass);
        }
        this.appendDetectorsToPass(pass.getUnpositionedMembers(), pass);
    }

    private Set<DetectorFactory> getUnassignedSet() {
        HashSet<DetectorFactory> unassignedSet = new HashSet<DetectorFactory>();
        unassignedSet.addAll(this.factoryMap.values());
        unassignedSet.removeAll(this.assignedToPassSet);
        return unassignedSet;
    }

    private void assignToPass(DetectorFactory factory, AnalysisPass pass) {
        pass.addToPass(factory);
        this.assignedToPassSet.add(factory);
    }

    private void appendToPass(DetectorFactory factory, AnalysisPass pass) throws OrderingConstraintException {
        pass.append(factory);
    }

    private void appendDetectorsToPass(Collection<DetectorFactory> detectorSet, AnalysisPass pass) throws OrderingConstraintException {
        DetectorFactory[] unassignedList = detectorSet.toArray(new DetectorFactory[detectorSet.size()]);
        Arrays.sort(unassignedList, new Comparator<DetectorFactory>(){

            @Override
            public int compare(DetectorFactory a, DetectorFactory b) {
                int cmp = a.getPlugin().getPluginId().compareTo(b.getPlugin().getPluginId());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getPositionSpecifiedInPluginDescriptor() - b.getPositionSpecifiedInPluginDescriptor();
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((DetectorFactory)x0, (DetectorFactory)x1);
            }
        });
        for (DetectorFactory factory : unassignedList) {
            this.appendToPass(factory, pass);
        }
    }

    private void print() {
        int passCount = 0;
        Iterator i = this.passList.iterator();
        while (i.hasNext()) {
            System.out.println(new StringBuffer().append("Pass ").append(passCount).toString());
            AnalysisPass pass = (AnalysisPass)i.next();
            Iterator<DetectorFactory> j = pass.iterator();
            while (j.hasNext()) {
                DetectorFactory factory = j.next();
                System.out.println(new StringBuffer().append("  ").append(factory.getFullName()).toString());
            }
            ++passCount;
        }
    }

    private void dumpGraph(ConstraintGraph graph) {
        Iterator i = graph.edgeIterator();
        while (i.hasNext()) {
            ConstraintEdge edge = (ConstraintEdge)i.next();
            System.out.println(new StringBuffer().append(((DetectorNode)edge.getSource()).getFactory().getFullName()).append(" ==> ").append(((DetectorNode)edge.getTarget()).getFactory().getFullName()).toString());
        }
    }

    public static void main(String[] argv) throws Exception {
        DetectorFactoryCollection detectorFactoryCollection = DetectorFactoryCollection.instance();
        ExecutionPlan execPlan = new ExecutionPlan();
        for (String pluginId : argv) {
            Plugin plugin = detectorFactoryCollection.getPluginById(pluginId);
            if (plugin == null) continue;
            execPlan.addPlugin(plugin);
        }
        execPlan.build();
        System.out.println(new StringBuffer().append(execPlan.getNumPasses()).append(" passes in plan").toString());
        execPlan.print();
    }
}

