/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.List;
import java.util.Map;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDomSerializer {
    private DefaultJDOMFactory factory;
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public JDomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public JDomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createJDom(TagNode rootNode) {
        this.factory = new DefaultJDOMFactory();
        if (rootNode.getName() == null) {
            return null;
        }
        Element rootElement = this.createElement(rootNode);
        Document document = this.factory.document(rootElement);
        this.setAttributes(rootNode, rootElement);
        this.createSubnodes(rootElement, rootNode.getAllChildren());
        return document;
    }

    private Element createElement(TagNode node) {
        Element element;
        String name = node.getName();
        boolean nsAware = this.props.isNamespacesAware();
        String prefix = Utils.getXmlNSPrefix(name);
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        String nsURI = null;
        if (prefix != null) {
            name = Utils.getXmlName(name);
            if (nsAware) {
                if (nsDeclarations != null) {
                    nsURI = nsDeclarations.get(prefix);
                }
                if (nsURI == null) {
                    nsURI = node.getNamespaceURIOnPath(prefix);
                }
                if (nsURI == null) {
                    nsURI = prefix;
                }
            }
        } else if (nsAware) {
            if (nsDeclarations != null) {
                nsURI = nsDeclarations.get("");
            }
            if (nsURI == null) {
                nsURI = node.getNamespaceURIOnPath(prefix);
            }
        }
        if (nsAware && nsURI != null) {
            Namespace ns = prefix == null ? Namespace.getNamespace((String)nsURI) : Namespace.getNamespace((String)prefix, (String)nsURI);
            element = this.factory.element(name, ns);
        } else {
            element = this.factory.element(name);
        }
        if (nsAware) {
            this.defineNamespaceDeclarations(node, element);
        }
        return element;
    }

    private void defineNamespaceDeclarations(TagNode node, Element element) {
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        if (nsDeclarations != null) {
            for (Map.Entry<String, String> nsEntry : nsDeclarations.entrySet()) {
                String nsPrefix = nsEntry.getKey();
                String nsURI = nsEntry.getValue();
                Namespace ns = nsPrefix == null || "".equals(nsPrefix) ? Namespace.getNamespace((String)nsURI) : Namespace.getNamespace((String)nsPrefix, (String)nsURI);
                element.addNamespaceDeclaration(ns);
            }
        }
    }

    private void setAttributes(TagNode node, Element element) {
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (this.escapeXml) {
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            String attPrefix = Utils.getXmlNSPrefix(attrName);
            Namespace ns = null;
            if (attPrefix != null) {
                attrName = Utils.getXmlName(attrName);
                if (this.props.isNamespacesAware()) {
                    String nsURI = node.getNamespaceURIOnPath(attPrefix);
                    if (nsURI == null) {
                        nsURI = attPrefix;
                    }
                    if (!attPrefix.startsWith("xml")) {
                        ns = Namespace.getNamespace((String)attPrefix, (String)nsURI);
                    }
                }
            }
            if (attrName.equals("xmlns")) continue;
            if (ns == null) {
                element.setAttribute(attrName, attrValue);
                continue;
            }
            element.setAttribute(attrName, attrValue, ns);
        }
    }

    private void createSubnodes(Element element, List<? extends BaseToken> tagChildren) {
        if (tagChildren != null) {
            for (BaseToken baseToken : tagChildren) {
                if (baseToken instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)baseToken;
                    Comment comment = this.factory.comment(commentNode.getContent().toString());
                    element.addContent((Content)comment);
                    continue;
                }
                if (baseToken instanceof ContentNode) {
                    boolean specialCase;
                    String nodeName = element.getName();
                    String content = baseToken.toString();
                    boolean bl = specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    if (specialCase && baseToken instanceof CData) {
                        content = ((CData)baseToken).getContentWithoutStartAndEndTokens();
                    }
                    CDATA text = specialCase ? this.factory.cdata(content) : this.factory.text(content);
                    element.addContent((Content)text);
                    continue;
                }
                if (baseToken instanceof TagNode) {
                    TagNode subTagNode = (TagNode)baseToken;
                    Element subelement = this.createElement(subTagNode);
                    this.setAttributes(subTagNode, subelement);
                    this.createSubnodes(subelement, subTagNode.getAllChildren());
                    element.addContent((Content)subelement);
                    continue;
                }
                if (!(baseToken instanceof List)) continue;
                List sublist = (List)((Object)baseToken);
                this.createSubnodes(element, sublist);
            }
        }
    }
}

