/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SimpleHTMLParserListener
implements HTMLParserListener {
    private static final Log LOG = LogFactory.getLog(SimpleHTMLParserListener.class);

    SimpleHTMLParserListener() {
    }

    @Override
    public void error(String message, URL url, String html, int line, int column, String key) {
        LOG.error((Object)SimpleHTMLParserListener.format(message, url, html, line, column));
    }

    @Override
    public void warning(String message, URL url, String html, int line, int column, String key) {
        LOG.warn((Object)SimpleHTMLParserListener.format(message, url, html, line, column));
    }

    private static String format(String message, URL url, String html, int line, int column) {
        StringBuilder builder = new StringBuilder(message);
        builder.append(" (").append(url.toExternalForm()).append(' ').append(line).append(':').append(column);
        if (null != html) {
            builder.append(" htmlSnippet: '").append(html).append('\'');
        }
        builder.append(')');
        return builder.toString();
    }
}

