/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlArea
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlArea.class);
    public static final String TAG_NAME = "area";
    private static final String SHAPE_RECT = "rect";
    private static final String SHAPE_CIRCLE = "circle";
    private static final String SHAPE_POLY = "poly";

    HtmlArea(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlPage enclosingPage = (HtmlPage)this.getPage();
        WebClient webClient = enclosingPage.getWebClient();
        String href = this.getHrefAttribute().trim();
        if (!href.isEmpty()) {
            URL url;
            HtmlPage page = (HtmlPage)this.getPage();
            if (StringUtils.startsWithIgnoreCase((CharSequence)href, (CharSequence)"javascript:")) {
                page.executeJavaScript(href, "javascript url", this.getStartLineNumber());
                return false;
            }
            try {
                url = enclosingPage.getFullyQualifiedUrl(this.getHrefAttribute());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Not a valid url: " + this.getHrefAttribute(), e);
            }
            WebRequest request = new WebRequest(url);
            request.setCharset(page.getCharset());
            request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
            WebWindow webWindow = enclosingPage.getEnclosingWindow();
            webClient.getPage(webWindow, enclosingPage.getResolvedTarget(this.getTargetAttribute()), request);
        }
        return false;
    }

    public final String getShapeAttribute() {
        return this.getAttributeDirect("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeDirect("coords");
    }

    public final String getHrefAttribute() {
        return this.getAttributeDirect("href");
    }

    public final String getNoHrefAttribute() {
        return this.getAttributeDirect("nohref");
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    boolean containsPoint(int x, int y) {
        String shape = ((String)StringUtils.defaultIfEmpty((CharSequence)this.getShapeAttribute(), (CharSequence)SHAPE_RECT)).toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return true;
        }
        if (SHAPE_RECT.equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.contains(x, y);
        }
        if (SHAPE_CIRCLE.equals(shape) && this.getCoordsAttribute() != null) {
            Ellipse2D ellipse = this.parseCircle();
            return ellipse.contains(x, y);
        }
        if (SHAPE_POLY.equals(shape) && this.getCoordsAttribute() != null) {
            GeneralPath path = this.parsePoly();
            return path.contains(x, y);
        }
        return false;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        DomNode parent = this.getParentNode();
        if (null != parent && parent instanceof HtmlMap && parent.isDisplayed()) {
            return !this.isEmpty();
        }
        return false;
    }

    private Rectangle2D parseRect() {
        double bottomY;
        double rightX;
        double topY;
        double leftX;
        block6: {
            Object[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
            leftX = 0.0;
            topY = 0.0;
            rightX = 0.0;
            bottomY = 0.0;
            try {
                if (coords.length > 0) {
                    leftX = Double.parseDouble(coords[0].trim());
                }
                if (coords.length > 1) {
                    topY = Double.parseDouble(coords[1].trim());
                }
                if (coords.length > 2) {
                    rightX = Double.parseDouble(((String)coords[2]).trim());
                }
                if (coords.length > 3) {
                    bottomY = Double.parseDouble(((String)coords[3]).trim());
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)("Invalid rect coords '" + Arrays.toString(coords) + "'"), (Throwable)e);
            }
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double(leftX, topY, rightX - leftX, bottomY - topY);
        return rectangle;
    }

    private Ellipse2D parseCircle() {
        int radius;
        String[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
        String radiusString = coords[2].trim();
        try {
            radius = Integer.parseInt(radiusString);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("Circle radius of " + radiusString + " is not yet implemented.");
        }
        double centerX = Double.parseDouble(coords[0].trim());
        double centerY = Double.parseDouble(coords[1].trim());
        Ellipse2D.Double ellipse = new Ellipse2D.Double(centerX - (double)radius / 2.0, centerY - (double)radius / 2.0, radius, radius);
        return ellipse;
    }

    private GeneralPath parsePoly() {
        GeneralPath path;
        block5: {
            Object[] coords = StringUtils.split((String)this.getCoordsAttribute(), (String)", ");
            path = new GeneralPath();
            try {
                int i = 0;
                while (i + 1 < coords.length) {
                    if (i == 0) {
                        path.moveTo(Float.parseFloat((String)coords[i]), Float.parseFloat((String)coords[i + 1]));
                    } else {
                        path.lineTo(Float.parseFloat((String)coords[i]), Float.parseFloat((String)coords[i + 1]));
                    }
                    i += 2;
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block5;
                LOG.warn((Object)("Invalid poly coords '" + Arrays.toString(coords) + "'"), (Throwable)e);
            }
        }
        path.closePath();
        return path;
    }

    private boolean isEmpty() {
        String shape = ((String)StringUtils.defaultIfEmpty((CharSequence)this.getShapeAttribute(), (CharSequence)SHAPE_RECT)).toLowerCase(Locale.ROOT);
        if ("default".equals(shape) && this.getCoordsAttribute() != null) {
            return false;
        }
        if (SHAPE_RECT.equals(shape) && this.getCoordsAttribute() != null) {
            Rectangle2D rectangle = this.parseRect();
            return rectangle.isEmpty();
        }
        if (SHAPE_CIRCLE.equals(shape) && this.getCoordsAttribute() != null) {
            Ellipse2D ellipse = this.parseCircle();
            return ellipse.isEmpty();
        }
        if (SHAPE_POLY.equals(shape) && this.getCoordsAttribute() != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }
}

