/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.serializer;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlDetails;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlMenu;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlSummary;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HtmlSerializerVisibleText {
    public String asText(DomNode node) {
        if (node instanceof HtmlBreak) {
            return "";
        }
        HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
        this.appendNode(builder, node, HtmlSerializerVisibleText.whiteSpaceStyle(node, HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL));
        return builder.getText();
    }

    protected void appendChildren(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child, mode);
        }
    }

    protected void appendNode(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node, mode);
        } else if (node instanceof DomComment) {
            this.appendComment(builder, (DomComment)node, mode);
        } else if (node instanceof HtmlApplet && node.getPage().getWebClient().getOptions().isAppletEnabled()) {
            this.appendApplet(builder, (HtmlApplet)node, mode);
        } else if (node instanceof HtmlBreak) {
            this.appendBreak(builder, (HtmlBreak)node, mode);
        } else if (node instanceof HtmlHiddenInput) {
            this.appendHiddenInput(builder, (HtmlHiddenInput)node, mode);
        } else if (node instanceof HtmlScript) {
            this.appendScript(builder, (HtmlScript)node, mode);
        } else if (node instanceof HtmlStyle) {
            this.appendStyle(builder, (HtmlStyle)node, mode);
        } else if (node instanceof HtmlNoFrames) {
            this.appendNoFrames(builder, (HtmlNoFrames)node, mode);
        } else if (node instanceof HtmlTextArea) {
            this.appendTextArea(builder, (HtmlTextArea)node, mode);
        } else if (node instanceof HtmlTitle) {
            this.appendTitle(builder, (HtmlTitle)node, mode);
        } else if (node instanceof HtmlTableRow) {
            this.appendTableRow(builder, (HtmlTableRow)node, mode);
        } else if (node instanceof HtmlSelect) {
            this.appendSelect(builder, (HtmlSelect)node, mode);
        } else if (node instanceof HtmlOption) {
            this.appendOption(builder, (HtmlOption)node, mode);
        } else if (node instanceof HtmlSubmitInput) {
            this.appendSubmitInput(builder, (HtmlSubmitInput)node, mode);
        } else if (node instanceof HtmlResetInput) {
            this.appendResetInput(builder, (HtmlResetInput)node, mode);
        } else if (node instanceof HtmlCheckBoxInput) {
            this.appendCheckBoxInput(builder, (HtmlCheckBoxInput)node, mode);
        } else if (node instanceof HtmlRadioButtonInput) {
            this.appendRadioButtonInput(builder, (HtmlRadioButtonInput)node, mode);
        } else if (!(node instanceof HtmlInput)) {
            if (node instanceof HtmlTable) {
                this.appendTable(builder, (HtmlTable)node, mode);
            } else if (node instanceof HtmlOrderedList) {
                this.appendOrderedList(builder, (HtmlOrderedList)node, mode);
            } else if (node instanceof HtmlUnorderedList) {
                this.appendUnorderedList(builder, (HtmlUnorderedList)node, mode);
            } else if (node instanceof HtmlPreformattedText) {
                this.appendPreformattedText(builder, (HtmlPreformattedText)node, mode);
            } else if (node instanceof HtmlInlineFrame) {
                this.appendInlineFrame(builder, (HtmlInlineFrame)node, mode);
            } else if (node instanceof HtmlMenu) {
                this.appendMenu(builder, (HtmlMenu)node, mode);
            } else if (node instanceof HtmlDetails) {
                this.appendDetails(builder, (HtmlDetails)node, mode);
            } else if (node instanceof HtmlNoScript && node.getPage().getWebClient().isJavaScriptEnabled()) {
                this.appendNoScript(builder, (HtmlNoScript)node, mode);
            } else {
                this.appendDomNode(builder, node, mode);
            }
        }
    }

    protected void appendDomNode(HtmlSerializerTextBuilder builder, DomNode domNode, HtmlSerializerTextBuilder.Mode mode) {
        boolean block;
        Object scriptableObject = domNode.getScriptableObject();
        if (domNode instanceof HtmlBody) {
            block = false;
        } else if (scriptableObject instanceof Element) {
            Element element = (Element)scriptableObject;
            String display = element.getWindow().getComputedStyle(element, null).getDisplay();
            block = "block".equals(display);
        } else {
            block = false;
        }
        if (block) {
            builder.appendBlockSeparator();
        }
        this.appendChildren(builder, domNode, mode);
        if (block) {
            builder.appendBlockSeparator();
        }
    }

    protected void appendHiddenInput(HtmlSerializerTextBuilder builder, HtmlHiddenInput htmlHiddenInput, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendScript(HtmlSerializerTextBuilder builder, HtmlScript htmlScript, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendStyle(HtmlSerializerTextBuilder builder, HtmlStyle htmlStyle, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendNoScript(HtmlSerializerTextBuilder builder, HtmlNoScript htmlNoScript, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendNoFrames(HtmlSerializerTextBuilder builder, HtmlNoFrames htmlNoFrames, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendSubmitInput(HtmlSerializerTextBuilder builder, HtmlSubmitInput htmlSubmitInput, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendInput(HtmlSerializerTextBuilder builder, HtmlInput htmlInput, HtmlSerializerTextBuilder.Mode mode) {
        builder.append(htmlInput.getValueAttribute(), mode);
    }

    protected void appendResetInput(HtmlSerializerTextBuilder builder, HtmlResetInput htmlResetInput, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendMenu(HtmlSerializerTextBuilder builder, HtmlMenu htmlMenu, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendBlockSeparator();
        boolean first = true;
        for (DomNode item : htmlMenu.getChildren()) {
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendNode(builder, item, mode);
        }
        builder.appendBlockSeparator();
    }

    protected void appendDetails(HtmlSerializerTextBuilder builder, HtmlDetails htmlDetails, HtmlSerializerTextBuilder.Mode mode) {
        if (htmlDetails.isOpen()) {
            this.appendChildren(builder, htmlDetails, mode);
            return;
        }
        for (DomNode child : htmlDetails.getChildren()) {
            if (!(child instanceof HtmlSummary)) continue;
            this.appendNode(builder, child, mode);
        }
    }

    protected void appendTitle(HtmlSerializerTextBuilder builder, HtmlTitle htmlTitle, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendTableRow(HtmlSerializerTextBuilder builder, HtmlTableRow htmlTableRow, HtmlSerializerTextBuilder.Mode mode) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                builder.appendBlank();
            } else {
                first = false;
            }
            this.appendChildren(builder, cell, mode);
        }
    }

    protected void appendTextArea(HtmlSerializerTextBuilder builder, HtmlTextArea htmlTextArea, HtmlSerializerTextBuilder.Mode mode) {
        if (htmlTextArea.isDisplayed()) {
            builder.append(htmlTextArea.getDefaultValue(), HtmlSerializerVisibleText.whiteSpaceStyle(htmlTextArea, HtmlSerializerTextBuilder.Mode.PRE));
            builder.trimRight(HtmlSerializerTextBuilder.Mode.PRE);
        }
    }

    protected void appendTable(HtmlSerializerTextBuilder builder, HtmlTable htmlTable, HtmlSerializerTextBuilder.Mode mode) {
        DomNode firstChild;
        builder.appendBlockSeparator();
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            builder.append(caption, mode);
            builder.appendBlockSeparator();
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendTableRows(builder, mode, tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        List<HtmlTableRow> tableRows = htmlTable.getRows();
        first = this.appendTableRows(builder, mode, tableRows, first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendTableRows(builder, mode, tableFooter.getRows(), first, null, null);
        } else if (tableRows.isEmpty() && (firstChild = htmlTable.getFirstChild()) != null) {
            this.appendNode(builder, firstChild, mode);
        }
        builder.appendBlockSeparator();
    }

    protected boolean appendTableRows(HtmlSerializerTextBuilder builder, HtmlSerializerTextBuilder.Mode mode, List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendTableRow(builder, row, mode);
        }
        return first;
    }

    protected void appendSelect(HtmlSerializerTextBuilder builder, HtmlSelect htmlSelect, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        HtmlSerializerTextBuilder.Mode selectMode = HtmlSerializerVisibleText.whiteSpaceStyle(htmlSelect, mode);
        for (DomNode item : htmlSelect.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, HtmlSerializerVisibleText.whiteSpaceStyle(item, selectMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendOption(HtmlSerializerTextBuilder builder, HtmlOption htmlOption, HtmlSerializerTextBuilder.Mode mode) {
        builder.ignoreHtmlBreaks();
        this.appendChildren(builder, htmlOption, mode);
        builder.processHtmlBreaks();
    }

    protected void appendOrderedList(HtmlSerializerTextBuilder builder, HtmlOrderedList htmlOrderedList, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        HtmlSerializerTextBuilder.Mode olMode = HtmlSerializerVisibleText.whiteSpaceStyle(htmlOrderedList, mode);
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, HtmlSerializerVisibleText.whiteSpaceStyle(item, olMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendUnorderedList(HtmlSerializerTextBuilder builder, HtmlUnorderedList htmlUnorderedList, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendBlockSeparator();
        boolean leadingNlPending = false;
        HtmlSerializerTextBuilder.Mode ulMode = HtmlSerializerVisibleText.whiteSpaceStyle(htmlUnorderedList, mode);
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (leadingNlPending) {
                builder.appendBlockSeparator();
                leadingNlPending = false;
            }
            builder.resetContentAdded();
            this.appendNode(builder, item, HtmlSerializerVisibleText.whiteSpaceStyle(item, ulMode));
            if (leadingNlPending || !builder.contentAdded_) continue;
            leadingNlPending = true;
        }
        builder.appendBlockSeparator();
    }

    protected void appendPreformattedText(HtmlSerializerTextBuilder builder, HtmlPreformattedText htmlPreformattedText, HtmlSerializerTextBuilder.Mode mode) {
        if (htmlPreformattedText.isDisplayed()) {
            builder.appendBlockSeparator();
            this.appendChildren(builder, htmlPreformattedText, HtmlSerializerVisibleText.whiteSpaceStyle(htmlPreformattedText, HtmlSerializerTextBuilder.Mode.PRE));
            builder.appendBlockSeparator();
        }
    }

    protected void appendInlineFrame(HtmlSerializerTextBuilder builder, HtmlInlineFrame htmlInlineFrame, HtmlSerializerTextBuilder.Mode mode) {
        if (htmlInlineFrame.isDisplayed()) {
            builder.appendBlockSeparator();
            Page page = htmlInlineFrame.getEnclosedPage();
            if (page instanceof SgmlPage) {
                builder.append(((SgmlPage)page).asText(), mode);
            }
            builder.appendBlockSeparator();
        }
    }

    protected void appendText(HtmlSerializerTextBuilder builder, DomText domText, HtmlSerializerTextBuilder.Mode mode) {
        DomNode parent = domText.getParentNode();
        if (parent instanceof HtmlTitle || parent instanceof HtmlScript) {
            builder.append(domText.getData(), HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE_LINE);
        }
        if (parent == null || parent instanceof HtmlTitle || parent instanceof HtmlScript || parent.isDisplayed()) {
            builder.append(domText.getData(), mode);
        }
    }

    protected void appendComment(HtmlSerializerTextBuilder builder, DomComment domComment, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendApplet(HtmlSerializerTextBuilder builder, HtmlApplet htmlApplet, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendBreak(HtmlSerializerTextBuilder builder, HtmlBreak htmlBreak, HtmlSerializerTextBuilder.Mode mode) {
        builder.appendBreak(mode);
    }

    protected void appendCheckBoxInput(HtmlSerializerTextBuilder builder, HtmlCheckBoxInput htmlCheckBoxInput, HtmlSerializerTextBuilder.Mode mode) {
    }

    protected void appendRadioButtonInput(HtmlSerializerTextBuilder builder, HtmlRadioButtonInput htmlRadioButtonInput, HtmlSerializerTextBuilder.Mode mode) {
    }

    private static HtmlSerializerTextBuilder.Mode whiteSpaceStyle(DomNode domNode, HtmlSerializerTextBuilder.Mode defaultMode) {
        SgmlPage page;
        Object scriptableObject = domNode.getScriptableObject();
        if (scriptableObject instanceof Node && (page = domNode.getPage()) != null && page.getEnclosingWindow().getWebClient().getOptions().isCssEnabled()) {
            for (Node node = (Node)scriptableObject; node != null; node = node.getParentElement()) {
                CSS2Properties style;
                String value;
                if (!(node instanceof Element) || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{value = (style = node.getWindow().getComputedStyle(node, null)).getStyleAttribute(StyleAttributes.Definition.WHITE_SPACE, false)})) continue;
                if ("normal".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("nowrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("pre".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if ("pre-wrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if (!"pre-line".equalsIgnoreCase(value)) continue;
                return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE_LINE;
            }
        }
        return defaultMode;
    }

    protected static class HtmlSerializerTextBuilder {
        private State state_;
        private final StringBuilder builder_ = new StringBuilder();
        private int trimRightPos_ = 0;
        private boolean contentAdded_;
        private boolean ignoreHtmlBreaks_;

        public HtmlSerializerTextBuilder() {
            this.state_ = State.EMPTY;
        }

        public void append(String content, Mode mode) {
            int length = content.length();
            if (length == 0) {
                return;
            }
            --length;
            int i = -1;
            for (char c : content.toCharArray()) {
                ++i;
                if (c == '\r') {
                    if (length != i) continue;
                    c = '\n';
                }
                if (c == '\n') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    if (mode == Mode.PRE) {
                        this.builder_.append('\n');
                        this.state_ = State.NEWLINE_AT_END;
                        this.trimRightPos_ = this.builder_.length();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\f') {
                    if (mode == Mode.WHITE_SPACE_PRE || mode == Mode.PRE) {
                        this.appendBlank();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLANK_AT_END: 
                            case BLANK_AT_END_AFTER_NEWLINE: 
                            case BREAK_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\u00a0') {
                    this.appendBlank();
                    if (mode != Mode.WHITE_SPACE_NORMAL && mode != Mode.WHITE_SPACE_PRE_LINE) continue;
                    this.state_ = State.DEFAULT;
                    continue;
                }
                this.builder_.append(c);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
                this.contentAdded_ = true;
            }
        }

        public void appendBlockSeparator() {
            switch (this.state_) {
                case EMPTY: {
                    break;
                }
                case BLANK_AT_END: {
                    this.builder_.setLength(this.trimRightPos_);
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLANK_AT_END_AFTER_NEWLINE: {
                    this.builder_.setLength(this.trimRightPos_ - 1);
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLOCK_SEPARATOR_AT_END: {
                    break;
                }
                case NEWLINE_AT_END: 
                case BREAK_AT_END: {
                    this.builder_.setLength(this.builder_.length() - 1);
                    --this.trimRightPos_;
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                default: {
                    this.builder_.append('\n');
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                }
            }
        }

        public void appendBreak(Mode mode) {
            if (this.ignoreHtmlBreaks_) {
                return;
            }
            this.builder_.setLength(this.trimRightPos_);
            this.builder_.append('\n');
            this.state_ = State.BREAK_AT_END;
            this.trimRightPos_ = this.builder_.length();
        }

        public void appendBlank() {
            this.builder_.append(' ');
            this.state_ = State.BLANK_AT_END;
            this.trimRightPos_ = this.builder_.length();
        }

        public void trimRight(Mode mode) {
            if (mode == Mode.PRE) {
                switch (this.state_) {
                    case BLOCK_SEPARATOR_AT_END: 
                    case NEWLINE_AT_END: 
                    case BREAK_AT_END: {
                        if (this.trimRightPos_ != this.builder_.length()) break;
                        --this.trimRightPos_;
                        break;
                    }
                }
            }
            this.builder_.setLength(this.trimRightPos_);
            this.state_ = State.DEFAULT;
            if (this.builder_.length() == 0) {
                this.state_ = State.EMPTY;
            }
        }

        public boolean wasContentAdded() {
            return this.contentAdded_;
        }

        public void resetContentAdded() {
            this.contentAdded_ = false;
        }

        public void ignoreHtmlBreaks() {
            this.ignoreHtmlBreaks_ = true;
        }

        public void processHtmlBreaks() {
            this.ignoreHtmlBreaks_ = false;
        }

        public String getText() {
            return this.builder_.substring(0, this.trimRightPos_);
        }

        private static enum State {
            DEFAULT,
            EMPTY,
            BLANK_AT_END,
            BLANK_AT_END_AFTER_NEWLINE,
            NEWLINE_AT_END,
            BREAK_AT_END,
            BLOCK_SEPARATOR_AT_END;

        }

        protected static enum Mode {
            PRE,
            WHITE_SPACE_NORMAL,
            WHITE_SPACE_PRE,
            WHITE_SPACE_PRE_LINE;

        }
    }
}

