/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlTableCell.class)
public class HTMLTableCellElement
extends HTMLTableComponent {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public HTMLTableCellElement() {
    }

    @Override
    public int getOffsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return super.getOffsetHeight();
        }
        if (this.isDisplayNone()) {
            return 0;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        boolean includeBorder = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_OFFSET_INCLUDES_BORDER);
        return style.getCalculatedHeight(includeBorder, true);
    }

    @Override
    public int getOffsetWidth() {
        HtmlTableRow row;
        float w = super.getOffsetWidth();
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return (int)w;
        }
        if (this.isDisplayNone()) {
            return 0;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        if ("collapse".equals(style.getStyleAttribute(StyleAttributes.Definition.BORDER_COLLAPSE)) && (row = this.getRow()) != null) {
            HtmlElement thiz = this.getDomNodeOrDie();
            List<HtmlTableCell> cells = row.getCells();
            boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_OFFSET_INCLUDES_BORDER);
            boolean leftmost = cells.indexOf(thiz) == 0;
            boolean rightmost = cells.indexOf(thiz) == cells.size() - 1;
            w = (float)((double)w - (ie && leftmost ? 0.0 : 0.5) * (double)style.getBorderLeftValue());
            w = (float)((double)w - (ie && rightmost ? 0.0 : 0.5) * (double)style.getBorderRightValue());
        }
        return (int)w;
    }

    @JsxGetter
    public Integer getCellIndex() {
        HtmlTableCell cell = (HtmlTableCell)this.getDomNodeOrDie();
        HtmlTableRow row = cell.getEnclosingRow();
        if (row == null) {
            return -1;
        }
        return row.getCells().indexOf(cell);
    }

    @JsxGetter
    public String getAbbr() {
        return this.getDomNodeOrDie().getAttributeDirect("abbr");
    }

    @JsxSetter
    public void setAbbr(String abbr) {
        this.getDomNodeOrDie().setAttribute("abbr", abbr);
    }

    @JsxGetter
    public String getAxis() {
        return this.getDomNodeOrDie().getAttributeDirect("axis");
    }

    @JsxSetter
    public void setAxis(String axis) {
        this.getDomNodeOrDie().setAttribute("axis", axis);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public int getColSpan() {
        String s = this.getDomNodeOrDie().getAttribute("colSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @JsxSetter
    public void setColSpan(String colSpan) {
        try {
            int i = (int)Double.parseDouble(colSpan);
            if (i <= 0) {
                throw new NumberFormatException(colSpan);
            }
            this.getDomNodeOrDie().setAttribute("colSpan", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_THROWS_EXCEPTION_IF_INVALID)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            this.getDomNodeOrDie().setAttribute("colSpan", "1");
        }
    }

    @JsxGetter
    public int getRowSpan() {
        String s = this.getDomNodeOrDie().getAttribute("rowSpan");
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @JsxSetter
    public void setRowSpan(String rowSpan) {
        try {
            int i = (int)Double.parseDouble(rowSpan);
            if (i < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_SET_ZERO_IF_INVALID)) {
                this.getDomNodeOrDie().setAttribute("rowSpan", "1");
                return;
            }
            if (i <= 0) {
                throw new NumberFormatException(rowSpan);
            }
            this.getDomNodeOrDie().setAttribute("rowSpan", Integer.toString(i));
        }
        catch (NumberFormatException e) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_THROWS_EXCEPTION_IF_INVALID)) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_SET_ZERO_IF_INVALID)) {
                this.getDomNodeOrDie().setAttribute("rowSpan", "0");
            }
            this.getDomNodeOrDie().setAttribute("rowSpan", "1");
        }
    }

    @JsxGetter
    public boolean isNoWrap() {
        return this.getDomNodeOrDie().hasAttribute("noWrap");
    }

    @JsxSetter
    public void setNoWrap(boolean noWrap) {
        if (noWrap) {
            this.getDomNodeOrDie().setAttribute("noWrap", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("noWrap");
        }
    }

    private HtmlTableRow getRow() {
        DomNode node;
        for (node = this.getDomNodeOrDie(); node != null && !(node instanceof HtmlTableRow); node = node.getParentNode()) {
        }
        return (HtmlTableRow)node;
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_WIDTH_DOES_NOT_RETURN_NEGATIVE_VALUES);
        Boolean returnNegativeValues = ie ? Boolean.TRUE : null;
        return this.getWidthOrHeight("width", returnNegativeValues);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_WIDTH_DOES_NOT_RETURN_NEGATIVE_VALUES));
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_HEIGHT_DOES_NOT_RETURN_NEGATIVE_VALUES);
        Boolean returnNegativeValues = ie ? Boolean.TRUE : null;
        return this.getWidthOrHeight("height", returnNegativeValues);
    }

    @JsxSetter(propertyName="height")
    public void setHeight_js(String height) {
        this.setWidthOrHeight("height", height, !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_CELL_HEIGHT_DOES_NOT_RETURN_NEGATIVE_VALUES));
    }

    @Override
    public void setOuterHTML(Object value) {
        throw Context.reportRuntimeError((String)("outerHTML is read-only for tag '" + this.getDomNodeOrDie().getTagName() + "'"));
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColor() {
        return this.getDomNodeOrDie().getAttribute("borderColor");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColor(String borderColor) {
        this.setColorAttribute("borderColor", borderColor);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorDark() {
        return "";
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorDark(String borderColor) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorderColorLight() {
        return "";
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorderColorLight(String borderColor) {
    }

    @JsxGetter
    public String getHeaders() {
        return this.getDomNodeOrDie().getAttributeDirect("headers");
    }

    @JsxSetter
    public void setHeaders(String headers) {
        this.getDomNodeOrDie().setAttribute("headers", headers);
    }

    @JsxGetter
    public String getScope() {
        return this.getDomNodeOrDie().getAttributeDirect("scope");
    }

    @JsxSetter
    public void setScope(String scope) {
        this.getDomNodeOrDie().setAttribute("scope", scope);
    }
}

