/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

class XPathAdapter {
    private final Expression mainExp_;
    private FunctionTable funcTable_;

    private void initFunctionTable() {
        this.funcTable_ = new FunctionTable();
        this.funcTable_.installFunction("lower-case", LowerCaseFunction.class);
    }

    XPathAdapter(String exprString, SourceLocator locator, PrefixResolver prefixResolver, ErrorListener errorListener, boolean caseSensitive) throws TransformerException {
        Expression expr;
        this.initFunctionTable();
        ErrorListener errListener = errorListener;
        if (errListener == null) {
            errListener = new DefaultErrorHandler();
        }
        XPathParser parser = new XPathParser(errListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.funcTable_);
        String expression = XPathAdapter.preProcessXPath(exprString, caseSensitive);
        parser.initXPath(compiler, expression, prefixResolver);
        this.mainExp_ = expr = compiler.compile(0);
        if (locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    private static String preProcessXPath(String xpath, boolean caseSensitive) {
        if (caseSensitive) {
            return xpath;
        }
        char[] charArray = xpath.toCharArray();
        STATE state = STATE.DEFAULT;
        int length = charArray.length;
        int insideBrackets = 0;
        block7: for (int i = 0; i < length; ++i) {
            char ch = charArray[i];
            switch (ch) {
                case '@': {
                    if (state != STATE.DEFAULT) continue block7;
                    state = STATE.ATTRIB;
                    continue block7;
                }
                case '\"': {
                    if (state == STATE.DEFAULT || state == STATE.ATTRIB) {
                        state = STATE.DOUBLE_QUOTED;
                        continue block7;
                    }
                    if (state != STATE.DOUBLE_QUOTED) continue block7;
                    state = STATE.DEFAULT;
                    continue block7;
                }
                case '\'': {
                    if (state == STATE.DEFAULT || state == STATE.ATTRIB) {
                        state = STATE.SINGLE_QUOTED;
                        continue block7;
                    }
                    if (state != STATE.SINGLE_QUOTED) continue block7;
                    state = STATE.DEFAULT;
                    continue block7;
                }
                case '(': 
                case '[': {
                    if (state == STATE.ATTRIB) {
                        state = STATE.DEFAULT;
                    }
                    ++insideBrackets;
                    continue block7;
                }
                case ')': 
                case ']': {
                    if (state == STATE.ATTRIB) {
                        state = STATE.DEFAULT;
                    }
                    --insideBrackets;
                    continue block7;
                }
                default: {
                    boolean isValidAttribChar;
                    if (insideBrackets == 0 && state != STATE.SINGLE_QUOTED && state != STATE.DOUBLE_QUOTED) {
                        charArray[i] = Character.toLowerCase(ch);
                    } else if (state == STATE.ATTRIB) {
                        charArray[i] = Character.toLowerCase(ch);
                    }
                    if (state != STATE.ATTRIB) continue block7;
                    boolean bl = isValidAttribChar = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || '\u00c0' <= ch && ch <= '\u00d6' || '\u00d8' <= ch && ch <= '\u00f6' || '\u00f8' <= ch && ch <= '\u02ff' || '\u0370' <= ch && ch <= '\u037d' || '\u037f' <= ch && ch <= '\u1fff' || '\u200c' <= ch && ch <= '\u200d' || '\u2c00' <= ch && ch <= '\u2fef' || '\u3001' <= ch && ch <= '\ud7ff' || '\uf900' <= ch && ch <= '\ufdcf' || '\ufdf0' <= ch && ch <= '\ufffd' || '\u00b7' == ch || '\u0300' <= ch && ch <= '\u036f' || '\u203f' <= ch && ch <= '\u2040' || '_' == ch || '-' == ch || '.' == ch;
                    if (isValidAttribChar) continue block7;
                    state = STATE.DEFAULT;
                }
            }
        }
        return new String(charArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XObject execute(XPathContext xpathContext, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xpathContext.pushNamespaceContext(namespaceContext);
            xpathContext.pushCurrentNodeAndExpression(contextNode, contextNode);
            xobj = null;
            try {
                xobj = this.mainExp_.execute(xpathContext);
            }
            catch (TransformerException te) {
                te.setLocator((SourceLocator)this.mainExp_);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.isEmpty()) {
                    msg = XPATHMessages.createXPATHMessage((String)"ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, (SourceLocator)this.mainExp_, e);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xpathContext.popNamespaceContext();
                xpathContext.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }

    private static enum STATE {
        DEFAULT,
        DOUBLE_QUOTED,
        SINGLE_QUOTED,
        ATTRIB;

    }
}

