/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class RecursiveFunctionObject
extends FunctionObject {
    public RecursiveFunctionObject(String name, Executable methodOrConstructor, Scriptable scope) {
        super(name, (Member)methodOrConstructor, scope);
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable) || !((Scriptable)scripatble).has(name, start)) continue;
            return true;
        }
        return false;
    }

    public Object[] getIds() {
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>(Arrays.asList(super.getIds()));
        for (Class<?> c = this.getMethodOrConstructor().getDeclaringClass().getSuperclass(); c != null; c = c.getSuperclass()) {
            Object scripatble = this.getParentScope().get(c.getSimpleName(), (Scriptable)this);
            if (!(scripatble instanceof Scriptable)) continue;
            objects.addAll(Arrays.asList(((Scriptable)scripatble).getIds()));
        }
        return objects.toArray(new Object[0]);
    }

    public BrowserVersion getBrowserVersion() {
        Scriptable parent = this.getParentScope();
        while (!(parent instanceof Window)) {
            parent = parent.getParentScope();
        }
        return ((Window)parent).getBrowserVersion();
    }

    public String getFunctionName() {
        String functionName;
        switch (functionName = super.getFunctionName()) {
            case "V8BreakIterator": {
                return "v8BreakIterator";
            }
            case "webkitRTCPeerConnection": {
                return "RTCPeerConnection";
            }
            case "webkitSpeechRecognition": {
                return "SpeechRecognition";
            }
            case "WebKitMutationObserver": {
                return "MutationObserver";
            }
            case "webkitMediaStream": {
                return "MediaStream";
            }
            case "webkitSpeechGrammar": {
                return "SpeechGrammar";
            }
            case "webkitSpeechGrammarList": {
                return "SpeechGrammarList";
            }
            case "webkitSpeechRecognitionError": {
                return "SpeechRecognitionErrorEvent";
            }
            case "webkitSpeechRecognitionEvent": {
                return "SpeechRecognitionEvent";
            }
            case "webkitURL": {
                return "URL";
            }
        }
        return functionName;
    }

    public Object get(String name, Scriptable start) {
        String superFunctionName = super.getFunctionName();
        if ("prototype".equals(name) && "Proxy".equals(superFunctionName)) {
            return NOT_FOUND;
        }
        Object value = super.get(name, start);
        if (!(value != NOT_FOUND || "Image".equals(superFunctionName) || "Option".equals(superFunctionName) || "WebGLContextEvent".equals(superFunctionName) && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WEBGL_CONTEXT_EVENT_CONSTANTS))) {
            Class<?> klass = this.getPrototypeProperty().getClass();
            BrowserVersion browserVersion = this.getBrowserVersion();
            while (value == NOT_FOUND && HtmlUnitScriptable.class.isAssignableFrom(klass)) {
                List<ClassConfiguration.ConstantInfo> constants;
                ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass.asSubclass(HtmlUnitScriptable.class), browserVersion);
                if (config != null && (constants = config.getConstants()) != null) {
                    for (ClassConfiguration.ConstantInfo constantInfo : constants) {
                        if (!constantInfo.getName().equals(name)) continue;
                        value = ScriptableObject.getProperty((Scriptable)((Scriptable)this.getPrototypeProperty()), (String)name);
                        break;
                    }
                }
                klass = klass.getSuperclass();
            }
        }
        return value;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object object = super.call(cx, scope, thisObj, args);
        if (object instanceof Scriptable) {
            Scriptable parent;
            Scriptable proto;
            Scriptable result = (Scriptable)object;
            if (result.getPrototype() == null && result != (proto = this.getClassPrototype())) {
                result.setPrototype(proto);
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
        }
        return object;
    }
}

