/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSImportRuleImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.css.CssMediaList;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.MediaList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class CSSImportRule
extends CSSRule {
    private MediaList media_;
    private CSSStyleSheet importedStylesheet_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public CSSImportRule() {
    }

    protected CSSImportRule(CSSStyleSheet stylesheet, CSSImportRuleImpl rule) {
        super(stylesheet, (AbstractCSSRuleImpl)rule);
    }

    @JsxGetter
    public String getHref() {
        return this.getImportRule().getHref();
    }

    @JsxGetter
    public MediaList getMedia() {
        if (this.media_ == null) {
            CSSStyleSheet parent = this.getParentStyleSheet();
            MediaListImpl ml = this.getImportRule().getMedia();
            this.media_ = new MediaList(parent, new CssMediaList(ml));
        }
        return this.media_;
    }

    @JsxGetter
    public CSSStyleSheet getStyleSheet() {
        if (this.importedStylesheet_ == null) {
            CSSStyleSheet owningSheet = this.getParentStyleSheet();
            HTMLElement ownerNode = owningSheet.getOwnerNode();
            CSSStyleSheet importedSheet = owningSheet.getImportedStyleSheet(this.getImportRule());
            this.importedStylesheet_ = new CSSStyleSheet(null, (Scriptable)ownerNode.getWindow(), importedSheet.getCssStyleSheet());
        }
        return this.importedStylesheet_;
    }

    private CSSImportRuleImpl getImportRule() {
        return (CSSImportRuleImpl)this.getRule();
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_CSSTEXT_IE_STYLE)) {
            cssText = REPLACEMENT_IE.matcher(cssText).replaceFirst("url( $1 )");
        }
        return cssText;
    }
}

