/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Locale;

@JsxClass(domClass=HtmlSpan.class)
public class HTMLSpanElement
extends HTMLElement {
    private boolean endTagForbidden_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLSpanElement() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        BrowserVersion browser = this.getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.HTMLBASEFONT_END_TAG_FORBIDDEN)) {
            switch (domNode.getLocalName().toLowerCase(Locale.ROOT)) {
                case "basefont": 
                case "keygen": {
                    this.endTagForbidden_ = true;
                    break;
                }
            }
        }
    }

    public String getCite() {
        return this.getDomNodeOrDie().getAttributeDirect("cite");
    }

    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    public String getDateTime() {
        return this.getDomNodeOrDie().getAttributeDirect("datetime");
    }

    public void setDateTime(String dateTime) {
        this.getDomNodeOrDie().setAttribute("datetime", dateTime);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }
}

