/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlMedia
extends HtmlElement {
    HtmlMedia(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public String canPlayType(String type) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{type})) {
            return "";
        }
        int semPos = type.indexOf(59);
        int codecPos = type.indexOf("codec");
        if (semPos > 0 && codecPos > semPos) {
            return "probably";
        }
        return "maybe";
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttribute();
        if ("".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)this.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of media " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    public String getCurrentSrc() {
        return "";
    }
}

