/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class History
extends HtmlUnitScriptable {
    private static final String SCROLL_RESTAURATION_AUTO = "auto";
    private static final String SCROLL_RESTAURATION_MANUAL = "manual";
    private String scrollRestoration_ = "auto";

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public History() {
    }

    @JsxGetter
    public int getLength() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getLength();
    }

    @JsxGetter
    public Object getState() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getCurrentState();
    }

    @JsxFunction
    public void back() {
        try {
            this.getWindow().getWebWindow().getHistory().back();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void forward() {
        try {
            this.getWindow().getWebWindow().getHistory().forward();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void go(int relativeIndex) {
        try {
            this.getWindow().getWebWindow().getHistory().go(relativeIndex);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void replaceState(Object object, String title, Object url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().replaceState(object, History.buildNewStateUrl(w, url));
        }
        catch (MalformedURLException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void pushState(Object object, String title, Object url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().pushState(object, History.buildNewStateUrl(w, url));
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private static URL buildNewStateUrl(WebWindow webWindow, Object url) throws MalformedURLException {
        String urlString;
        URL newStateUrl = null;
        if (url != null && !Undefined.isUndefined((Object)url) && StringUtils.isNotBlank((CharSequence)(urlString = ScriptRuntime.toString((Object)url)))) {
            HtmlPage page = (HtmlPage)webWindow.getEnclosedPage();
            newStateUrl = page.getFullyQualifiedUrl(urlString);
        }
        return newStateUrl;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getScrollRestoration() {
        return this.scrollRestoration_;
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setScrollRestoration(String scrollRestoration) {
        if (SCROLL_RESTAURATION_AUTO.equals(scrollRestoration)) {
            this.scrollRestoration_ = SCROLL_RESTAURATION_AUTO;
            return;
        }
        if (SCROLL_RESTAURATION_MANUAL.equals(scrollRestoration)) {
            this.scrollRestoration_ = SCROLL_RESTAURATION_MANUAL;
        }
    }
}

