/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.HashChangeEvent;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Location
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(Location.class);
    private static final String UNKNOWN = "null";
    private Window window_;
    private static final Method methodAssign;
    private static final Method methodReload;
    private static final Method methodReplace;
    private static final Method methodToString;
    private static final Method getterHash;
    private static final Method setterHash;
    private static final Method getterHost;
    private static final Method setterHost;
    private static final Method getterHostname;
    private static final Method setterHostname;
    private static final Method getterHref;
    private static final Method setterHref;
    private static final Method getterOrigin;
    private static final Method getterPathname;
    private static final Method setterPathname;
    private static final Method getterPort;
    private static final Method setterPort;
    private static final Method getterProtocol;
    private static final Method setterProtocol;
    private static final Method getterSearch;
    private static final Method setterSearch;
    private String hash_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        int attributes = 5;
        FunctionObject functionObject = new FunctionObject(methodAssign.getName(), (Member)methodAssign, (Scriptable)this);
        this.defineProperty(methodAssign.getName(), functionObject, 5);
        functionObject = new FunctionObject(methodReload.getName(), (Member)methodReload, (Scriptable)this);
        this.defineProperty(methodReload.getName(), functionObject, 5);
        functionObject = new FunctionObject(methodReplace.getName(), (Member)methodReplace, (Scriptable)this);
        this.defineProperty(methodReplace.getName(), functionObject, 5);
        functionObject = new FunctionObject(methodToString.getName(), (Member)methodToString, (Scriptable)this);
        this.defineProperty("toString", functionObject, 5);
        this.defineProperty("hash", null, getterHash, setterHash, 5);
        this.defineProperty("host", null, getterHost, setterHost, 5);
        this.defineProperty("hostname", null, getterHostname, setterHostname, 5);
        this.defineProperty("href", null, getterHref, setterHref, 5);
        this.defineProperty("origin", null, getterOrigin, null, 5);
        this.defineProperty("pathname", null, getterPathname, setterPathname, 5);
        this.defineProperty("port", null, getterPort, setterPort, 5);
        this.defineProperty("protocol", null, getterProtocol, setterProtocol, 5);
        this.defineProperty("search", null, getterSearch, setterSearch, 5);
    }

    public void initialize(Window window, Page page) {
        this.window_ = window;
        if (this.window_ != null && page != null) {
            this.setHash(null, page.getUrl().getRef());
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && this.window_ != null && (hint == null || String.class.equals(hint))) {
            return this.getHref();
        }
        return super.getDefaultValue(hint);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void assign(String url) throws IOException {
        this.setHref(url);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void reload(boolean force) throws IOException {
        WebWindow webWindow = this.window_.getWebWindow();
        HtmlPage htmlPage = (HtmlPage)webWindow.getEnclosedPage();
        WebRequest request = htmlPage.getWebResponse().getWebRequest();
        if (webWindow.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_RELOAD_REFERRER)) {
            request.setRefererlHeader(htmlPage.getUrl());
        }
        webWindow.getWebClient().download(webWindow, "", request, true, false, false, "JS location.reload");
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void replace(String url) throws IOException {
        this.window_.getWebWindow().getHistory().removeCurrent();
        this.setHref(url);
    }

    @JsxFunction(functionName="toString", value={SupportedBrowser.IE})
    public String jsToString() {
        if (this.window_ != null) {
            return this.getHref();
        }
        return "";
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getHref() {
        WebWindow webWindow = this.window_.getWebWindow();
        Page page = webWindow.getEnclosedPage();
        if (page == null) {
            return UNKNOWN;
        }
        try {
            String s;
            URL url = page.getUrl();
            boolean encodeHash = webWindow.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LOCATION_HREF_HASH_IS_ENCODED);
            String hash = this.getHash(encodeHash);
            if (hash != null) {
                url = UrlUtils.getUrlWithNewRef(url, hash);
            }
            if ((s = url.toExternalForm()).startsWith("file:/") && !s.startsWith("file:///")) {
                s = "file:///" + s.substring("file:/".length());
            }
            return s;
        }
        catch (MalformedURLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return page.getUrl().toExternalForm();
        }
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setHref(String newLocation) throws IOException {
        WebWindow webWindow = Location.getWindow(this.getStartingScope()).getWebWindow();
        HtmlPage page = (HtmlPage)webWindow.getEnclosedPage();
        if (newLocation.startsWith("javascript:")) {
            String script = newLocation.substring(11);
            page.executeJavaScript(script, "new location value", 1);
            return;
        }
        try {
            BrowserVersion browserVersion = webWindow.getWebClient().getBrowserVersion();
            URL url = page.getFullyQualifiedUrl(newLocation);
            if (StringUtils.isEmpty((CharSequence)newLocation)) {
                boolean dropFilename = browserVersion.hasFeature(BrowserVersionFeatures.ANCHOR_EMPTY_HREF_NO_FILENAME);
                if (dropFilename) {
                    String path = url.getPath();
                    path = path.substring(0, path.lastIndexOf(47) + 1);
                    url = UrlUtils.getUrlWithNewPath(url, path);
                }
                url = UrlUtils.getUrlWithNewRef(url, null);
            }
            WebRequest request = new WebRequest(url, browserVersion.getHtmlAcceptHeader(), browserVersion.getAcceptEncodingHeader());
            request.setRefererlHeader(page.getUrl());
            webWindow = this.window_.getWebWindow();
            webWindow.getWebClient().download(webWindow, "", request, true, false, false, "JS set location");
        }
        catch (MalformedURLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("setHref('" + newLocation + "') got MalformedURLException"), (Throwable)e);
            }
            throw e;
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getSearch() {
        String search = this.getUrl().getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setSearch(String search) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), search));
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getHash() {
        BrowserVersion browserVersion = this.getBrowserVersion();
        boolean decodeHash = browserVersion.hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_IS_DECODED);
        String hash = this.hash_;
        if (this.hash_ != null && (decodeHash || this.hash_.equals(this.getUrl().getRef()))) {
            hash = Location.decodeHash(hash);
        }
        if (StringUtils.isEmpty((CharSequence)hash)) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_RETURNS_HASH_FOR_EMPTY_DEFINED) && this.getHref().endsWith("#")) {
                return "#";
            }
        } else {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_LOCATION_HASH_HASH_IS_ENCODED)) {
                return "#" + UrlUtils.encodeHash(hash);
            }
            return "#" + hash;
        }
        return "";
    }

    private String getHash(boolean encoded) {
        if (this.hash_ == null || this.hash_.isEmpty()) {
            return null;
        }
        if (encoded) {
            return UrlUtils.encodeHash(this.hash_);
        }
        return this.hash_;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setHash(String hash) {
        this.setHash(this.getHref(), hash, true);
    }

    public void setHash(String oldURL, String hash) {
        this.setHash(oldURL, hash, true);
    }

    public void setHash(String oldURL, String hash, boolean triggerHashChanged) {
        if (hash != null && !hash.isEmpty() && hash.charAt(0) == '#') {
            hash = hash.substring(1);
        }
        boolean hasChanged = hash != null && !hash.equals(this.hash_);
        this.hash_ = hash;
        if (triggerHashChanged && hasChanged) {
            Event event;
            Window w = this.getWindow();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_TYPE_HASHCHANGEEVENT)) {
                event = new HashChangeEvent(w, "hashchange", oldURL, this.getHref());
            } else {
                event = new Event(w, "hashchange");
                event.initEvent("hashchange", false, false);
            }
            w.executeEventLocally(event);
        }
    }

    private static String decodeHash(String hash) {
        if (hash.indexOf(37) == -1) {
            return hash;
        }
        return UrlUtils.decode(hash);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getHostname() {
        return this.getUrl().getHost();
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setHostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getHost() {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index == -1) {
            hostname = host;
            port = -1;
        } else {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getPathname() {
        if (UrlUtils.URL_ABOUT_BLANK == this.getUrl()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_ABOUT_BLANK_HAS_BLANK_PATH)) {
                return "blank";
            }
            return "/blank";
        }
        return this.getUrl().getPath();
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getPort() {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return Integer.toString(port);
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getProtocol() {
        return this.getUrl().getProtocol() + ":";
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setProtocol(String protocol) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), protocol));
    }

    private URL getUrl() {
        return this.window_.getWebWindow().getEnclosedPage().getUrl();
    }

    private void setUrl(URL url) throws IOException {
        WebWindow webWindow = this.window_.getWebWindow();
        BrowserVersion browserVersion = webWindow.getWebClient().getBrowserVersion();
        WebRequest webRequest = new WebRequest(url, browserVersion.getHtmlAcceptHeader(), browserVersion.getAcceptEncodingHeader());
        webRequest.setRefererlHeader(this.getUrl());
        webWindow.getWebClient().getPage(webWindow, webRequest);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getOrigin() {
        return this.getUrl().getProtocol() + "://" + this.getHost();
    }

    static {
        try {
            methodAssign = Location.class.getDeclaredMethod("assign", String.class);
            methodReload = Location.class.getDeclaredMethod("reload", Boolean.TYPE);
            methodReplace = Location.class.getDeclaredMethod("replace", String.class);
            methodToString = Location.class.getDeclaredMethod("jsToString", new Class[0]);
            getterHash = Location.class.getDeclaredMethod("getHash", new Class[0]);
            setterHash = Location.class.getDeclaredMethod("setHash", String.class);
            getterHost = Location.class.getDeclaredMethod("getHost", new Class[0]);
            setterHost = Location.class.getDeclaredMethod("setHost", String.class);
            getterHostname = Location.class.getDeclaredMethod("getHostname", new Class[0]);
            setterHostname = Location.class.getDeclaredMethod("setHostname", String.class);
            getterHref = Location.class.getDeclaredMethod("getHref", new Class[0]);
            setterHref = Location.class.getDeclaredMethod("setHref", String.class);
            getterOrigin = Location.class.getDeclaredMethod("getOrigin", new Class[0]);
            getterPathname = Location.class.getDeclaredMethod("getPathname", new Class[0]);
            setterPathname = Location.class.getDeclaredMethod("setPathname", String.class);
            getterPort = Location.class.getDeclaredMethod("getPort", new Class[0]);
            setterPort = Location.class.getDeclaredMethod("setPort", String.class);
            getterProtocol = Location.class.getDeclaredMethod("getProtocol", new Class[0]);
            setterProtocol = Location.class.getDeclaredMethod("setProtocol", String.class);
            getterSearch = Location.class.getDeclaredMethod("getSearch", new Class[0]);
            setterSearch = Location.class.getDeclaredMethod("setSearch", String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

