/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.MimeType;
import com.gargoylesoftware.htmlunit.javascript.host.MimeTypeArray;
import com.gargoylesoftware.htmlunit.javascript.host.Plugin;
import com.gargoylesoftware.htmlunit.javascript.host.PluginArray;
import com.gargoylesoftware.htmlunit.javascript.host.geo.Geolocation;
import com.gargoylesoftware.htmlunit.javascript.host.media.MediaDevices;
import com.gargoylesoftware.htmlunit.javascript.host.network.NetworkInformation;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class Navigator
extends HtmlUnitScriptable {
    private PluginArray plugins_;
    private MimeTypeArray mimeTypes_;
    private MediaDevices mediaDevices_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Navigator() {
    }

    @JsxGetter
    public String getAppCodeName() {
        return this.getBrowserVersion().getApplicationCodeName();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getAppMinorVersion() {
        return this.getBrowserVersion().getApplicationMinorVersion();
    }

    @JsxGetter
    public String getAppName() {
        return this.getBrowserVersion().getApplicationName();
    }

    @JsxGetter
    public String getAppVersion() {
        return this.getBrowserVersion().getApplicationVersion();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBrowserLanguage() {
        return this.getLanguage();
    }

    @JsxGetter
    public String getLanguage() {
        return this.getBrowserVersion().getBrowserLanguage();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Scriptable getLanguages() {
        String[] parts;
        String acceptLang = this.getBrowserVersion().getAcceptLanguageHeader();
        if (StringUtils.isEmpty((CharSequence)acceptLang)) {
            return Context.getCurrentContext().newArray((Scriptable)this, 0);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String part : parts = StringUtils.split((String)acceptLang, (String)",")) {
            if (StringUtils.isEmpty((CharSequence)part)) continue;
            String lang = StringUtils.substringBefore((String)part, (String)";").trim();
            if (StringUtils.isEmpty((CharSequence)part)) continue;
            res.add(lang);
        }
        return Context.getCurrentContext().newArray((Scriptable)this, res.toArray());
    }

    @JsxGetter
    public boolean isCookieEnabled() {
        return this.getWindow().getWebWindow().getWebClient().getCookieManager().isCookiesEnabled();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getCpuClass() {
        return this.getBrowserVersion().getCpuClass();
    }

    @JsxGetter
    public boolean isOnLine() {
        return this.getBrowserVersion().isOnLine();
    }

    @JsxGetter
    public String getPlatform() {
        return this.getBrowserVersion().getPlatform();
    }

    @JsxGetter
    public String getProduct() {
        return "Gecko";
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getProductSub() {
        return this.getBrowserVersion().getProductSub();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getSystemLanguage() {
        return this.getBrowserVersion().getSystemLanguage();
    }

    @JsxGetter
    public String getUserAgent() {
        return this.getBrowserVersion().getUserAgent();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getUserLanguage() {
        return this.getBrowserVersion().getUserLanguage();
    }

    @JsxGetter
    public Object getPlugins() {
        this.initPlugins();
        return this.plugins_;
    }

    private void initPlugins() {
        if (this.plugins_ != null) {
            return;
        }
        this.plugins_ = new PluginArray();
        this.plugins_.setParentScope((Scriptable)this);
        this.plugins_.setPrototype(this.getPrototype(PluginArray.class));
        this.mimeTypes_ = new MimeTypeArray();
        this.mimeTypes_.setParentScope((Scriptable)this);
        this.mimeTypes_.setPrototype(this.getPrototype(MimeTypeArray.class));
        for (PluginConfiguration pluginConfig : this.getBrowserVersion().getPlugins()) {
            Plugin plugin = new Plugin(pluginConfig.getName(), pluginConfig.getDescription(), pluginConfig.getVersion(), pluginConfig.getFilename());
            plugin.setParentScope((Scriptable)this);
            plugin.setPrototype(this.getPrototype(Plugin.class));
            this.plugins_.add(plugin);
            for (PluginConfiguration.MimeType mimeTypeConfig : pluginConfig.getMimeTypes()) {
                MimeType mimeType = new MimeType(mimeTypeConfig.getType(), mimeTypeConfig.getDescription(), mimeTypeConfig.getSuffixes(), plugin);
                mimeType.setParentScope((Scriptable)this);
                mimeType.setPrototype(this.getPrototype(MimeType.class));
                this.mimeTypes_.add(mimeType);
                plugin.add(mimeType);
            }
        }
    }

    @JsxGetter
    public Object getMimeTypes() {
        this.initPlugins();
        return this.mimeTypes_;
    }

    @JsxFunction
    public boolean javaEnabled() {
        return this.getWindow().getWebWindow().getWebClient().getOptions().isAppletEnabled();
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR, SupportedBrowser.IE})
    public boolean taintEnabled() {
        return false;
    }

    @JsxGetter
    public Geolocation getGeolocation() {
        Geolocation geolocation = new Geolocation();
        geolocation.setPrototype(this.getPrototype(geolocation.getClass()));
        geolocation.setParentScope(this.getParentScope());
        return geolocation;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getBuildID() {
        return this.getBrowserVersion().getBuildId();
    }

    @JsxGetter
    public String getVendor() {
        return this.getBrowserVersion().getVendor();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getVendorSub() {
        return "";
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getDoNotTrack() {
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        if (client.getOptions().isDoNotTrackEnabled()) {
            return 1;
        }
        if (client.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NAVIGATOR_DO_NOT_TRACK_UNSPECIFIED)) {
            return "unspecified";
        }
        return null;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public String getOscpu() {
        return "Windows NT 6.1";
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public NetworkInformation getConnection() {
        NetworkInformation networkInformation = new NetworkInformation();
        networkInformation.setPrototype(this.getPrototype(networkInformation.getClass()));
        networkInformation.setParentScope(this.getParentScope());
        return networkInformation;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public MediaDevices getMediaDevices() {
        if (this.mediaDevices_ == null) {
            this.mediaDevices_ = new MediaDevices();
            this.mediaDevices_.setPrototype(this.getPrototype(this.mediaDevices_.getClass()));
            this.mediaDevices_.setParentScope(this.getParentScope());
        }
        return this.mediaDevices_;
    }
}

