/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSCharsetRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.condition.NotPseudoClassCondition;
import com.gargoylesoftware.css.parser.selector.ChildSelector;
import com.gargoylesoftware.css.parser.selector.DescendantSelector;
import com.gargoylesoftware.css.parser.selector.DirectAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.GeneralAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.css.CssStyleSheet;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;

@JsxClass
public class CSSStyleSheet
extends StyleSheet {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private static final Pattern NTH_NUMERIC = Pattern.compile("\\d+");
    private static final Pattern NTH_COMPLEX = Pattern.compile("[+-]?\\d*n\\w*([+-]\\w\\d*)?");
    private final CssStyleSheet styleSheet_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public CSSStyleSheet() {
        this.styleSheet_ = new CssStyleSheet(null, (InputSource)null, null);
        this.ownerNode_ = null;
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        this.setParentScope((Scriptable)element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, String styleSheet, String uri) {
        Window win = element.getWindow();
        CssStyleSheet css = null;
        try (InputSource source = new InputSource((Reader)new StringReader(styleSheet));){
            css = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setParentScope((Scriptable)win);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = css;
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, Scriptable parentScope, CssStyleSheet cssStyleSheet) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = cssStyleSheet;
        this.ownerNode_ = element;
    }

    public CssStyleSheet getCssStyleSheet() {
        return this.styleSheet_;
    }

    @JsxGetter
    public HTMLElement getOwnerNode() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLElement getOwningElement() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public CSSRuleList getRules() {
        return this.getCssRules();
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @JsxGetter
    public String getHref() {
        if (this.ownerNode_ != null) {
            HtmlElement node = this.ownerNode_.getDomNodeOrDie();
            if (node instanceof HtmlStyle) {
                return null;
            }
            if (node instanceof HtmlLink) {
                HtmlLink link = (HtmlLink)node;
                String href = link.getHrefAttribute();
                if ("".equals(href) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EMPTY_IS_NULL)) {
                    return null;
                }
                try {
                    HtmlPage page = (HtmlPage)link.getPage();
                    URL url = page.getFullyQualifiedUrl(href);
                    return url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.getUri();
    }

    @JsxFunction
    public int insertRule(String rule, int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(rule, this.fixIndex(position));
            this.refreshCssRules();
            return position;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos > -1) {
                String newRule = rule.substring(0, pos) + "{}";
                try {
                    this.getCssStyleSheet().getWrappedSheet().insertRule(newRule, this.fixIndex(position));
                    this.refreshCssRules();
                    return position;
                }
                catch (DOMException ex) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)ex);
                }
            }
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = this.getCssStyleSheet().getWrappedSheet().getCssRules();
        List rules = ruleList.getRules();
        int pos = 0;
        for (AbstractCSSRuleImpl rule : rules) {
            if (rule instanceof CSSCharsetRuleImpl) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this, rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
        this.getCssStyleSheet().getWrappedSheet().resetRuleIndex();
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public int addRule(String selector, String rule) {
        String completeRule = selector + " {" + rule + "}";
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
            this.refreshCssRules();
        }
        catch (DOMException e) {
            completeRule = selector + " {}";
            try {
                this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
                this.refreshCssRules();
            }
            catch (DOMException ex) {
                throw Context.throwAsScriptRuntimeEx((Throwable)ex);
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_ADD_RULE_RETURNS_POS)) {
            return this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength() - 1;
        }
        return -1;
    }

    @JsxFunction
    public void removeRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    public String getUri() {
        return this.getCssStyleSheet().getUri();
    }

    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        for (Selector selector : selectorList) {
            if (CSSStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
            throw new CSSException("Invalid selector: " + selector);
        }
    }

    private static boolean isValidSelector(Selector selector, int documentMode, DomNode domNode) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                List conditions = ((ElementSelector)selector).getConditions();
                if (conditions != null) {
                    for (Condition condition : conditions) {
                        if (CSSStyleSheet.isValidCondition(condition, documentMode, domNode)) continue;
                        return false;
                    }
                }
                return true;
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                return CSSStyleSheet.isValidSelector(ds.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)ds.getSimpleSelector(), documentMode, domNode);
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                return CSSStyleSheet.isValidSelector(cs.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)cs.getSimpleSelector(), documentMode, domNode);
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(das.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)das.getSimpleSelector(), documentMode, domNode);
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(gas.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector((Selector)gas.getSimpleSelector(), documentMode, domNode);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS selector type '" + selector.getSelectorType() + "'. Accepting it silently."));
        }
        return true;
    }

    private static boolean isValidCondition(Condition condition, int documentMode, DomNode domNode) {
        switch (condition.getConditionType()) {
            case ATTRIBUTE_CONDITION: 
            case ID_CONDITION: 
            case LANG_CONDITION: 
            case ONE_OF_ATTRIBUTE_CONDITION: 
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: 
            case CLASS_CONDITION: 
            case PREFIX_ATTRIBUTE_CONDITION: 
            case SUBSTRING_ATTRIBUTE_CONDITION: 
            case SUFFIX_ATTRIBUTE_CONDITION: {
                return true;
            }
            case NOT_PSEUDO_CLASS_CONDITION: {
                NotPseudoClassCondition notPseudoCondition = (NotPseudoClassCondition)condition;
                SelectorList selectorList = notPseudoCondition.getSelectors();
                for (Selector selector : selectorList) {
                    if (CSSStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
                    return false;
                }
                return true;
            }
            case PSEUDO_CLASS_CONDITION: {
                String value = condition.getValue();
                if (value.endsWith(")")) {
                    if (value.endsWith("()")) {
                        return false;
                    }
                    value = value.substring(0, value.indexOf(40) + 1) + ')';
                }
                if (documentMode < 9) {
                    return CssStyleSheet.CSS2_PSEUDO_CLASSES.contains(value);
                }
                if (!CssStyleSheet.CSS2_PSEUDO_CLASSES.contains(value) && domNode.hasFeature(BrowserVersionFeatures.QUERYSELECTOR_CSS3_PSEUDO_REQUIRE_ATTACHED_NODE) && !domNode.isAttachedToPage() && !domNode.hasChildNodes()) {
                    throw new CSSException("Syntax Error");
                }
                if ("nth-child()".equals(value)) {
                    String arg = StringUtils.substringBetween((String)condition.getValue(), (String)"(", (String)")").trim();
                    return "even".equalsIgnoreCase(arg) || "odd".equalsIgnoreCase(arg) || NTH_NUMERIC.matcher(arg).matches() || NTH_COMPLEX.matcher(arg).matches();
                }
                if ("placeholder-shown".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_PLACEHOLDER_SHOWN);
                }
                if ("-ms-input-placeholder".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_MS_PLACEHHOLDER);
                }
                return CssStyleSheet.CSS4_PSEUDO_CLASSES.contains(value);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS condition type '" + condition.getConditionType() + "'. Accepting it silently."));
        }
        return true;
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }
}

