/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ImplementationVersion {
    private String versionString;
    private static final ImplementationVersion version = new ImplementationVersion();

    public static String get() {
        return ImplementationVersion.version.versionString;
    }

    private ImplementationVersion() {
        Enumeration<URL> urls;
        try {
            urls = ImplementationVersion.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException ioe) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL metaUrl = urls.nextElement();
            try {
                InputStream is = metaUrl.openStream();
                Throwable throwable = null;
                try {
                    Manifest mf = new Manifest(is);
                    Attributes attrs = mf.getMainAttributes();
                    if (!"Mozilla Rhino".equals(attrs.getValue("Implementation-Title"))) continue;
                    this.versionString = "Rhino " + attrs.getValue("Implementation-Version") + " " + attrs.getValue("Built-Date").replaceAll("-", " ");
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

