/* CSS3Parser.java */
/* Generated By:JavaCC: Do not edit this line. CSS3Parser.java */
package com.gargoylesoftware.css.parser.javacc;

import java.util.LinkedList;
import java.util.Locale;

import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.dom.Property;
import com.gargoylesoftware.css.parser.AbstractCSSParser;
import com.gargoylesoftware.css.parser.CSSParseException;
import com.gargoylesoftware.css.parser.LexicalUnit;
import com.gargoylesoftware.css.parser.LexicalUnitImpl;
import com.gargoylesoftware.css.parser.LexicalUnit.LexicalUnitType;
import com.gargoylesoftware.css.parser.Locatable;
import com.gargoylesoftware.css.parser.Locator;
import com.gargoylesoftware.css.parser.ParserUtils;
import com.gargoylesoftware.css.parser.condition.AttributeCondition;
import com.gargoylesoftware.css.parser.condition.BeginHyphenAttributeCondition;
import com.gargoylesoftware.css.parser.condition.ClassCondition;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.condition.IdCondition;
import com.gargoylesoftware.css.parser.condition.LangCondition;
import com.gargoylesoftware.css.parser.condition.OneOfAttributeCondition;
import com.gargoylesoftware.css.parser.condition.PrefixAttributeCondition;
import com.gargoylesoftware.css.parser.condition.PseudoClassCondition;
import com.gargoylesoftware.css.parser.condition.SubstringAttributeCondition;
import com.gargoylesoftware.css.parser.condition.SuffixAttributeCondition;
import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.css.parser.media.MediaQueryList;
import com.gargoylesoftware.css.parser.selector.ChildSelector;
import com.gargoylesoftware.css.parser.selector.DescendantSelector;
import com.gargoylesoftware.css.parser.selector.DirectAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.GeneralAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.PseudoElementSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.css.parser.selector.SelectorListImpl;
import com.gargoylesoftware.css.parser.selector.SimpleSelector;
import com.gargoylesoftware.css.util.LangUtils;

/**
 * @author David Schweinsberg
 * @author waldbaer
 * @author Ahmed Ashour
 * @author Ronald Brill
 */
@SuppressWarnings("all") public class CSS3Parser extends AbstractCSSParser implements CSS3ParserConstants {

    public CSS3Parser() {
        this((CharStream) null);
    }

    public String getParserVersion() {
        return "http://www.w3.org/Style/CSS/";
    }

    protected String getGrammarUri()
    {
        return "http://www.w3.org/TR/WD-css3-syntax-20030813";
    }

//
// stylesheet
//  : [ CHARSET_SYM STRING ';' ]?
//    [S|CDO|CDC]* [ import [S|CDO|CDC]* ]*
//    [ [ ruleset | media | page | font_face ] [S|CDO|CDC]* ]*
//  ;
//
  final public void styleSheet() throws ParseException {
    try {
handleStartDocument();
      styleSheetRuleList();
      jj_consume_token(0);
    } finally {
handleEndDocument();
    }
}

  final public void styleSheetRuleList() throws ParseException {boolean ruleFound = false;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:
      case CDO:
      case CDC:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        jj_consume_token(S);
        break;
        }
      case CDO:{
        jj_consume_token(CDO);
        break;
        }
      case CDC:{
        jj_consume_token(CDC);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CHARSET_SYM:{
      charsetRule();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT_SYM:{
          importRule(ruleFound);
          break;
          }
        case IDENT:
        case DOT:
        case COLON:
        case ASTERISK:
        case LSQUARE:
        case HASH:
        case PAGE_SYM:
        case MEDIA_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IDENT:
          case DOT:
          case COLON:
          case ASTERISK:
          case LSQUARE:
          case HASH:{
            styleRule();
            break;
            }
          case MEDIA_SYM:{
            mediaRule();
            break;
            }
          case PAGE_SYM:{
            pageRule();
            break;
            }
          case FONT_FACE_SYM:{
            fontFaceRule();
            break;
            }
          case ATKEYWORD:{
            unknownAtRule();
            break;
            }
          default:
            jj_la1[5] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ruleFound = true;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[7] = jj_gen;
ParseException e = generateParseException();
        invalidRule();
Token t = getNextToken();

                boolean charsetProcessed = false;
                if (t.kind == CHARSET_SYM) {
                    t = getNextToken();
                    if (t.kind == S) {
                        t = getNextToken();
                        if (t.kind == STRING) {
                            t = getNextToken();
                            if (t.kind == SEMICOLON) {
                                getNextToken();
                                charsetProcessed = true;
                            }
                        }
                    }
                    CSSParseException cpe = toCSSParseException("misplacedCharsetRule", e);
                    getErrorHandler().error(cpe);
                    getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
                }

                if (!charsetProcessed) {
                    if (t.kind == EOF) {
                        {if ("" != null) return;}
                    }

                    CSSParseException cpe = toCSSParseException("invalidRule", e);
                    getErrorHandler().error(cpe);
                    getErrorHandler().warning(createSkipWarning("ignoringRule", cpe));
                    while (t.kind != RBRACE && t.kind != EOF ) {
                        t = getNextToken();
                    }
                    if (t.kind == EOF) {
                        {if ("" != null) return;}
                    }
                }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:{
          ;
          break;
          }
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:{
          jj_consume_token(CDO);
          break;
          }
        case CDC:{
          jj_consume_token(CDC);
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

  void invalidRule() throws ParseException {
  }

//
// This is used by ASTStyleSheet.insertRule to parse a single rule
//
  final public void styleSheetRuleSingle() throws ParseException {
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CHARSET_SYM:{
      charsetRule();
      break;
      }
    case IMPORT_SYM:{
      importRule(false);
      break;
      }
    case IDENT:
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:{
      styleRule();
      break;
      }
    case MEDIA_SYM:{
      mediaRule();
      break;
      }
    case PAGE_SYM:{
      pageRule();
      break;
      }
    case FONT_FACE_SYM:{
      fontFaceRule();
      break;
      }
    case ATKEYWORD:{
      unknownAtRule();
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      jj_consume_token(S);
    }
}

  final public void charsetRule() throws ParseException {Token t;
  Locator locator;
    try {
      jj_consume_token(CHARSET_SYM);
locator = createLocator(token);
      jj_consume_token(S);
      t = jj_consume_token(STRING);
      jj_consume_token(SEMICOLON);
handleCharset(t.toString(), locator);
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidCharsetRule", e));
    }
}

  final public void unknownAtRule() throws ParseException {String s;
    Locator locator;
    try {
      jj_consume_token(ATKEYWORD);
locator = createLocator(token);
            s = skip();
            handleIgnorableAtRule(s, locator);
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidUnknownRule", generateParseException()));
    }
}

//
// import
//  : IMPORT_SYM S*
//    [STRING|URI] S* [ medium [ COMMA S* medium]* ]? ';' S*
//  ;
//
  final public void importRule(final boolean nonImportRuleFoundBefore) throws ParseException {Token t;
    MediaQueryList ml = new MediaQueryList();
    Locator locator;
    try {
ParseException e = null;
            if (nonImportRuleFoundBefore)
            {
                e = generateParseException();
            }
      jj_consume_token(IMPORT_SYM);
locator = createLocator(token);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        t = jj_consume_token(STRING);
        break;
        }
      case URI:{
        t = jj_consume_token(URI);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case ONLY:
      case IDENT:
      case LROUND:{
        mediaList(ml);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
if (nonImportRuleFoundBefore)
            {
                getErrorHandler().error(toCSSParseException("invalidImportRuleIgnored2", e));
            }
            else
            {
                handleImportStyle(unescape(t.image, false), ml, null, locator);
            }
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipAtRule();
    } catch (ParseException e) {
getErrorHandler().error(toCSSParseException("invalidImportRule", e));
        error_skipAtRule();
    }
}

//
// media
//  : MEDIA_SYM S* medium [ COMMA S* medium ]* '{' S* ruleset* '}' S*
//  ;
//
  final public void mediaRule() throws ParseException {boolean start = false;
    MediaQueryList ml = new MediaQueryList();
    Locator locator;
    try {
      jj_consume_token(MEDIA_SYM);
locator = createLocator(token);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
      mediaList(ml);
start = true;
            handleStartMedia(ml, locator);
      jj_consume_token(LBRACE);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case ATKEYWORD:{
        mediaRuleList();
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidMediaRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringRule", cpe);
    } finally {
if (start) {
            handleEndMedia(ml);
        }
    }
}

  final public void mediaList(MediaQueryList ml) throws ParseException {MediaQuery mq;
    try {
      mq = mediaQuery();
ml.setLocator(createLocator(token));
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[21] = jj_gen;
            break label_12;
          }
          jj_consume_token(S);
        }
ml.add(mq);
        mq = mediaQuery();
      }
ml.add(mq);
    } catch (ParseException e) {
throw toCSSParseException("invalidMediaList", e);
    }
}

//
// media_query
//   : [ONLY | NOT]? S* media_type S* [ AND S* expression ]*
//   | expression [ AND S* expression ]*
//   ;
//
  final public MediaQuery mediaQuery() throws ParseException {String s;
    MediaQuery mq;
    Property p;
    boolean only = false;
    boolean not = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case ONLY:
    case IDENT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case ONLY:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ONLY:{
          jj_consume_token(ONLY);
only = true;
          break;
          }
        case NOT:{
          jj_consume_token(NOT);
not = true;
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            break label_13;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      s = medium();
mq = new MediaQuery(s, only, not); mq.setLocator(createLocator(token));
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_14;
        }
        jj_consume_token(AND);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[26] = jj_gen;
            break label_15;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
mq.addMediaProperty(p);
      }
      break;
      }
    case LROUND:{
      p = mediaExpression();
s = "all";
          handleMedium(s, null);
          mq = new MediaQuery(s, only, not);
          mq.setLocator(createLocator(token));
          mq.addMediaProperty(p);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AND:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_16;
        }
        jj_consume_token(AND);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[28] = jj_gen;
            break label_17;
          }
          jj_consume_token(S);
        }
        p = mediaExpression();
mq.addMediaProperty(p);
      }
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return mq;
}

//
// expression
//   : '(' S* media_feature S* [ ':' S* expr ]? ')' S*
//   ;
//
  final public Property mediaExpression() throws ParseException {String p;
  LexicalUnit e = null;
  Property prop;
    jj_consume_token(LROUND);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_18;
      }
      jj_consume_token(S);
    }
    p = property();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      e = expr();
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_20;
      }
      jj_consume_token(S);
    }
if(e==null)
        {
          prop = new Property(p, null, false);
        }
        else
        {
          prop = new Property(p, new CSSValueImpl(e), false);
        }
        return prop;
}

  final public void mediaRuleList() throws ParseException {
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:{
        styleRule();
        break;
        }
      case MEDIA_SYM:{
        mediaRule();
        break;
        }
      case PAGE_SYM:{
        pageRule();
        break;
        }
      case IMPORT_SYM:{
        importRule(true);
        break;
        }
      case ATKEYWORD:{
        unknownAtRule();
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_22;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IMPORT_SYM:
      case PAGE_SYM:
      case MEDIA_SYM:
      case ATKEYWORD:{
        ;
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_21;
      }
    }
}

//
// medium
//   : IDENT S*
//   ;
//
  final public String medium() throws ParseException {Token t;
  String medium;
    t = jj_consume_token(IDENT);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_23;
      }
      jj_consume_token(S);
    }
medium = unescape(t.image, false);
        handleMedium(medium, createLocator(t));
        return medium;
}

//
// page
//  : PAGE_SYM S* pseudo_page? S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void pageRule() throws ParseException {String sel = null;
    boolean start = false;
    Locator locator;
    try {
      jj_consume_token(PAGE_SYM);
locator = createLocator(token);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case COLON:{
        sel = pageSelectorList();
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
start = true;
            handleStartPage(null, sel, locator);
      styleDeclaration();
      jj_consume_token(RBRACE);
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidPageRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringRule", cpe);
    } finally {
if (start) {
            handleEndPage(null, sel);
        }
    }
}

//
// pageSelectorList
//   : [ pageSelector S* [ ',' pageSelector S* ]* ]?
//   ;
//
  final public String pageSelectorList() throws ParseException {String sel;
  LinkedList selectors = new LinkedList<String>();
    sel = pageSelector();
selectors.add(sel);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[42] = jj_gen;
          break label_27;
        }
        jj_consume_token(S);
      }
      sel = pageSelector();
selectors.add(sel);
    }
return String.join(", ", selectors);
}

//
// pageSelector
//   : pseudoPage+ | IDENT pseudoPage*
//   ;
//
  final public String pageSelector() throws ParseException {StringBuilder pseudos = new StringBuilder();
  String pseudo;
  Token ident;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      pseudo = pseudoPage();
pseudos.append(pseudo);
      break;
      }
    case IDENT:{
      ident = jj_consume_token(IDENT);
pseudos.append(unescape(ident.image, false));
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_28;
      }
      pseudo = pseudoPage();
pseudos.append(pseudo);
    }
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_29;
      }
      jj_consume_token(S);
    }
return pseudos.toString();
}

//
// pseudoPage
//   : ':' IDENT
//   ;
//
  final public String pseudoPage() throws ParseException {Token t;
    jj_consume_token(COLON);
    t = jj_consume_token(IDENT);
return ":" + unescape(t.image, false);
}

//
// font_face
//  : FONT_FACE_SYM S*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void fontFaceRule() throws ParseException {boolean start = false;
    Locator locator;
    try {
      jj_consume_token(FONT_FACE_SYM);
locator = createLocator(token);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          break label_30;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          break label_31;
        }
        jj_consume_token(S);
      }
start = true; handleStartFontFace(locator);
      styleDeclaration();
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
throw toCSSParseException("invalidFontFaceRule", e);
    } finally {
if (start) {
            handleEndFontFace();
        }
    }
}

//
// operator
//  : '/' S* | COMMA S* | /* empty */
//  ;
//
  final public LexicalUnit operator(LexicalUnit prev) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SLASH:{
      jj_consume_token(SLASH);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          break label_32;
        }
        jj_consume_token(S);
      }
return new LexicalUnitImpl(prev, LexicalUnitType.OPERATOR_SLASH);
      }
    case COMMA:{
      jj_consume_token(COMMA);
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          break label_33;
        }
        jj_consume_token(S);
      }
return LexicalUnitImpl.createComma(prev);
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// combinator
//  : PLUS S*
//  | GREATER S*
//  | S
//  ;
//
  final public char combinator() throws ParseException {char c = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      jj_consume_token(PLUS);
c='+';
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
      break;
      }
    case GREATER:{
      jj_consume_token(GREATER);
c='>';
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
      break;
      }
    case TILDE:{
      jj_consume_token(TILDE);
c='~';
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          break label_36;
        }
        jj_consume_token(S);
      }
      break;
      }
    case S:{
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case GREATER:
      case TILDE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:{
          jj_consume_token(PLUS);
c='+';
          break;
          }
        case GREATER:{
          jj_consume_token(GREATER);
c='>';
          break;
          }
        case TILDE:{
          jj_consume_token(TILDE);
c='~';
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_37:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[55] = jj_gen;
            break label_37;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return c;
}

//
// unary_operator
//  : '-' | PLUS
//  ;
//
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
return '-';
      }
    case PLUS:{
      jj_consume_token(PLUS);
return '+';
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// property
//   : IDENT S*
//   ;
//
  final public String property() throws ParseException {Token t;
    t = jj_consume_token(IDENT);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_38;
      }
      jj_consume_token(S);
    }
return unescape(t.image, false);
}

//
// ruleset
//  : selector [ COMMA S* selector ]*
//    '{' S* declaration [ ';' S* declaration ]* '}' S*
//  ;
//
  final public void styleRule() throws ParseException {SelectorList selList = null;
    boolean start = false;
    Token t;
    try {
t = token;
      selList = selectorList();
      jj_consume_token(LBRACE);
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          break label_39;
        }
        jj_consume_token(S);
      }
start = true;
            handleStartSelector(selList, createLocator(t.next));
      styleDeclaration();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RBRACE:{
        jj_consume_token(RBRACE);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (CSSParseException e) {
getErrorHandler().error(e);
        error_skipblock("ignoringRule", e);
    } catch (ParseException e) {
CSSParseException cpe = toCSSParseException("invalidStyleRule", e);
        getErrorHandler().error(cpe);
        error_skipblock("ignoringFollowingDeclarations", cpe);
    } finally {
if (start) {
            handleEndSelector(selList);
        }
    }
}

  final public SelectorList parseSelectorsInternal() throws ParseException {SelectorList selectors;
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_40;
      }
      jj_consume_token(S);
    }
    selectors = selectorList();
    jj_consume_token(0);
return selectors;
}

  final public SelectorList selectorList() throws ParseException {SelectorListImpl selList = new SelectorListImpl();
    Selector sel;
    sel = selector();
selList.setLocator(sel.getLocator());
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_42;
        }
        jj_consume_token(S);
      }
selList.add(sel);
      sel = selector();
selList.setLocator(sel.getLocator());
    }
selList.add(sel);
        return selList;
}

//
// selector
//   : simple_selector_sequence [ combinator simple_selector_sequence ]*
//   ;
//
  final public Selector selector() throws ParseException {Selector sel;
    char comb;
    try {
      sel = simpleSelector(null, ' ');
      label_43:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_43;
        }
        comb = combinator();
        sel = simpleSelector(sel, comb);
      }
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          break label_44;
        }
        jj_consume_token(S);
      }
return sel;    } catch (ParseException e) {
throw toCSSParseException("invalidSelector", e);
    }
}

//
// simple_selector
//  : element_name [ HASH | class | attrib | pseudo ]*
//  | [ HASH | class | attrib | pseudo ]+
//  ;
//
  final public Selector simpleSelector(Selector sel, char comb) throws ParseException {ElementSelector elemSel = null;
    SimpleSelector simpleSel = null;
    Condition c = null;
    SimpleSelector pseudoElementSel = null;
    Object o = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case ASTERISK:{
        elemSel = elementName();
        label_45:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:{
            ;
            break;
            }
          default:
            jj_la1[66] = jj_gen;
            break label_45;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case HASH:{
            c = hash(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case DOT:{
            c = _class(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case LSQUARE:{
            c = attrib(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case COLON:{
            o = pseudo(null != pseudoElementSel);
if (o instanceof Condition)
                      {  elemSel.addCondition((Condition) o);
                      } else {
                        pseudoElementSel = (SimpleSelector) o;
                      }
            break;
            }
          default:
            jj_la1[67] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case DOT:
      case COLON:
      case LSQUARE:
      case HASH:{
elemSel = new ElementSelector(null, createLocator(token));
        label_46:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case HASH:{
            c = hash(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case DOT:{
            c = _class(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case LSQUARE:{
            c = attrib(null != pseudoElementSel);
elemSel.addCondition(c);
            break;
            }
          case COLON:{
            o = pseudo(null != pseudoElementSel);
if (o instanceof Condition)
                      { elemSel.addCondition((Condition) o);
                      } else {
                        pseudoElementSel = (SimpleSelector) o;
                      }
            break;
            }
          default:
            jj_la1[68] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:
          case COLON:
          case LSQUARE:
          case HASH:{
            ;
            break;
            }
          default:
            jj_la1[69] = jj_gen;
            break label_46;
          }
        }
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
simpleSel = elemSel;
            if (sel == null) {
                sel = simpleSel;
            } else {
                switch (comb) {
                case ' ':
                    sel = new DescendantSelector(sel, simpleSel);
                    break;
                case '+':
                    sel = new DirectAdjacentSelector(sel, simpleSel);
                    break;
                case '>':
                    sel = new ChildSelector(sel, simpleSel);
                    break;
                case '~':
                    sel = new GeneralAdjacentSelector(sel, simpleSel);
                    break;
                }
            }
            if (pseudoElementSel != null)
            {
                sel = new DescendantSelector(sel, pseudoElementSel);
            }

            return sel;    } catch (ParseException e) {
throw toCSSParseException("invalidSimpleSelector", e);
    }
}

//
// class
//   : '.' IDENT
//   ;
//
  final public Condition _class(boolean pseudoElementFound) throws ParseException {Token t;
    Locator locator;
    ParseException pe = null;
    try {
if (pseudoElementFound) { pe = generateParseException(); }
      jj_consume_token(DOT);
locator = createLocator(token);
      t = jj_consume_token(IDENT);
if (pseudoElementFound) { throw pe;} 
            return new ClassCondition(unescape(t.image, false), locator);    } catch (ParseException e) {
throw toCSSParseException("invalidClassSelector", e);
    }
}

//
// element_name
//   : IDENT | '*'
//   ;
//
  final public ElementSelector elementName() throws ParseException {Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        t = jj_consume_token(IDENT);
return new ElementSelector(unescape(t.image, false), createLocator(t));
        }
      case ASTERISK:{
        jj_consume_token(ASTERISK);
return new ElementSelector(null, createLocator(token));
        }
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
throw toCSSParseException("invalidElementName", e);
    }
}

//
// attrib
//   : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH | PREFIXMATCH | SUFFIXMATCH | SUBSTRINGMATCH ] S*
//     [ IDENT | STRING ] S* ]? ']'
//   ;
//
  final public Condition attrib(boolean pseudoElementFound) throws ParseException {Token t;
    String name = null;
    String value = null;
    int type = 0;
    Locator locator;
    try {
      jj_consume_token(LSQUARE);
locator = createLocator(token);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          break label_47;
        }
        jj_consume_token(S);
      }
if (pseudoElementFound) { throw generateParseException();} 
      t = jj_consume_token(IDENT);
name = unescape(t.image, false);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INCLUDES:
      case DASHMATCH:
      case PREFIXMATCH:
      case SUFFIXMATCH:
      case SUBSTRINGMATCH:
      case EQUALS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PREFIXMATCH:{
          jj_consume_token(PREFIXMATCH);
type = 4;
          break;
          }
        case SUFFIXMATCH:{
          jj_consume_token(SUFFIXMATCH);
type = 5;
          break;
          }
        case SUBSTRINGMATCH:{
          jj_consume_token(SUBSTRINGMATCH);
type = 6;
          break;
          }
        case EQUALS:{
          jj_consume_token(EQUALS);
type = 1;
          break;
          }
        case INCLUDES:{
          jj_consume_token(INCLUDES);
type = 2;
          break;
          }
        case DASHMATCH:{
          jj_consume_token(DASHMATCH);
type = 3;
          break;
          }
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_49:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[75] = jj_gen;
            break label_49;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:{
          t = jj_consume_token(IDENT);
value = unescape(t.image, false);
          break;
          }
        case STRING:{
          t = jj_consume_token(STRING);
value = unescape(t.image, false);
          break;
          }
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_50:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[77] = jj_gen;
            break label_50;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        ;
      }
      jj_consume_token(RSQUARE);
Condition c = null;
            switch (type) {
            case 0:
                c = new AttributeCondition(name, null);
                break;
            case 1:
                c = new AttributeCondition(name, value);
                break;
            case 2:
                c = new OneOfAttributeCondition(name, value);
                break;
            case 3:
                c = new BeginHyphenAttributeCondition(name, value);
                break;
            case 4:
                c = new PrefixAttributeCondition(name, value);
                break;
            case 5:
                c = new SuffixAttributeCondition(name, value);
                break;
            case 6:
                c = new SubstringAttributeCondition(name, value);
                break;
            }
            c.setLocator(locator);
            return c;    } catch (ParseException e) {
throw toCSSParseException("invalidAttrib", e);
    }
}

//
// pseudo
//  : ':' (':')?
//        [ IDENT
//          | FUNCTION_NOT S* selector() S* ')'
//          | FUNCTION_LANG S* IDENT S* ')'
//          | FUNCTION S* ((PLUS | MINUS | DIMENSION | NUMBER | STRING | IDENT)? S*)+ ')'
//        ]
//  ;
//
  final public Object pseudo(boolean pseudoElementFound) throws ParseException {Condition c = null;
    Token t;
    String function;
    String arg;
    Selector sel;
    boolean doubleColon = false;
    Locator locator;
    try {
      jj_consume_token(COLON);
locator = createLocator(token);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
doubleColon = true;
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        t = jj_consume_token(IDENT);
String s = unescape(t.image, false);
                if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { s }, locator);} 
                if ("first-line".equals(s)
                    || "first-letter".equals(s)
                    || "before".equals(s)
                    || "after".equals(s))
                {
                    return new PseudoElementSelector(s, locator, doubleColon);                }
                return new PseudoClassCondition(s, locator, doubleColon);
        }
      case FUNCTION_NOT:{
        t = jj_consume_token(FUNCTION_NOT);
function = unescape(t.image, false);
        label_51:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[80] = jj_gen;
            break label_51;
          }
          jj_consume_token(S);
        }
        arg = negation_arg();
if ("".equals(arg)) { arg = "*"; }
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[81] = jj_gen;
            break label_52;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { function + arg + ")" }, locator);} 
                    return new PseudoClassCondition(function + arg + ")", locator, doubleColon);
        }
      case FUNCTION_LANG:{
        t = jj_consume_token(FUNCTION_LANG);
function = unescape(t.image, false);
        label_53:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[82] = jj_gen;
            break label_53;
          }
          jj_consume_token(S);
        }
        t = jj_consume_token(IDENT);
String lang = unescape(t.image, false);
        label_54:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[83] = jj_gen;
            break label_54;
          }
          jj_consume_token(S);
        }
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { "lang(" + lang + ")" }, locator);} 
                    return new LangCondition(lang, locator);
        }
      case FUNCTION:{
        t = jj_consume_token(FUNCTION);
function = unescape(t.image, false); StringBuilder args = new StringBuilder();
        label_55:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[84] = jj_gen;
            break label_55;
          }
          jj_consume_token(S);
        }
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case PLUS:{
            t = jj_consume_token(PLUS);
            break;
            }
          case MINUS:{
            t = jj_consume_token(MINUS);
            break;
            }
          case DIMENSION:{
            t = jj_consume_token(DIMENSION);
            break;
            }
          case NUMBER:{
            t = jj_consume_token(NUMBER);
            break;
            }
          case STRING:{
            t = jj_consume_token(STRING);
            break;
            }
          case IDENT:{
            t = jj_consume_token(IDENT);
            break;
            }
          default:
            jj_la1[85] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
args.append(unescape(t.image, false));
          label_57:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[86] = jj_gen;
              break label_57;
            }
            t = jj_consume_token(S);
args.append(unescape(t.image, false));
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NUMBER:
          case IDENT:
          case STRING:
          case MINUS:
          case PLUS:
          case DIMENSION:{
            ;
            break;
            }
          default:
            jj_la1[87] = jj_gen;
            break label_56;
          }
        }
        jj_consume_token(RROUND);
if (pseudoElementFound) { throw toCSSParseException("duplicatePseudo", new String[] { function + args.toString().trim() + ")" }, locator);} 
                    return new PseudoClassCondition(function + args.toString().trim() + ")", locator, doubleColon);
        }
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
throw toCSSParseException("invalidPseudo", e);
    }
}

  final public Condition hash(boolean pseudoElementFound) throws ParseException {Token t;
    ParseException pe = null;
    try {
if (pseudoElementFound) { pe = generateParseException(); }
      t = jj_consume_token(HASH);
if (pseudoElementFound) { throw pe;} 
            return new IdCondition(unescape(t.image.substring(1), false), createLocator(t));    } catch (ParseException e) {
throw toCSSParseException("invalidHash", e);
    }
}

  final public void styleDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case ASTERISK:{
      declaration();
      break;
      }
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    label_58:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        break label_58;
      }
      jj_consume_token(SEMICOLON);
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_59;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case ASTERISK:{
        declaration();
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        ;
      }
    }
}

//
// declaration
//   : property ':' S* expr prio?
//   |
//   ;
//
  final public void declaration() throws ParseException {String p;
  LexicalUnit e;
  Token t;
  boolean priority = false;
  Locator starHack = null;
  Locator locator = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
starHack = createLocator(token);
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      p = property();
locator = createLocator(token);
      jj_consume_token(COLON);
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[94] = jj_gen;
          break label_60;
        }
        jj_consume_token(S);
      }
      e = expr();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORTANT_SYM:{
        priority = prio();
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case UNKNOWN:{
        t = jj_consume_token(UNKNOWN);
locator = createLocator(t);
            CSSParseException cpe = toCSSParseException("invalidDeclarationInvalidChar", new String[] {t.image}, locator);
            getErrorHandler().error(cpe);
            error_skipdecl();
        break;
        }
      default:
        jj_la1[96] = jj_gen;
        ;
      }
if (starHack != null)
            {
                if (isIeStarHackAccepted()) {
                    handleProperty("*" + p, e, priority, locator);
                    {if ("" != null) return;}
                }
                CSSParseException cpe = toCSSParseException("invalidDeclarationStarHack", new Object[0], starHack);
                getErrorHandler().error(cpe);
                {if ("" != null) return;}
            }
            handleProperty(p, e, priority, locator);
    } catch (CSSParseException ex) {
getErrorHandler().error(ex);
        error_skipdecl();
    } catch (ParseException ex) {
CSSParseException cpe = toCSSParseException("invalidDeclaration", ex);
        getErrorHandler().error(cpe);
        error_skipdecl();
    }
}

//
// prio
//   : IMPORTANT_SYM S*
//   ;
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[97] = jj_gen;
        break label_61;
      }
      jj_consume_token(S);
    }
return true;
}

//
// expr
//   : term [ operator term ]*
//   ;
  final public LexicalUnit expr() throws ParseException {LexicalUnit head;
    LexicalUnit body;
    try {
      head = term(null);
body = head;
      label_62:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER:
        case INHERIT:
        case IDENT:
        case STRING:
        case SLASH:
        case MINUS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case REM:
        case EXS:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case UNICODE_RANGE:
        case URI:
        case FUNCTION:
        case 107:{
          ;
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          break label_62;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SLASH:
        case COMMA:{
          body = operator(body);
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          ;
        }
        body = term(body);
      }
return head;    } catch (ParseException ex) {
throw toCSSParseException("invalidExpr", ex);
    }
}

//
// term
//  : unary_operator?
//    [ NUMBER | PERCENTAGE | LENGTH | EMS | REM | EXS | ANGLE | TIME | FREQ | function ]
//  | STRING | IDENT | URI | hexcolor | DIMENSION
//  S*
//  ;
//
  final public LexicalUnit term(LexicalUnit prev) throws ParseException {Token t;
  char op = ' ';
  LexicalUnit value = null;
  Locator locator = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case PLUS:{
      op = unaryOperator();
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
if (op != ' ')
        {
            locator = createLocator(token);
        }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER:
    case EMS:
    case REM:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        t = jj_consume_token(NUMBER);
try
                {
                    value = LexicalUnitImpl.createNumber(prev, intValue(op, t.image));
                }
                catch (NumberFormatException e)
                {
                    value = LexicalUnitImpl.createNumber(prev, doubleValue(op, t.image));
                }
        break;
        }
      case PERCENTAGE:{
        t = jj_consume_token(PERCENTAGE);
value = LexicalUnitImpl.createPercentage(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_PX:{
        t = jj_consume_token(LENGTH_PX);
value = LexicalUnitImpl.createPixel(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_CM:{
        t = jj_consume_token(LENGTH_CM);
value = LexicalUnitImpl.createCentimeter(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_MM:{
        t = jj_consume_token(LENGTH_MM);
value = LexicalUnitImpl.createMillimeter(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_IN:{
        t = jj_consume_token(LENGTH_IN);
value = LexicalUnitImpl.createInch(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_PT:{
        t = jj_consume_token(LENGTH_PT);
value = LexicalUnitImpl.createPoint(prev, doubleValue(op, t.image));
        break;
        }
      case LENGTH_PC:{
        t = jj_consume_token(LENGTH_PC);
value = LexicalUnitImpl.createPica(prev, doubleValue(op, t.image));
        break;
        }
      case EMS:{
        t = jj_consume_token(EMS);
value = LexicalUnitImpl.createEm(prev, doubleValue(op, t.image));
        break;
        }
      case REM:{
        t = jj_consume_token(REM);
value = LexicalUnitImpl.createRem(prev, doubleValue(op, t.image));
        break;
        }
      case EXS:{
        t = jj_consume_token(EXS);
value = LexicalUnitImpl.createEx(prev, doubleValue(op, t.image));
        break;
        }
      case ANGLE_DEG:{
        t = jj_consume_token(ANGLE_DEG);
value = LexicalUnitImpl.createDegree(prev, doubleValue(op, t.image));
        break;
        }
      case ANGLE_RAD:{
        t = jj_consume_token(ANGLE_RAD);
value = LexicalUnitImpl.createRadian(prev, doubleValue(op, t.image));
        break;
        }
      case ANGLE_GRAD:{
        t = jj_consume_token(ANGLE_GRAD);
value = LexicalUnitImpl.createGradian(prev, doubleValue(op, t.image));
        break;
        }
      case TIME_MS:{
        t = jj_consume_token(TIME_MS);
value = LexicalUnitImpl.createMillisecond(prev, doubleValue(op, t.image));
        break;
        }
      case TIME_S:{
        t = jj_consume_token(TIME_S);
value = LexicalUnitImpl.createSecond(prev, doubleValue(op, t.image));
        break;
        }
      case FREQ_HZ:{
        t = jj_consume_token(FREQ_HZ);
value = LexicalUnitImpl.createHertz(prev, doubleValue(op, t.image));
        break;
        }
      case FREQ_KHZ:{
        t = jj_consume_token(FREQ_KHZ);
value = LexicalUnitImpl.createKiloHertz(prev, doubleValue(op, t.image));
        break;
        }
      case RESOLUTION_DPI:{
        t = jj_consume_token(RESOLUTION_DPI);
value = LexicalUnitImpl.createDimension(prev, doubleValue(op, t.image), "dpi");
        break;
        }
      case RESOLUTION_DPCM:{
        t = jj_consume_token(RESOLUTION_DPCM);
value = LexicalUnitImpl.createDimension(prev, doubleValue(op, t.image), "dpcm");
        break;
        }
      case FUNCTION:{
        value = function(prev);
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRING:{
      t = jj_consume_token(STRING);
value = LexicalUnitImpl.createString(prev, unescape(t.image, false));
      break;
      }
    case 107:{
      t = jj_consume_token(107);
value = LexicalUnitImpl.createIdent(prev, skipUnit().trim());
      break;
      }
    case IDENT:{
      t = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
throw toCSSParseException("invalidExprColon", new String[]{ unescape(t.image, false) }, createLocator(t));
        }
      default:
        jj_la1[102] = jj_gen;
        ;
      }
value = LexicalUnitImpl.createIdent(prev, unescape(t.image, false));
      break;
      }
    case URI:{
      t = jj_consume_token(URI);
value = LexicalUnitImpl.createURI(prev, unescape(t.image, true));
      break;
      }
    case UNICODE_RANGE:{
      value = unicodeRange(prev);
      break;
      }
    case HASH:{
      value = hexcolor(prev);
      break;
      }
    case DIMENSION:{
      t = jj_consume_token(DIMENSION);
int n = getLastNumPos(t.image);
                value = LexicalUnitImpl.createDimension(
                    prev,
                    doubleValue(op, t.image.substring(0, n+1)),
                    t.image.substring(n+1));
      break;
      }
    case INHERIT:{
      t = jj_consume_token(INHERIT);
value = new LexicalUnitImpl(prev, LexicalUnitType.INHERIT, t.image);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (locator == null)
            {
                locator = createLocator(token);
            }
    label_63:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[104] = jj_gen;
        break label_63;
      }
      jj_consume_token(S);
    }
if(value != null)
            {
              value.setLocator(locator);
            }
            return value;
}

//
// function
//   : FUNCTION S* ((EQUALS | COMMA | (unaryOperator? NUMBER) | STRING | IDENT | URI)? S*)+ ')' S*
//   ;
//
  final public LexicalUnit function(LexicalUnit prev) throws ParseException {Token t;
    LexicalUnit param = null;
    LexicalUnit body = null;
    String funct = "";
    t = jj_consume_token(FUNCTION);
funct = funct + unescape(t.image, false);
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        break label_64;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NUMBER:
    case INHERIT:
    case IDENT:
    case STRING:
    case MINUS:
    case PLUS:
    case HASH:
    case EMS:
    case REM:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case RESOLUTION_DPI:
    case RESOLUTION_DPCM:
    case PERCENTAGE:
    case DIMENSION:
    case UNICODE_RANGE:
    case URI:
    case FUNCTION:
    case 107:{
      param = term(null);
body = param;
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NUMBER:
        case INHERIT:
        case IDENT:
        case STRING:
        case MINUS:
        case EQUALS:
        case PLUS:
        case COMMA:
        case HASH:
        case EMS:
        case REM:
        case EXS:
        case LENGTH_PX:
        case LENGTH_CM:
        case LENGTH_MM:
        case LENGTH_IN:
        case LENGTH_PT:
        case LENGTH_PC:
        case ANGLE_DEG:
        case ANGLE_RAD:
        case ANGLE_GRAD:
        case TIME_MS:
        case TIME_S:
        case FREQ_HZ:
        case FREQ_KHZ:
        case RESOLUTION_DPI:
        case RESOLUTION_DPCM:
        case PERCENTAGE:
        case DIMENSION:
        case UNICODE_RANGE:
        case URI:
        case FUNCTION:
        case 107:{
          ;
          break;
          }
        default:
          jj_la1[106] = jj_gen;
          break label_65;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUALS:
        case COMMA:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            t = jj_consume_token(COMMA);
body = LexicalUnitImpl.createComma(body);
            break;
            }
          case EQUALS:{
            t = jj_consume_token(EQUALS);
body = LexicalUnitImpl.createIdent(body, t.image);
            break;
            }
          default:
            jj_la1[107] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_66:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[108] = jj_gen;
              break label_66;
            }
            jj_consume_token(S);
          }
          break;
          }
        default:
          jj_la1[109] = jj_gen;
          ;
        }
        body = term(body);
      }
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      ;
    }
    jj_consume_token(RROUND);
return functionInternal(prev, funct, param);
}

//
// negation_arg
//   : type_selector | universal | HASH | class | attrib | pseudo
//   ;
//
  final public String negation_arg() throws ParseException {Condition c = null;
    SimpleSelector simpleSel = null;
    Object o;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case ASTERISK:{
      simpleSel = elementName();
return simpleSel.toString();
      }
    case HASH:{
      c = hash(false);
return c.toString();
      }
    case DOT:{
      c = _class(false);
return c.toString();
      }
    case LSQUARE:{
      c = attrib(false);
return c.toString();
      }
    case COLON:{
      o = pseudo(false);
if (o instanceof Condition) { return o.toString();}          return new DescendantSelector(null, (SimpleSelector) o).toString();
      }
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

//
// unicodeRange
//
  final public LexicalUnit unicodeRange(LexicalUnit prev) throws ParseException {Token t;
    StringBuilder range = new StringBuilder();
    t = jj_consume_token(UNICODE_RANGE);
range.append(unescape(t.image, false));
return LexicalUnitImpl.createIdent(prev, range.toString().toUpperCase(Locale.ROOT));
}

//
// hexcolor
//   : HASH S*
//   ;
//
  final public LexicalUnit hexcolor(LexicalUnit prev) throws ParseException {Token t;
    t = jj_consume_token(HASH);
return hexcolorInternal(prev, t);
}

  String skip() throws ParseException {StringBuilder sb = new StringBuilder();
    int nesting = 0;
    Token t = getToken(0);
    if (t.image != null) {
        sb.append(t.image);
    }

    do {
        t = getNextToken();
        if (t.kind == EOF) {
            break;
        }
        sb.append(t.image);
        appendUnit(t, sb);

        if (t.kind == LBRACE) {
            nesting++;
        }
        else if (t.kind == RBRACE) {
            nesting--;
        }
    }
    while ((t.kind != RBRACE && t.kind != SEMICOLON) || nesting > 0);

    return sb.toString();
  }

  String skipUnit() throws ParseException {StringBuilder sb = new StringBuilder();

    Token t = token;
    Token oldToken = null;
    while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF ) {
        oldToken = t;
        sb.append(oldToken.image);
        appendUnit(t, sb);

        t = getNextToken();
    }
    if (t.kind != EOF) {
        token = oldToken;
    }

    return sb.toString();
  }

  void appendUnit(Token t, StringBuilder sb) throws ParseException {if (t.kind == EMS) {
      sb.append("ems");
      return;
    }
    if (t.kind == REM) {
      sb.append("rem");
      return;
    }
    if (t.kind == EXS) {
      sb.append("ex");
      return;
    }
    if (t.kind == LENGTH_PX) {
      sb.append("px");
      return;
    }
    if (t.kind == LENGTH_CM) {
      sb.append("cm");
      return;
    }
    if (t.kind == LENGTH_MM) {
      sb.append("mm");
      return;
    }
    if (t.kind == LENGTH_IN) {
      sb.append("in");
      return;
    }
    if (t.kind == LENGTH_PT) {
      sb.append("pt");
      return;
    }
    if (t.kind == LENGTH_PC) {
      sb.append("pc");
      return;
    }
    if (t.kind == ANGLE_DEG) {
      sb.append("deg");
      return;
    }
    if (t.kind == ANGLE_RAD) {
      sb.append("rad");
      return;
    }
    if (t.kind == ANGLE_GRAD) {
      sb.append("grad");
      return;
    }
    if (t.kind == TIME_MS) {
      sb.append("ms");
      return;
    }
    if (t.kind == TIME_S) {
      sb.append('s');
      return;
    }
    if (t.kind == FREQ_HZ) {
      sb.append("hz");
      return;
    }
    if (t.kind == FREQ_KHZ) {
      sb.append("khz");
      return;
    }
    if (t.kind == RESOLUTION_DPI) {
      sb.append("dpi");
      return;
    }
    if (t.kind == RESOLUTION_DPCM) {
      sb.append("dpcm");
      return;
    }
    if (t.kind == PERCENTAGE) {
      sb.append('%');
      return;
    }
  }

  void error_skipblock(String msgKey, CSSParseException e) throws ParseException {if (msgKey != null) {
        getErrorHandler().warning(createSkipWarning(msgKey, e));
    }

    Token t;
    int nesting = 0;
    do {
        t = getNextToken();
        if (t.kind == LBRACE) {
            nesting++;
        }
        else if (t.kind == RBRACE) {
            nesting--;
        }
    }
    while (t.kind != EOF && (t.kind != RBRACE || nesting > 0));
  }

  void error_skipdecl() throws ParseException {Token t = getToken(1);
    if (t.kind == LBRACE) {
        error_skipblock(null, null);
        return;
    }
    if (t.kind == RBRACE) {
        // next will be RBRACE so we are finished
        return;
    }

    Token oldToken = token;
    while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF) {
        oldToken = t;
        t = getNextToken();
    }
    if (t.kind != EOF) {
        token = oldToken;
    }
  }

  void error_skipAtRule() throws ParseException {Token t = null;
    do {
        t = getNextToken();
    }
    while (t.kind != SEMICOLON && t.kind != EOF);
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_73()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(TILDE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(GREATER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_67()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(GREATER)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_67()) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    Token xsp;
    if (jj_3R_77()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_77()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public CSS3ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[112];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x2,0x2,0x2,0x2,0x0,0x400000,0x400000,0x400000,0x2,0x2,0x2,0x400000,0x2,0x2,0x2000000,0x2,0x4c0000,0x2,0x2,0x400000,0x0,0x2,0xc0000,0x2,0xc0000,0x20000,0x2,0x20000,0x2,0x4c0000,0x2,0x2,0x0,0x2,0x400000,0x2,0x400000,0x2,0x2,0x400000,0x2,0x0,0x2,0x400000,0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0x0,0x2,0x2,0x1,0x2,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x400000,0x400000,0x2,0x2,0x0,0x2,0x2400000,0x2,0x0,0x0,0x2,0x2,0x2,0x2,0x2,0x2500000,0x2,0x2500000,0x400000,0x400000,0x0,0x2,0x400000,0x0,0x2,0x0,0x0,0x2,0x2700000,0x0,0x0,0x100000,0x0,0x2700000,0x2,0x2,0x2700000,0x0,0x2,0x0,0x2700000,0x400000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x30000,0x30000,0x30000,0x30000,0x0,0x68000000,0x68000000,0x68000000,0x30000,0x30000,0x0,0x68000000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x68000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x20000000,0x0,0x68000000,0x0,0x68000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x28000000,0x28000000,0x28000000,0x28000000,0x68000000,0x40000000,0x0,0x0,0x7c0000,0x0,0x0,0x0,0x7c0000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x10000000,0x0,0x40000000,0x40000000,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x68000000,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x2000,0x1d04,0x1f04,0x1f04,0x0,0x0,0x0,0x3f04,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf04,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf04,0x0,0xf04,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x70,0x0,0x70,0x70,0x11,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x104,0x104,0x104,0x104,0x104,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0xffff8191,0x80,0x11,0xffff8000,0x0,0xffff8100,0x0,0x0,0xffff8193,0x82,0x0,0x82,0xffff8111,0x104,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x200,0x0,0x0,0x0,0x200,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x4,0x1c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x937,0x0,0x0,0x103,0x0,0x937,0x0,0x0,0x937,0x0,0x0,0x0,0x937,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public CSS3Parser(CharStream stream) {
	 token_source = new CSS3ParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 112; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 112; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CSS3Parser(CSS3ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 112; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CSS3ParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 112; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[108];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 112; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 108; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 1; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
