package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;
/**
 * Kernel<br>
 * <i>native declaration : morph.h:31</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_Kernel extends Structure {
	/**
	 * kernel height<br>
	 * C type : l_int32
	 */
	public int sy;
	/**
	 * kernel width<br>
	 * C type : l_int32
	 */
	public int sx;
	/**
	 * y location of kernel origin<br>
	 * C type : l_int32
	 */
	public int cy;
	/**
	 * x location of kernel origin<br>
	 * C type : l_int32
	 */
	public int cx;
	/**
	 * data[i][j] in [row][col] order<br>
	 * C type : l_float32**
	 */
	public PointerByReference data;
	public L_Kernel() {
		super();
	}
	/**
	 * Gets this Structure's field names in their proper order.
	 * @return list of ordered field names
	 */
	@Override
	protected List<String> getFieldOrder() {
		return Arrays.asList("sy", "sx", "cy", "cx", "data");
	}
	/**
	 * @param sy kernel height<br>
	 * C type : l_int32<br>
	 * @param sx kernel width<br>
	 * C type : l_int32<br>
	 * @param cy y location of kernel origin<br>
	 * C type : l_int32<br>
	 * @param cx x location of kernel origin<br>
	 * C type : l_int32<br>
	 * @param data data[i][j] in [row][col] order<br>
	 * C type : l_float32**
	 */
	public L_Kernel(int sy, int sx, int cy, int cx, PointerByReference data) {
		super();
		this.sy = sy;
		this.sx = sx;
		this.cy = cy;
		this.cx = cx;
		this.data = data;
	}
	public L_Kernel(Pointer peer) {
		super(peer);
		read();
	}
	public static class ByReference extends L_Kernel implements Structure.ByReference {
		
	};
	public static class ByValue extends L_Kernel implements Structure.ByValue {
		
	};
}
