package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
/**
 * -------------------------------------------------------------*<br>
 *                       BMP file header                       *<br>
 * -------------------------------------------------------------<br>
 * <i>native declaration : bmp.h:17</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class BMP_FileHeader extends Structure {
	/**
	 * file type; must be "BM"<br>
	 * C type : l_int16
	 */
	public short bfType;
	/**
	 * length of the file;<br>
	 * sizeof(BMP_FileHeader) +<br>
	 * sizeof(BMP_InfoHeader) +<br>
	 * size of color table +<br>
	 * size of DIB bits<br>
	 * C type : l_int16
	 */
	public short bfSize;
	/**
	 * remainder of the bfSize field<br>
	 * C type : l_int16
	 */
	public short bfFill1;
	/**
	 * don't care (set to 0)<br>
	 * C type : l_int16
	 */
	public short bfReserved1;
	/**
	 * don't care (set to 0)<br>
	 * C type : l_int16
	 */
	public short bfReserved2;
	/**
	 * offset from beginning of file<br>
	 * C type : l_int16
	 */
	public short bfOffBits;
	/**
	 * remainder of the bfOffBits field<br>
	 * C type : l_int16
	 */
	public short bfFill2;
	public BMP_FileHeader() {
		super();
	}
	protected List<? > getFieldOrder() {
		return Arrays.asList("bfType", "bfSize", "bfFill1", "bfReserved1", "bfReserved2", "bfOffBits", "bfFill2");
	}
	/**
	 * @param bfType file type; must be "BM"<br>
	 * C type : l_int16<br>
	 * @param bfSize length of the file;<br>
	 * sizeof(BMP_FileHeader) +<br>
	 * sizeof(BMP_InfoHeader) +<br>
	 * size of color table +<br>
	 * size of DIB bits<br>
	 * C type : l_int16<br>
	 * @param bfFill1 remainder of the bfSize field<br>
	 * C type : l_int16<br>
	 * @param bfReserved1 don't care (set to 0)<br>
	 * C type : l_int16<br>
	 * @param bfReserved2 don't care (set to 0)<br>
	 * C type : l_int16<br>
	 * @param bfOffBits offset from beginning of file<br>
	 * C type : l_int16<br>
	 * @param bfFill2 remainder of the bfOffBits field<br>
	 * C type : l_int16
	 */
	public BMP_FileHeader(short bfType, short bfSize, short bfFill1, short bfReserved1, short bfReserved2, short bfOffBits, short bfFill2) {
		super();
		this.bfType = bfType;
		this.bfSize = bfSize;
		this.bfFill1 = bfFill1;
		this.bfReserved1 = bfReserved1;
		this.bfReserved2 = bfReserved2;
		this.bfOffBits = bfOffBits;
		this.bfFill2 = bfFill2;
	}
	public BMP_FileHeader(Pointer peer) {
		super(peer);
		read();
	}
	public static class ByReference extends BMP_FileHeader implements Structure.ByReference {
		
	};
	public static class ByValue extends BMP_FileHeader implements Structure.ByValue {
		
	};
}
