/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.cache.AnalysisCache;
import net.sourceforge.pmd.cache.FileAnalysisCache;
import net.sourceforge.pmd.cache.NoopAnalysisCache;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.IOUtil;

public class PMDConfiguration
extends AbstractConfiguration {
    private String suppressMarker = "NOPMD";
    private int threads = Runtime.getRuntime().availableProcessors();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private LanguageVersionDiscoverer languageVersionDiscoverer = new LanguageVersionDiscoverer();
    private String ruleSets;
    private RulePriority minimumPriority = RulePriority.LOW;
    private String inputPaths;
    private String inputUri;
    private String inputFilePath;
    private boolean ruleSetFactoryCompatibilityEnabled = true;
    private String reportFormat;
    private String reportFile;
    private boolean reportShortNames = false;
    private Properties reportProperties = new Properties();
    private boolean showSuppressedViolations = false;
    private boolean failOnViolation = true;
    private boolean stressTest;
    private boolean benchmark;
    private AnalysisCache analysisCache = new NoopAnalysisCache();

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public void prependClasspath(String classpath) throws IOException {
        if (this.classLoader == null) {
            this.classLoader = PMDConfiguration.class.getClassLoader();
        }
        if (classpath != null) {
            this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
        }
    }

    public LanguageVersionDiscoverer getLanguageVersionDiscoverer() {
        return this.languageVersionDiscoverer;
    }

    public void setDefaultLanguageVersion(LanguageVersion languageVersion) {
        this.setDefaultLanguageVersions(Arrays.asList(languageVersion));
    }

    public void setDefaultLanguageVersions(List<LanguageVersion> languageVersions) {
        for (LanguageVersion languageVersion : languageVersions) {
            this.languageVersionDiscoverer.setDefaultLanguageVersion(languageVersion);
        }
    }

    public LanguageVersion getLanguageVersionOfFile(String fileName) {
        LanguageVersion languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersionForFile(fileName);
        if (languageVersion == null) {
            languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersion(LanguageRegistry.getLanguage("Java"));
        }
        return languageVersion;
    }

    public String getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(String ruleSets) {
        this.ruleSets = ruleSets;
    }

    public RulePriority getMinimumPriority() {
        return this.minimumPriority;
    }

    public void setMinimumPriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    public String getInputPaths() {
        return this.inputPaths;
    }

    public void setInputPaths(String inputPaths) {
        this.inputPaths = inputPaths;
    }

    public String getInputFilePath() {
        return this.inputFilePath;
    }

    public void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public String getInputUri() {
        return this.inputUri;
    }

    public void setInputUri(String inputUri) {
        this.inputUri = inputUri;
    }

    public boolean isReportShortNames() {
        return this.reportShortNames;
    }

    public void setReportShortNames(boolean reportShortNames) {
        this.reportShortNames = reportShortNames;
    }

    public Renderer createRenderer() {
        return this.createRenderer(false);
    }

    public Renderer createRenderer(boolean withReportWriter) {
        Renderer renderer = RendererFactory.createRenderer(this.reportFormat, this.reportProperties);
        renderer.setShowSuppressedViolations(this.showSuppressedViolations);
        if (withReportWriter) {
            renderer.setWriter(IOUtil.createWriter(this.reportFile));
        }
        return renderer;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    public Properties getReportProperties() {
        return this.reportProperties;
    }

    public void setReportProperties(Properties reportProperties) {
        this.reportProperties = reportProperties;
    }

    public boolean isStressTest() {
        return this.stressTest;
    }

    public void setStressTest(boolean stressTest) {
        this.stressTest = stressTest;
    }

    public boolean isBenchmark() {
        return this.benchmark;
    }

    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public boolean isRuleSetFactoryCompatibilityEnabled() {
        return this.ruleSetFactoryCompatibilityEnabled;
    }

    public void setRuleSetFactoryCompatibilityEnabled(boolean ruleSetFactoryCompatibilityEnabled) {
        this.ruleSetFactoryCompatibilityEnabled = ruleSetFactoryCompatibilityEnabled;
    }

    public AnalysisCache getAnalysisCache() {
        return this.analysisCache;
    }

    public void setAnalysisCache(AnalysisCache cache) {
        this.analysisCache = cache == null ? new NoopAnalysisCache() : cache;
    }

    public void setAnalysisCacheLocation(String cacheLocation) {
        if (cacheLocation == null) {
            this.setAnalysisCache(new NoopAnalysisCache());
        } else {
            this.setAnalysisCache(new FileAnalysisCache(new File(cacheLocation)));
        }
    }
}

