/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.cache.AbstractAnalysisCache;
import net.sourceforge.pmd.cache.AnalysisResult;
import net.sourceforge.pmd.cache.CachedRuleViolation;

public class FileAnalysisCache
extends AbstractAnalysisCache {
    private final File cacheFile;

    public FileAnalysisCache(File cache) {
        this.cacheFile = cache;
        this.loadFromFile(cache);
    }

    private void loadFromFile(File cacheFile) {
        if (cacheFile.exists()) {
            try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));){
                String cacheVersion = inputStream.readUTF();
                if (PMD.VERSION.equals(cacheVersion)) {
                    this.rulesetChecksum = inputStream.readLong();
                    this.classpathChecksum = inputStream.readLong();
                    while (inputStream.available() > 0) {
                        String fileName = inputStream.readUTF();
                        long checksum = inputStream.readLong();
                        int countViolations = inputStream.readInt();
                        ArrayList<RuleViolation> violations = new ArrayList<RuleViolation>(countViolations);
                        for (int i = 0; i < countViolations; ++i) {
                            violations.add(CachedRuleViolation.loadFromStream(inputStream, fileName, this.ruleMapper));
                        }
                        this.fileResultsCache.put(fileName, new AnalysisResult(checksum, violations));
                    }
                } else {
                    LOG.info("Analysis cache invalidated, PMD version changed.");
                }
            }
            catch (EOFException e) {
                LOG.warning("Cache file " + cacheFile.getPath() + " is malformed, will not be used for current analysis");
            }
            catch (IOException e) {
                LOG.severe("Could not load analysis cache to file. " + e.getMessage());
            }
        }
    }

    @Override
    public void persist() {
        File parentFile;
        if (!this.cacheFile.exists() && (parentFile = this.cacheFile.getAbsoluteFile().getParentFile()) != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));){
            outputStream.writeUTF(this.pmdVersion);
            outputStream.writeLong(this.rulesetChecksum);
            outputStream.writeLong(this.classpathChecksum);
            for (Map.Entry resultEntry : this.updatedResultsCache.entrySet()) {
                List<RuleViolation> violations = ((AnalysisResult)resultEntry.getValue()).getViolations();
                outputStream.writeUTF((String)resultEntry.getKey());
                outputStream.writeLong(((AnalysisResult)resultEntry.getValue()).getFileChecksum());
                outputStream.writeInt(violations.size());
                for (RuleViolation rv : violations) {
                    CachedRuleViolation.storeToStream(outputStream, rv);
                }
            }
        }
        catch (IOException e) {
            LOG.severe("Could not persist analysis cache to file. " + e.getMessage());
        }
    }
}

