/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xpath;

import net.sf.saxon.sxpath.IndependentContext;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.xpath.MatchesFunction;
import net.sourceforge.pmd.lang.xpath.PMDFunctions;

public class Initializer {
    private Initializer() {
    }

    public static void initialize() {
    }

    public static void initialize(IndependentContext context) {
        context.declareNamespace("pmd", "java:" + PMDFunctions.class.getName());
        for (Language language : LanguageRegistry.getLanguages()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
                if (languageVersionHandler == null) continue;
                languageVersionHandler.getXPathHandler().initialize(context);
            }
        }
    }

    private static void initializeGlobal() {
        MatchesFunction.registerSelfInSimpleContext();
    }

    private static void initializeLanguages() {
        for (Language language : LanguageRegistry.getLanguages()) {
            for (LanguageVersion languageVersion : language.getVersions()) {
                LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
                if (languageVersionHandler == null) continue;
                languageVersionHandler.getXPathHandler().initialize();
            }
        }
    }

    static {
        Initializer.initializeGlobal();
        Initializer.initializeLanguages();
    }
}

